/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (C) 2014 Dimitar Toshkov Zhekov.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * This is the "Terminus BSD Console" font.  It is identical to the standard
 * variant of Terminus Font 8x16, but provided under the 2-clause BSD License
 * (FreeBSD License).  Please contribute any changes back to Mr. Zhekov at
 * <dimitar.zhekov@gmail.com>.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/12/sys/dev/vt/font/vt_font_default.c 332452 2018-04-12 20:21:04Z emaste $");

#include <dev/vt/vt.h>

static uint8_t font_bytes[2224 * 16] = {
	0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x7e, 0x24, 0x24,
	0x7e, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c,
	0x92, 0x90, 0x90, 0x7c, 0x12, 0x12, 0x92, 0x7c, 0x10, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x64, 0x94, 0x68, 0x08, 0x10, 0x10, 0x20, 0x2c, 0x52, 0x4c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x30, 0x4a,
	0x44, 0x44, 0x44, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x24, 0x18, 0x7e, 0x18, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10,
	0x20, 0x20, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x04, 0x08,
	0x10, 0x20, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x02, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x06, 0x0a, 0x12, 0x22, 0x42, 0x7e, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x7c, 0x02,
	0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x20,
	0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04,
	0x08, 0x10, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x04, 0x08, 0x08, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x82, 0x9e, 0xa2, 0xa2, 0xa2, 0xa6, 0x9a, 0x80, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x7e,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42,
	0x42, 0x42, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x44, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x44, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40,
	0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x4e,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44,
	0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa, 0x92, 0x92, 0x82,
	0x82, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x4a, 0x3c, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x50, 0x48, 0x44, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x02,
	0x02, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24,
	0x24, 0x24, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82,
	0x82, 0x82, 0x82, 0x92, 0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02,
	0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10,
	0x08, 0x08, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10,
	0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x04, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x42, 0x44, 0x48,
	0x70, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x5e, 0x60, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x92,
	0x92, 0x92, 0x92, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04, 0x08,
	0x10, 0x20, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x10,
	0x10, 0x10, 0x20, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x08, 0x08, 0x08, 0x04, 0x08,
	0x08, 0x08, 0x08, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x92, 0x8c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x92, 0x90,
	0x90, 0x90, 0x92, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x20, 0x20, 0x78, 0x20, 0x20, 0x20, 0x22, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x44, 0x38, 0x44, 0x44, 0x44, 0x38, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x28, 0x10, 0x7c,
	0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x40, 0x30, 0x48, 0x44, 0x44, 0x24, 0x18, 0x04, 0x44,
	0x38, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e,
	0x81, 0x99, 0xa5, 0xa1, 0xa5, 0x99, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x04, 0x3c, 0x44, 0x3c, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x48,
	0x90, 0x48, 0x24, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x81, 0xb9, 0xa5, 0xb9,
	0xa9, 0xa5, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c,
	0x10, 0x10, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x04,
	0x08, 0x10, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x04, 0x18, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x7a, 0x40, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x7e, 0x92, 0x92, 0x92, 0x92, 0x72, 0x12, 0x12, 0x12, 0x12,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x00,
	0x00, 0x10, 0x30, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x90, 0x48, 0x24, 0x12, 0x24, 0x48, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x60, 0x20, 0x22, 0x24, 0x08, 0x10, 0x22, 0x46, 0x8a, 0x1e,
	0x02, 0x02, 0x00, 0x00, 0x00, 0x20, 0x60, 0x20, 0x22, 0x24, 0x08, 0x10,
	0x20, 0x4c, 0x92, 0x04, 0x08, 0x1e, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x60,
	0x12, 0xe4, 0x08, 0x10, 0x22, 0x46, 0x8a, 0x1e, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x20, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x18, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x90, 0x90, 0x90, 0xfc, 0x90,
	0x90, 0x90, 0x90, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x10, 0x10, 0x20, 0x00,
	0x10, 0x08, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x7e,
	0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x24, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x38,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x44,
	0x42, 0x42, 0xf2, 0x42, 0x42, 0x42, 0x44, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x32, 0x4c, 0x00, 0x42, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x43, 0x42, 0x46, 0x4a, 0x52,
	0x62, 0x42, 0xc2, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42,
	0x42, 0x7c, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44,
	0x44, 0x48, 0x7c, 0x42, 0x42, 0x42, 0x62, 0x5c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x02, 0x3e,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x02, 0x3e,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x18, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x12, 0x72, 0x9e, 0x90, 0x90, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40,
	0x40, 0x40, 0x42, 0x3c, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x10, 0x08,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x30, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x48,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x48, 0x48, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x10, 0x28, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c,
	0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x08, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x00, 0x7c, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x3c, 0x46, 0x4a, 0x52, 0x62, 0x42, 0xbc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
	0x00, 0x00, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18,
	0x00, 0x3c, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42,
	0x02, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x3e,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x04, 0x03, 0x00, 0x08, 0x10, 0x00, 0x3c,
	0x42, 0x42, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40,
	0x40, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x3c, 0x42, 0x40,
	0x40, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c,
	0x42, 0x42, 0x40, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x78, 0x44, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x44, 0x78, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x02, 0x02,
	0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x0f, 0x02, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x18, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x7e,
	0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40,
	0x40, 0x40, 0x40, 0x7e, 0x02, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c, 0x08, 0x10, 0x0c, 0x00,
	0x18, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x4e, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x3e, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x24, 0x18, 0x00, 0x3c,
	0x42, 0x42, 0x40, 0x4e, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x3c, 0x00, 0x10, 0x10, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x4e,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
	0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x4e, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x10, 0x10, 0x20, 0x00, 0x04, 0x08, 0x08, 0x00, 0x3e, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x18, 0x24, 0x00, 0x42,
	0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x12, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0xff, 0x42, 0x42, 0x7e, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf0,
	0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x32, 0x4c, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x58, 0x00, 0x30, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x38, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x78, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x30,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x10, 0x20, 0x18, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x30, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x10, 0x20, 0x18, 0x00, 0x10, 0x10, 0x00, 0x38,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x52, 0x52, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x00, 0xc6, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe2, 0x12, 0x12, 0x0c, 0x00,
	0x0c, 0x12, 0x00, 0x0e, 0x04, 0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x00, 0x0c, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x42, 0x44,
	0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x10, 0x10, 0x20,
	0x00, 0x00, 0x40, 0x40, 0x40, 0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42,
	0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x48,
	0x70, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x00, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x30, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x10, 0x10, 0x20,
	0x24, 0x18, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x48, 0x30, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40,
	0x40, 0x40, 0x44, 0x44, 0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x11, 0x11, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x60, 0xc0,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10,
	0x10, 0x10, 0x18, 0x30, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42, 0x00, 0x10, 0x10, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x10, 0x10, 0x20, 0x24, 0x18, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a,
	0x46, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18,
	0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x80, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a,
	0x46, 0x42, 0x42, 0x42, 0x02, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x02, 0x02, 0x0c, 0x00,
	0x3c, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x3c,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x90, 0x90, 0x90, 0x9c, 0x90, 0x90, 0x90, 0x90, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x92,
	0x9e, 0x90, 0x90, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7c,
	0x42, 0x42, 0x42, 0x7c, 0x50, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x5e, 0x60, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x50, 0x48, 0x44, 0x42, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x5e, 0x60, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x40, 0x40, 0x80,
	0x24, 0x18, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x7c, 0x50, 0x48, 0x44, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x5e, 0x60, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x3c,
	0x42, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x08, 0x00, 0x3e, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c,
	0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x3e, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x42, 0x42, 0x3c,
	0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40,
	0x3c, 0x02, 0x02, 0x7c, 0x10, 0x10, 0x20, 0x00, 0x24, 0x18, 0x00, 0x3c,
	0x42, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x3e, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e, 0x04, 0x04, 0x08, 0x00,
	0x24, 0x18, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10,
	0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x38, 0x10, 0x10, 0x10, 0x0e,
	0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x18, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x18, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x12, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x08, 0x10, 0x0c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x04, 0x03, 0x00, 0x18, 0x24, 0x00, 0x82, 0x82, 0x82, 0x82, 0x92,
	0x92, 0xaa, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24,
	0x00, 0x82, 0x82, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x44, 0x44, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x10,
	0x20, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x7e, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x7e, 0x04, 0x08,
	0x10, 0x20, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x7e,
	0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x18, 0x00, 0x7e, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x02, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x02, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x02, 0x02, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x7e, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42,
	0x42, 0x40, 0x38, 0x40, 0x40, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x12, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x90, 0x60, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a,
	0x46, 0x42, 0x42, 0x42, 0x40, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x02, 0x02, 0x02, 0x00,
	0x00, 0x00, 0x7e, 0x02, 0x04, 0x08, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x3c, 0x02,
	0x02, 0x42, 0x42, 0x3c, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3e, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x7c, 0x00, 0x10, 0x10, 0x20,
	0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0e, 0x00, 0x04, 0x04, 0x08, 0x7c, 0x00, 0x82, 0x82,
	0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x02, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x7e, 0x02, 0x02, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02, 0x02,
	0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x40, 0x38, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x40, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x04,
	0x08, 0x1c, 0x02, 0x02, 0x42, 0x42, 0x3c, 0x00, 0x08, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x03, 0x00,
	0x32, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x40, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x7e,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x40, 0x80, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x38, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x40, 0x80, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x40, 0x80, 0x3c, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x48, 0x48, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x28, 0x28, 0x44, 0x44, 0x44, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x5a, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44,
	0x44, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00,
	0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x20, 0x10, 0x08, 0x08,
	0x10, 0x20, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c,
	0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x24, 0x24, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x3a, 0x46, 0x44, 0x44, 0x44, 0x46, 0x3a, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x3c, 0x42, 0x40, 0x38, 0x40, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x10, 0x00, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x46, 0x44,
	0x44, 0x44, 0x46, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44,
	0x44, 0x48, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10,
	0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x3e, 0x10, 0x08, 0x3c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x04,
	0x08, 0x10, 0x20, 0x40, 0x40, 0x40, 0x40, 0x3c, 0x02, 0x02, 0x04, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20,
	0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x3c, 0x40, 0x40, 0x40, 0x40, 0x3c,
	0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x40, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x40, 0x3c,
	0x02, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x44, 0x44,
	0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x92, 0x92,
	0x92, 0x92, 0x92, 0x7c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c,
	0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x82, 0x92,
	0x92, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48,
	0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10,
	0x00, 0x44, 0x82, 0x92, 0x92, 0x92, 0x92, 0x6c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x3e, 0x04, 0xc4, 0x44, 0x44, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0x92, 0x92,
	0x92, 0x92, 0x92, 0x7c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc2, 0x24, 0x18, 0x10, 0x30, 0x48, 0x86, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c,
	0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x1e, 0x20, 0x40, 0x7c, 0x40, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x3e, 0x02, 0x04, 0x78,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x3c, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x24, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x7e,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x50, 0x90, 0x9c, 0x92, 0x92,
	0x92, 0x92, 0x92, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90,
	0x90, 0x9c, 0xf2, 0x92, 0x92, 0x92, 0x92, 0x9c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf8, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x42, 0x44, 0x48, 0x50, 0x60, 0x60,
	0x50, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x42, 0x42,
	0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x18, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x40,
	0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe,
	0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x54, 0x38, 0x54,
	0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x18, 0x42, 0x42, 0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x12, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x7c, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7c,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92,
	0x92, 0x92, 0x92, 0x7f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40,
	0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x82, 0x82, 0x82, 0xf2, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0xf2,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x1e, 0x02,
	0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x92,
	0x92, 0x92, 0x92, 0xf2, 0x92, 0x92, 0x92, 0x8c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x0a, 0x12, 0x22, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x40, 0x40, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44,
	0x44, 0x48, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x54,
	0x38, 0x54, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x02, 0x1c, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6, 0xaa,
	0x92, 0x82, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x92,
	0x92, 0x92, 0x92, 0x7f, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0xf2, 0x8a, 0x8a, 0x8a, 0xf2,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x78,
	0x44, 0x44, 0x44, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x02, 0x1e, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x92, 0x92, 0xf2, 0x92, 0x92, 0x8c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x42, 0x42,
	0x3e, 0x12, 0x22, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf0,
	0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x02, 0x02, 0x0c, 0x00,
	0x00, 0x00, 0x08, 0x10, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x40,
	0x78, 0x40, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x70, 0x90, 0x9c, 0x92, 0x92, 0x92, 0x9c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90, 0x9c, 0xf2, 0x92, 0x92, 0x9c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x10, 0x00, 0x42, 0x44, 0x48,
	0x70, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18,
	0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e,
	0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x40, 0xf0, 0x40, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20,
	0x78, 0x20, 0x20, 0x3c, 0x22, 0x22, 0x22, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x82, 0x44, 0x28, 0x38, 0x54, 0x92, 0x92, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x44, 0x28,
	0x38, 0x54, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x7e, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x02, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0xf8, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0x40, 0x40, 0xf8, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42,
	0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40,
	0x78, 0x44, 0x44, 0x44, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92,
	0x92, 0x54, 0x38, 0x54, 0x92, 0x92, 0x92, 0x93, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92, 0x54, 0x38, 0x54, 0x92, 0x93,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x1c, 0x02,
	0x02, 0x42, 0x42, 0x3c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x02, 0x1c, 0x02, 0x42, 0x3c, 0x10, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x42, 0x44, 0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x43,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x44, 0x48,
	0x70, 0x48, 0x44, 0x43, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x54, 0x58, 0x70, 0x70, 0x58, 0x54, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x54, 0x58, 0x70, 0x58, 0x54, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x44, 0x48, 0x50, 0x60, 0x60,
	0x50, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc2, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x43,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42,
	0x7e, 0x42, 0x42, 0x43, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x47, 0x44,
	0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x40, 0x40, 0x40,
	0x40, 0x42, 0x42, 0x3c, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x40, 0x40, 0x40, 0x42, 0x3c, 0x10, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x10, 0x7c, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44,
	0x44, 0x28, 0x28, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42, 0x43, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x43,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x4a, 0x4a, 0x3e, 0x0a, 0x0a, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x4a, 0x4a,
	0x3e, 0x0a, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40,
	0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x7c, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x18, 0x00, 0x92, 0x92, 0x92, 0x54, 0x38,
	0x54, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x18,
	0x00, 0x92, 0x92, 0x54, 0x38, 0x54, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x24, 0x00, 0x3c, 0x42, 0x02, 0x02, 0x7e, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x02, 0x02,
	0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x92,
	0x92, 0x92, 0x54, 0x38, 0x54, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x44, 0x00, 0x92, 0x92, 0x54, 0x38, 0x54, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x02, 0x1c,
	0x02, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
	0x00, 0x3c, 0x42, 0x02, 0x1c, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x3c, 0x00, 0x42, 0x42, 0x42, 0x46, 0x4a, 0x52, 0x62, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x46, 0x4a,
	0x52, 0x62, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x24, 0x24, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x3c,
	0x42, 0x02, 0x02, 0x1e, 0x02, 0x02, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x24, 0x00, 0x3c, 0x42, 0x02, 0x1e, 0x02, 0x42, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x00, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x12, 0x24, 0x00, 0x42, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x3c, 0x00, 0x24, 0x24, 0x00, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x24, 0x00, 0x42, 0x42, 0x42, 0x3e, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x00, 0x82, 0x82, 0x82, 0xf2, 0x8a,
	0x8a, 0x8a, 0x8a, 0xf2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48,
	0x00, 0x82, 0x82, 0xf2, 0x8a, 0x8a, 0x8a, 0xf2, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x78,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x3e, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x42, 0x44,
	0x48, 0x50, 0x60, 0x60, 0x50, 0x48, 0x44, 0x42, 0x00, 0x3c, 0x00, 0x00,
	0x00, 0x00, 0x40, 0x40, 0x40, 0x42, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42,
	0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x30, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x10, 0x10, 0x00,
	0x10, 0x10, 0x82, 0xc6, 0xaa, 0x92, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0xfc, 0x92, 0x92,
	0x92, 0x92, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6,
	0xaa, 0x92, 0x92, 0x82, 0x82, 0x82, 0x82, 0x82, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92,
	0x00, 0x10, 0x10, 0x00, 0x10, 0x10, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a,
	0x46, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x00, 0x7c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x62, 0x52, 0x4a, 0x46, 0x42, 0x42, 0x42,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0xfe, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40,
	0x40, 0x40, 0x40, 0x7e, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x7e, 0x40, 0x40, 0x3c, 0x00, 0x10, 0x10, 0x00,
	0x32, 0x4c, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x3c, 0x42, 0x42,
	0x7e, 0x40, 0x40, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3c, 0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x3e, 0x00, 0x08, 0x08, 0x00, 0x64, 0x98, 0x00, 0x82,
	0x82, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x32, 0x4c, 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3e,
	0x02, 0x02, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0x00, 0x7e, 0x00, 0x08, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x24, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x12, 0x12, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x24, 0x48, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10,
	0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x92,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xa8, 0x50, 0x10, 0x20, 0x20,
	0x40, 0x54, 0xaa, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10,
	0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x24, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x30, 0x10,
	0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x0c, 0x14, 0x3e, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x20, 0x38, 0x04, 0x04, 0x38, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x20, 0x38,
	0x24, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x04, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x18, 0x24, 0x24, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24,
	0x1c, 0x04, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c,
	0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24,
	0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x30, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x24, 0x04, 0x08, 0x10, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x04, 0x18, 0x04, 0x04,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x0c, 0x14, 0x3e, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x38, 0x20, 0x38, 0x04, 0x04, 0x38, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x20, 0x38, 0x24, 0x24,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c,
	0x04, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x24, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x1c, 0x04,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
	0x10, 0x10, 0x10, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x08, 0x08, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x04, 0x1c, 0x24,
	0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x24, 0x3c, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x28, 0x10, 0x28,
	0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x04, 0x3c, 0x24, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x20, 0x38, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x24, 0x28, 0x30, 0x28,
	0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x54, 0x54, 0x54, 0x54, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x24, 0x24, 0x24,
	0x38, 0x20, 0x20, 0x00, 0x00, 0x00, 0xf0, 0x88, 0x88, 0x88, 0xf4, 0x84,
	0x8e, 0x84, 0x84, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c,
	0x22, 0x40, 0xf8, 0x40, 0xf8, 0x40, 0x22, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x10, 0x10, 0x1c, 0x70, 0x1c, 0x70, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x52, 0x52, 0x50, 0x50, 0x50,
	0x50, 0x52, 0x52, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x62, 0x52, 0x6a, 0x56, 0x4a, 0x46, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x96, 0x96, 0x96, 0xd0, 0xf0, 0xf0, 0xb0, 0x96, 0x90, 0x96,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x52, 0x52, 0x52, 0x52, 0x52,
	0x52, 0x52, 0x5a, 0x3c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xa4,
	0xa4, 0xa4, 0xa4, 0xb8, 0xa8, 0xb4, 0xaa, 0xe6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfb, 0x55, 0x55, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x02, 0x06, 0x0a, 0x14, 0x28,
	0x50, 0x60, 0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44,
	0x22, 0x22, 0x34, 0x58, 0x88, 0x88, 0x84, 0x44, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0xfe, 0x40, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x04, 0xfe, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x42, 0xff,
	0x42, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38,
	0x54, 0x10, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x42, 0xfe, 0x42, 0x22, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x84, 0xfe,
	0x84, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38,
	0x54, 0x10, 0x10, 0x10, 0x54, 0x38, 0x10, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x42, 0xfe, 0x40, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x30, 0x50, 0x92, 0x82,
	0x82, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x40, 0xfe, 0x00, 0xfe, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0xfe, 0x00, 0xfe, 0x40, 0x20, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x7e, 0xc0,
	0x7e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38,
	0x6c, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xfc, 0x06, 0xfc, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x6c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x24, 0x7e, 0xc3, 0x7e, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x38, 0x6c, 0x28, 0x28, 0x28, 0x28, 0x6c, 0x38, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x82, 0x7c, 0x44, 0x44,
	0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e,
	0x02, 0x02, 0x02, 0x7e, 0x02, 0x02, 0x02, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x7e, 0x0a, 0x0a, 0x12, 0x7e, 0x12, 0x22, 0x22, 0x7e,
	0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x7c, 0x8a, 0x92, 0x92,
	0xa2, 0x7c, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82,
	0x82, 0x44, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1e, 0x20, 0x40, 0x40, 0x7e, 0x40, 0x40, 0x20, 0x1e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1e, 0x24, 0x44, 0x48, 0x7e,
	0x48, 0x50, 0x30, 0x3e, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1e, 0x20, 0x40, 0x7e, 0x40, 0x20, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x78, 0x04, 0x02, 0x02, 0x7e, 0x02, 0x02, 0x04, 0x78,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x78, 0x24, 0x22, 0x12, 0x7e,
	0x12, 0x0a, 0x0c, 0x7c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x78, 0x04, 0x02, 0x7e, 0x02, 0x04, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x10,
	0x10, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x04, 0x04,
	0x04, 0x04, 0x44, 0x44, 0x44, 0x24, 0x14, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x92, 0x92, 0x92, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x82, 0x82, 0x44, 0x44, 0x28, 0x28, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x42, 0x42,
	0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x32, 0x4c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x7e, 0x08, 0x10,
	0x7e, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x00, 0x3e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x08, 0x04, 0x08,
	0x10, 0x20, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
	0x12, 0x24, 0x48, 0x90, 0x48, 0x24, 0x12, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x90, 0x48, 0x24, 0x12, 0x09, 0x12, 0x24, 0x48, 0x90,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x3e, 0x00, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x7c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82,
	0x82, 0x82, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40,
	0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12,
	0x12, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x90, 0x90, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x20,
	0x10, 0x10, 0x08, 0x04, 0x40, 0x20, 0x10, 0x10, 0x08, 0x08, 0x08, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x08,
	0x10, 0x10, 0x20, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7c,
	0x7c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x0e, 0x10, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xc0, 0xc0, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x0e, 0xe0, 0x10, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x06, 0x06, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0xe0, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x88, 0x88, 0xf8,
	0x88, 0x88, 0x88, 0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00,
	0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0xf8, 0x00, 0x1f, 0x10, 0x1c, 0x10,
	0x10, 0x10, 0x00, 0x00, 0x00, 0x88, 0x88, 0x50, 0x50, 0x20, 0x20, 0x00,
	0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0xf8, 0x80, 0xe0,
	0x80, 0x80, 0x80, 0x00, 0x1f, 0x10, 0x1c, 0x10, 0x10, 0x10, 0x00, 0x00,
	0x00, 0x70, 0x88, 0x80, 0x80, 0x88, 0x70, 0x00, 0x1e, 0x11, 0x11, 0x1e,
	0x12, 0x11, 0x00, 0x00, 0x00, 0x88, 0xc8, 0xa8, 0x98, 0x88, 0x88, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xaa,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x00,
	0x10, 0x10, 0x10, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00,
	0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
	0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0xf0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f,
	0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x1f, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f, 0x1f, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f,
	0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xf0, 0xf0, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
	0xf8, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x1f, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff,
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x1f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0xf0, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff,
	0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xff, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xf0, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xff, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xff, 0x1f, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xf8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x20,
	0x2f, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf0, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x08,
	0xe8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x1f, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x3f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2f, 0x20,
	0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0xf0, 0x10, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xe8, 0x08,
	0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x1f, 0x10, 0x1f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2f, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x2f, 0x20,
	0x2f, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0xf0, 0x10, 0xf0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xe8, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xe8, 0x08,
	0xe8, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x00, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00,
	0xef, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xef, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0xff, 0x10, 0xff, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xff, 0x28, 0x28, 0x28, 0x28,
	0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0xef, 0x00,
	0xef, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x07, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x08, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20,
	0x40, 0x40, 0x80, 0x80, 0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10,
	0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01, 0x81, 0x81, 0x42, 0x42,
	0x24, 0x24, 0x18, 0x18, 0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x81, 0x81,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
	0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xf8, 0xf8, 0xf8, 0xf8,
	0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xf0, 0xf0, 0xf0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
	0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0x80, 0x80, 0x80, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x88, 0x22, 0x88, 0x22,
	0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22,
	0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55,
	0xaa, 0x55, 0xaa, 0x55, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb,
	0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0xee, 0xbb, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0,
	0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f,
	0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e,
	0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x7c, 0x7c, 0xfe, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0xfc, 0xff,
	0xfc, 0xf0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xfe, 0xfe, 0x7c, 0x7c, 0x38, 0x38, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x3f, 0xff, 0x3f, 0x0f, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe,
	0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x28, 0x44, 0x82, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3,
	0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xe7, 0xdb, 0xdb, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x7c, 0x82, 0xaa, 0x82, 0x82, 0xba, 0x92, 0x82, 0x82, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xfe, 0xd6, 0xfe, 0xfe, 0xc6,
	0xee, 0xfe, 0xfe, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x92, 0x54, 0x38, 0xee, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0x38, 0x10, 0x7c, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x06, 0x0a, 0x12, 0x38, 0x44,
	0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x38, 0x7c, 0xfe, 0xfe, 0x7c, 0x10, 0x10, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x38, 0x38, 0x10, 0x54, 0xfe, 0xfe, 0x54, 0x10, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xfe, 0xfe,
	0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x22,
	0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44,
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x04, 0x04, 0x88, 0x88,
	0x50, 0x50, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,
	0x06, 0x06, 0xcc, 0xcc, 0x78, 0x78, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x44, 0x28, 0x18, 0x18, 0x14, 0x22, 0x20, 0x40, 0x40,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xcc, 0x78, 0x38, 0x38, 0x3c,
	0x66, 0x60, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
	0x10, 0x10, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x12, 0x24, 0x24, 0x48, 0x48,
	0x24, 0x24, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x48,
	0x24, 0x24, 0x12, 0x12, 0x24, 0x24, 0x48, 0x48, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x40, 0x40, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00, 0x00, 0x44, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x42, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x88, 0x9c, 0xaa, 0x88, 0x88, 0x88,
	0x10, 0x20, 0x40, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80,
	0x80, 0x80, 0xf8, 0x00, 0x11, 0x19, 0x15, 0x13, 0x11, 0x11, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x44, 0x44, 0x44, 0xfe, 0xfe, 0xee, 0xc6, 0xee, 0xfe,
	0xfe, 0xfe, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff,
	0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x80, 0x40, 0x20, 0x10,
	0x08, 0x04, 0x02, 0x01, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80,
	0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0xff, 0x7f, 0x3f, 0x1f,
	0x0f, 0x07, 0x03, 0x01, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80,
	0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00, 0x00, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c,
	0xfe, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7c,
	0xd6, 0xd0, 0xd0, 0x7c, 0x16, 0x16, 0xd6, 0x7c, 0x10, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x66, 0xd6, 0x6c, 0x0c, 0x18, 0x18, 0x30, 0x36, 0x6b, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c, 0x38, 0x76, 0xdc,
	0xcc, 0xcc, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x6c, 0x38, 0xfe, 0x38, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x60, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xce, 0xde, 0xf6,
	0xe6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x38,
	0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x06, 0x3c, 0x06,
	0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0e,
	0x1e, 0x36, 0x66, 0xc6, 0xfe, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xfc, 0x06, 0x06, 0x06, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x60, 0xc0, 0xc0, 0xfc, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06,
	0x06, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60,
	0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x0c, 0x18,
	0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xce, 0xd6, 0xd6, 0xd6, 0xd6, 0xce, 0xc0, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xfc, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf8, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xcc, 0xf8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0,
	0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0x78,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0,
	0xd8, 0xcc, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x82, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde,
	0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xde, 0x7c, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0x38, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6,
	0xfe, 0xee, 0xc6, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0x6c, 0x6c, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x0c, 0x18, 0x30,
	0x60, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0x00, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0,
	0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06,
	0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x30, 0x30, 0xfc, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06,
	0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0xf0, 0xe0,
	0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c,
	0x38, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x30, 0x30, 0x30, 0x60, 0x30,
	0x30, 0x30, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0c, 0x18, 0x18, 0x18, 0x18, 0x70,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x73, 0xdb, 0xce, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x10, 0x7c, 0xd6, 0xd0, 0xd0, 0xd0, 0xd6, 0x7c,
	0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x60, 0x60, 0xf8, 0x60,
	0x60, 0x60, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x66, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x7e, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x60,
	0x38, 0x6c, 0x66, 0x66, 0x36, 0x1c, 0x06, 0x66, 0x3c, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x06, 0x3e, 0x66, 0x3e, 0x00, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x1b, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x1b, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e,
	0x18, 0x18, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x0c,
	0x18, 0x30, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x78, 0x0c, 0x38, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xce, 0xf6, 0xc0, 0xc0, 0xc0, 0x00,
	0x00, 0x00, 0x7e, 0xd6, 0xd6, 0xd6, 0xd6, 0x76, 0x16, 0x16, 0x16, 0x16,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0x18, 0x38, 0x18,
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x6c, 0x36,
	0x1b, 0x36, 0x6c, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xe0, 0x62,
	0x66, 0x6c, 0x18, 0x30, 0x66, 0xce, 0x9a, 0x3e, 0x06, 0x06, 0x00, 0x00,
	0x00, 0x60, 0xe0, 0x62, 0x66, 0x6c, 0x18, 0x30, 0x60, 0xdc, 0xb6, 0x0c,
	0x18, 0x3e, 0x00, 0x00, 0x00, 0xe0, 0x30, 0x62, 0x36, 0xec, 0x18, 0x30,
	0x66, 0xce, 0x9a, 0x3e, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,
	0x00, 0x30, 0x30, 0x60, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c,
	0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0x7c,
	0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0xfe, 0xd8, 0xd8, 0xd8, 0xd8, 0xde,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc6, 0xc6, 0x7c, 0x30, 0x30, 0x60, 0x00, 0x30, 0x18, 0x00, 0xfe,
	0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xfe,
	0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x3c,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x66, 0x66, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x6c, 0x66, 0x66, 0xf6, 0x66,
	0x66, 0x66, 0x6c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0xc6,
	0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0x6c, 0x38, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc7, 0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0xc3, 0xc3,
	0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xcc, 0xcc, 0xc8, 0xfc, 0xc6,
	0xc6, 0xc6, 0xe6, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18,
	0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0x06, 0x7e,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc,
	0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0x7c, 0x06, 0x7e,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x6c, 0x16, 0x16, 0x7e, 0xd0, 0xd0, 0x6c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c,
	0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6,
	0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6,
	0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18,
	0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x38, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x68, 0x30, 0x58, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18,
	0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc,
	0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3d, 0x67, 0x6e, 0x7e, 0x76, 0xe6, 0xbc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x18, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x7c, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c,
	0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0x06, 0x7e,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x0c, 0x07, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x0c, 0x07, 0x00, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0,
	0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc0,
	0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7c,
	0xc6, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0,
	0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0x00, 0xf8, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xcc, 0xf8,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x1f,
	0x06, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6,
	0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xfe,
	0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe,
	0x06, 0x0c, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6,
	0xfe, 0xc0, 0xc0, 0x7c, 0x18, 0x30, 0x1c, 0x00, 0x38, 0x6c, 0x00, 0x7c,
	0xc6, 0xc6, 0xc0, 0xde, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x6c, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x7c, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xde,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x18, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xde, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x30, 0x30, 0x60,
	0x00, 0x0c, 0x18, 0x18, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x7c, 0x00, 0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x36, 0xc0, 0xc0,
	0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x66, 0xff, 0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xf8, 0x60, 0x7c, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x3c,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x76, 0xdc, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c,
	0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x38, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x18, 0x30, 0x1c, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x18, 0x30, 0x1c, 0x00, 0x18, 0x18, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xcf, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xf6, 0xf6, 0xdc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x36, 0x36, 0x1c, 0x00, 0x1c, 0x36, 0x00, 0x1e,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x1b, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0,
	0xd8, 0xcc, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0xc0, 0xc0,
	0xc0, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x30, 0x30, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x00, 0x38,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x30, 0x6c, 0x38, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xcc, 0xcc,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18,
	0x18, 0x18, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x70, 0xe0, 0x60, 0x60, 0x60, 0x7f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x1c, 0x38,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0xc6, 0xc6,
	0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde,
	0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x30, 0x30, 0x60,
	0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0xc0,
	0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6,
	0x06, 0x06, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x06, 0x1c, 0x00, 0x7c, 0x00, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x36, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0x00, 0x7c, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8,
	0xd8, 0xd8, 0xde, 0xd8, 0xd8, 0xd8, 0xd8, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xd6, 0xd6, 0xde, 0xd0, 0xd0, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xfc,
	0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0xde, 0xf0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xf0, 0xd8, 0xcc, 0xc6,
	0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0x78, 0x70,
	0x60, 0x60, 0x60, 0x60, 0x00, 0x60, 0x60, 0xc0, 0x6c, 0x38, 0x00, 0xfc,
	0xc6, 0xc6, 0xc6, 0xfc, 0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x38, 0x00, 0xde, 0xf0, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7c,
	0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18,
	0x00, 0x7e, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x7e, 0xc0, 0xc0,
	0x7c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x30, 0x30, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xfc,
	0x30, 0x30, 0x60, 0x00, 0x6c, 0x38, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7c,
	0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0x7e, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x0c, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x1e, 0x0c, 0x0c, 0x18, 0x00, 0x6c, 0x38, 0x00, 0xff,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x38, 0x00, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x7e, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,
	0x30, 0xfc, 0x30, 0x78, 0x30, 0x30, 0x30, 0x1e, 0x00, 0x00, 0x00, 0x00,
	0x76, 0xdc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x6c, 0x38, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0x00, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x36, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x18, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x07, 0x00,
	0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xfe, 0xee, 0xc6, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0xc6, 0xc6, 0xd6,
	0xd6, 0xd6, 0xd6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0xc3,
	0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xfe, 0x0c, 0x18,
	0x30, 0x60, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0xfe,
	0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0xfe, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x30,
	0x60, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0xfe, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x06, 0x06, 0x06,
	0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06,
	0x06, 0x06, 0x3e, 0x06, 0x06, 0x06, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0x78, 0xc0,
	0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1b,
	0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0x70, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x76, 0x7e, 0x6e, 0x66, 0x66, 0x66, 0x66,
	0x60, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0xfe, 0x06,
	0x0c, 0x18, 0x3c, 0x06, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0xc6, 0xc6, 0x7c,
	0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0,
	0x7c, 0x06, 0x06, 0xfc, 0x00, 0x30, 0x30, 0x60, 0x00, 0x00, 0xff, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x30,
	0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1e,
	0x00, 0x0c, 0x0c, 0x18, 0x7e, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06,
	0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x06, 0x06, 0xfe, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0,
	0x78, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x0c, 0x18, 0x3c, 0x06, 0x06,
	0xc6, 0xc6, 0x7c, 0x00, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x07, 0x00, 0x76, 0xdc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x36, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x00, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x60, 0xc0, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x00, 0xfe,
	0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x60, 0xc0, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x7c, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x60, 0xc0, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x60, 0xc0, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0x6c, 0x6c, 0xee, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0xd8, 0xd8,
	0x00, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c,
	0x6c, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc6, 0xc6, 0xd6, 0xd6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x38, 0x38, 0x6c, 0x6c, 0x6c, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x7c, 0x00,
	0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc0, 0x60, 0x30, 0x18, 0x18, 0x30, 0x60, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6,
	0xd6, 0xd6, 0x7c, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0xee,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x7a, 0xce, 0xcc,
	0xcc, 0xcc, 0xce, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30,
	0x00, 0x7c, 0xc6, 0xc0, 0x78, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x70, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x6c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0xce, 0xcc, 0xcc, 0xcc, 0xce, 0x7a,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xcc, 0xcc, 0xc8, 0xfc, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x7e, 0x30, 0x18, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x0c, 0x18, 0x30, 0x60, 0xc0,
	0xc0, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x3c, 0x66,
	0x66, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x18, 0x18, 0x3c, 0x3c,
	0x66, 0x66, 0xc3, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0,
	0xc0, 0xc0, 0x7c, 0xc0, 0xc0, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0x0c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0x7c, 0x06, 0x06, 0x0c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x66, 0x66, 0x66, 0x66, 0x66, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c,
	0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c,
	0x6c, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xc6, 0xd6, 0xd6, 0xd6, 0xfe, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xd8, 0x00, 0x70, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0x44, 0xc6, 0xd6,
	0xd6, 0xd6, 0xfe, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66,
	0x66, 0x66, 0x3f, 0x06, 0xe6, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe3, 0x36, 0x1c,
	0x18, 0x38, 0x6c, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0xc0, 0xc0, 0x7c, 0x00,
	0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0xc0,
	0xfc, 0xc0, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xf8, 0x0c, 0x06, 0x7e, 0x06, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf0, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6,
	0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x70, 0xd0, 0xdc, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x9c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xd0, 0xd0, 0xdc, 0xf6, 0xd6,
	0xd6, 0xd6, 0xd6, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x60,
	0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x30, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0, 0xd8, 0xcc, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0xc6, 0xc6, 0xc6, 0xce, 0xde, 0xf6,
	0xe6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe,
	0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66,
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xff, 0xc3, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xce, 0xde, 0xf6,
	0xe6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0xc6, 0xc6,
	0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x7c, 0xd6,
	0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7c, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7f,
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7f,
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x60, 0x60, 0x7c, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xe6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xe6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0x3e, 0x06,
	0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xd6,
	0xd6, 0xd6, 0xd6, 0xf6, 0xd6, 0xd6, 0xd6, 0xcc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x1e, 0x36, 0x66, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xcc,
	0xcc, 0xc8, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0x7c,
	0x38, 0x7c, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x66, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xee, 0xfe,
	0xd6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0x7f, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xe0, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xe6, 0xd6, 0xd6, 0xd6, 0xe6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x7c,
	0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0x06, 0x3e, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xd6, 0xd6, 0xf6, 0xd6, 0xd6, 0xcc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc6, 0xc6,
	0x7e, 0x36, 0x66, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xf8,
	0x60, 0x7c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x06, 0x06, 0x1c, 0x00,
	0x00, 0x00, 0x18, 0x30, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0,
	0xf8, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x70, 0xd0, 0xdc, 0xd6, 0xd6, 0xd6, 0x9c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xd0, 0xdc, 0xf6, 0xd6, 0xd6, 0xdc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x00, 0xc6, 0xcc, 0xd8,
	0xf0, 0xd8, 0xcc, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe,
	0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x60, 0xf8, 0x60, 0x7c, 0x66, 0x66,
	0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,
	0xf8, 0x60, 0x60, 0x7c, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc6, 0x6c, 0x6c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0xd6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x6c, 0x28,
	0x38, 0x7c, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0xfe, 0xc0,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x06, 0x06, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x60, 0x60, 0x60, 0xfc, 0x60,
	0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7f, 0x60, 0x60, 0xfc, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6,
	0x06, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0,
	0xf8, 0xcc, 0xcc, 0xcc, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6,
	0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0xd7, 0x03, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd7,
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x06, 0x3c, 0x06,
	0x06, 0xc6, 0xc6, 0x7c, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c, 0x30, 0x30, 0x30, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xcc, 0xd8, 0xf0, 0xf0, 0xd8, 0xcc, 0xc6, 0xc7,
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xcc, 0xd8,
	0xf0, 0xd8, 0xcc, 0xc7, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xd6, 0xdc, 0xf8, 0xf8, 0xdc, 0xd6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xd6, 0xdc, 0xf8, 0xdc, 0xd6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe3, 0xe3, 0x66, 0x6c, 0x78, 0x78,
	0x6c, 0x66, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xe3, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0x63, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc7,
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	0xfe, 0xc6, 0xc6, 0xc7, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xcc,
	0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc6, 0xc6, 0x7c, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x30, 0x30, 0x30, 0x00,
	0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x66,
	0x66, 0x3c, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0x6c, 0x6c, 0x38, 0x38, 0x6c, 0x6c, 0xc6, 0xc7, 0x03, 0x03, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x6c, 0x38, 0x6c, 0xc6, 0xc7,
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x06, 0x07, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x07, 0x03, 0x03, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xd6, 0xd6, 0x7e, 0x16, 0x16, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xd6, 0xd6,
	0x7e, 0x16, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,
	0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x38, 0x00, 0xd6, 0xd6, 0xd6, 0x7c, 0x38,
	0x7c, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x38,
	0x00, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0xfe, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0x06, 0x06,
	0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xd6,
	0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0xd6, 0xd6, 0x7c, 0x38, 0x7c, 0xd6, 0xd6,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0x06, 0x3c,
	0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0x7c, 0xc6, 0x06, 0x3c, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xce, 0xde, 0xf6, 0xe6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xce, 0xde,
	0xf6, 0xe6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0xc6,
	0xfe, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c,
	0xc6, 0x06, 0x06, 0x3e, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0x7c, 0xc6, 0x06, 0x3e, 0x06, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x36, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x7c, 0x00, 0x6c, 0x6c, 0x00, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x00, 0xc6, 0xc6, 0xc6, 0xe6, 0xd6,
	0xd6, 0xd6, 0xd6, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x00, 0xc6, 0xc6, 0xe6, 0xd6, 0xd6, 0xd6, 0xe6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xf8, 0xcc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xcc, 0xf8,
	0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x7e, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xcc, 0xd8, 0xf0, 0xf0, 0xd8, 0xcc, 0xc6, 0xc6, 0x00, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc6, 0xcc, 0xd8, 0xf0, 0xd8, 0xcc, 0xc6,
	0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x38, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00,
	0x18, 0x18, 0x82, 0xc6, 0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0xfc, 0xd6, 0xd6,
	0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xc6,
	0xee, 0xfe, 0xd6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6,
	0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde,
	0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,
	0x00, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xe6, 0xf6, 0xde, 0xce, 0xc6, 0xc6, 0xc6,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0xff, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x30, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x30, 0x1e,
	0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0,
	0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc6, 0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x18, 0x18, 0x00,
	0x76, 0xdc, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xf8, 0xc0, 0xc0, 0xc0, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x7c, 0xc6, 0xc6,
	0xfe, 0xc0, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x18, 0x18, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x76, 0xdc, 0x00, 0xc3,
	0xc3, 0x66, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x76, 0xdc, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e,
	0x06, 0x06, 0x7c, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe,
	0x00, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0xcc, 0x00, 0x00, 0x00,
	0x00, 0xcc, 0xcc, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
	0x7e, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdb, 0xdb,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xac, 0xf8, 0x18, 0x30, 0x30,
	0x60, 0x7f, 0xd5, 0xdf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30,
	0x60, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x30, 0x18, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c, 0x6c, 0x6c, 0x38, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x38, 0x18,
	0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0c, 0x1c, 0x34, 0x7e, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x60, 0x78, 0x0c, 0x0c, 0x78, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x60, 0x78,
	0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0x6c, 0x6c, 0x38, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x6c,
	0x3c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x30, 0x30, 0x30, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x18, 0x18,
	0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
	0x6c, 0x6c, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x38, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x0c, 0x18, 0x30,
	0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78,
	0x0c, 0x38, 0x0c, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x1c, 0x34, 0x7e, 0x0c, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x60, 0x78, 0x0c, 0x0c,
	0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
	0x60, 0x78, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x38, 0x6c, 0x6c,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
	0x6c, 0x6c, 0x3c, 0x0c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x30, 0x30, 0x30,
	0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
	0x18, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x3c, 0x6c, 0x3c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x6c, 0x7c, 0x60,
	0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x6c, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c, 0x6c,
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60,
	0x78, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x66, 0x6c, 0x78, 0x6c, 0x66, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xfc, 0xd6, 0xd6, 0xd6, 0xd6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x6c, 0x6c, 0x6c, 0x78, 0x60, 0x60, 0x00,
	0x00, 0x00, 0xf8, 0xcc, 0xcc, 0xcc, 0xfa, 0xc6, 0xcf, 0xc6, 0xc6, 0xc3,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x33, 0x60, 0xfc, 0x60,
	0xfc, 0x60, 0x33, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18,
	0x18, 0x1e, 0x78, 0x1e, 0x78, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x33, 0x33, 0x3e, 0x7c, 0xcc, 0xcc, 0xc6, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x60, 0xfe,
	0xfe, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c,
	0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0xfe, 0xfe, 0x0c, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x24, 0x66, 0xff, 0xff, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x62, 0xfe,
	0xfe, 0x62, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x88, 0x8c, 0xfe, 0xfe, 0x8c, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x7e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x26, 0x66,
	0xfe, 0xfe, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
	0x38, 0x68, 0xcb, 0xc3, 0xc3, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x20, 0x60, 0xfe, 0xfe, 0x00, 0xfe, 0xfe, 0x0c, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0c, 0xfe, 0xfe, 0x00,
	0xfe, 0xfe, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x3e, 0x7e, 0xe0, 0x7e, 0x3e, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x38, 0x7c, 0xee, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xf8, 0xfc, 0x0e,
	0xfc, 0xf8, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0xee, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x24, 0x7e, 0xff, 0xc3, 0xff, 0x7e, 0x24, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xee, 0x6c, 0x6c,
	0xee, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6,
	0xc6, 0xfe, 0x6c, 0x6c, 0x6c, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0xfe, 0x06, 0x06, 0x06, 0xfe,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0xfe, 0x1e, 0x16, 0x36, 0xfe,
	0x36, 0x66, 0x66, 0xfe, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c,
	0x7c, 0xce, 0xde, 0xf6, 0xe6, 0x7c, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0x38, 0x38, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0xc0, 0xc0, 0xfe,
	0xc0, 0xc0, 0x60, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x3e,
	0x6c, 0xcc, 0xd8, 0xfe, 0xd8, 0xf0, 0x70, 0x7e, 0x60, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x60, 0xc0, 0xfe, 0xc0, 0x60, 0x3e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x0c, 0x06, 0x06, 0xfe,
	0x06, 0x06, 0x0c, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf8,
	0x6c, 0x66, 0x36, 0xfe, 0x36, 0x1e, 0x1c, 0xfc, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xf8, 0x0c, 0x06, 0xfe, 0x06, 0x0c, 0xf8, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x18,
	0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0x60, 0x30,
	0x18, 0x0c, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0e, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0x6c, 0x3c, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xd6, 0xd6,
	0xd6, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0xc3, 0xc3,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0x66, 0x66,
	0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00,
	0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x06, 0xfe, 0x18, 0x30, 0xfe, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30,
	0x18, 0x0c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
	0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x09, 0x1b, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x1b, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xd8, 0x6c, 0x36, 0x1b,
	0x36, 0x6c, 0xd8, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7e, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xfc, 0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xc0, 0xc0, 0xc0, 0xc0,
	0xc0, 0x7e, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc,
	0x06, 0x06, 0x06, 0x06, 0x06, 0xfc, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6,
	0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0,
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x18,
	0x30, 0x30, 0x30, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x30, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x06, 0x60, 0x30, 0x18, 0x18,
	0x0c, 0x0c, 0x0c, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x0c, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x60, 0x7e, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
	0x60, 0x60, 0x60, 0x7e, 0x7e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x7e,
	0x0f, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xe0,
	0xe0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0f,
	0xf0, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x07,
	0x07, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0xf0,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xcc, 0xcc, 0xfc, 0xcc, 0xcc, 0xcc, 0x00, 0x3f, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xf8, 0x00,
	0x3f, 0x30, 0x3c, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc,
	0xcc, 0x78, 0x30, 0x00, 0x3f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00,
	0x00, 0xfc, 0xc0, 0xf0, 0xc0, 0xc0, 0xc0, 0x00, 0x3f, 0x30, 0x3c, 0x30,
	0x30, 0x30, 0x00, 0x00, 0x00, 0x78, 0xcc, 0xc0, 0xc0, 0xcc, 0x78, 0x00,
	0x3e, 0x33, 0x33, 0x3e, 0x36, 0x33, 0x00, 0x00, 0x00, 0xcc, 0xec, 0xfc,
	0xdc, 0xcc, 0xcc, 0x00, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x38, 0x38, 0x00, 0x38, 0x38, 0x38, 0x00, 0x38, 0x38, 0x38, 0x00,
	0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f,
	0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3f, 0x3f, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f, 0x3f, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8,
	0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf8, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0xf8, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f,
	0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0x3f, 0x3f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8,
	0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf8, 0xf8, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f,
	0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x3f, 0x3f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3f, 0x3f, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f,
	0x3f, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x3f, 0x3f, 0x3f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3f, 0x3f, 0x3f, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0x3f,
	0x3f, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0xf8, 0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8,
	0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0xf8, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf8, 0xf8, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8,
	0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0xf8, 0xf8, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff,
	0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3f, 0xff, 0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x1f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0xf8, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0xff, 0xff, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff,
	0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0xf8, 0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0xff, 0xff, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x1f, 0xff, 0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff, 0xff, 0xff, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0xf8, 0xff, 0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x3f, 0xff, 0xff, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xff, 0xff,
	0xff, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18,
	0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7f, 0x7f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f, 0x60, 0x6f, 0x6f, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18,
	0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xfc, 0xfc, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0x0c, 0xec, 0xec, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18,
	0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x7f, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6f, 0x6f, 0x60, 0x7f, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18,
	0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xec, 0xec, 0x0c, 0xfc, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18,
	0x1f, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6f, 0x6f, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6f, 0x6f, 0x60, 0x6f, 0x6f, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18,
	0xf8, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0xec, 0xec, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xec, 0xec, 0x0c, 0xec, 0xec, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
	0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xef, 0xef, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x00,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xef, 0xef, 0x00, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0xff, 0x18,
	0xff, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0xff, 0xff, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0xef, 0xef, 0x00, 0xef, 0xef, 0x6c, 0x6c,
	0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
	0x0f, 0x1c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xe0, 0xf0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0xf0, 0xe0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1c, 0x0f,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x02,
	0x06, 0x04, 0x0c, 0x08, 0x18, 0x10, 0x30, 0x20, 0x60, 0x40, 0xc0, 0x80,
	0x80, 0xc0, 0x40, 0x60, 0x20, 0x30, 0x10, 0x18, 0x08, 0x0c, 0x04, 0x06,
	0x02, 0x03, 0x01, 0x01, 0x81, 0xc1, 0x43, 0x62, 0x26, 0x34, 0x1c, 0x18,
	0x18, 0x1c, 0x34, 0x26, 0x62, 0x43, 0xc1, 0x81, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf8,
	0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x3c, 0x3c, 0x7e, 0x7e, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0xfc, 0xff,
	0xff, 0xfc, 0xf0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x7e, 0x7e, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x0f, 0x3f, 0xff, 0xff, 0x3f, 0x0f, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff,
	0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x3c, 0x66, 0xc3, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x7e, 0x7e,
	0x7e, 0x7e, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x18, 0xdb, 0x7e, 0x3c, 0xe7, 0x3c, 0x7e, 0xdb, 0x18,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c,
	0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x0e,
	0x1a, 0x32, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x7e, 0x18, 0x18, 0x3c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x5a, 0xff,
	0xff, 0x5a, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x66,
	0x7e, 0x60, 0x60, 0x60, 0x60, 0x60, 0xe0, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7e, 0x66, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6e, 0xec,
	0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x0e, 0x0e, 0xdc, 0xfc,
	0x78, 0x78, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0xee,
	0x7c, 0x3c, 0x3c, 0x3e, 0x77, 0x73, 0xe0, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x0c, 0x18, 0x18, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x18, 0x18, 0x0c, 0x0c,
	0x18, 0x18, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36,
	0x6c, 0x6c, 0xd8, 0xd8, 0x6c, 0x6c, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xd8, 0xd8, 0x6c, 0x6c, 0x36, 0x36, 0x6c, 0x6c, 0xd8, 0xd8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x60, 0x60, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00, 0x00, 0x66, 0x66, 0x00,
	0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0x00,
	0x00, 0x00, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xcc, 0xde,
	0xff, 0xcc, 0xcc, 0xcc, 0x98, 0x30, 0x60, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
	0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xfc, 0x00, 0x33, 0x3b, 0x3f, 0x37,
	0x33, 0x33, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0xff, 0xff,
	0xe7, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0x00, 0x00, 0x80, 0xc0, 0x60, 0x30,
	0x18, 0x0c, 0x06, 0x03, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80,
	0x01, 0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc0, 0x60, 0x30, 0x18,
	0x0c, 0x06, 0x03, 0x01,
};

static struct vt_font_map font_mapping_normal[308] = {
	{ 0x0020, 0x0001, 0x5e }, { 0x00a0, 0x0001, 0x00 },
	{ 0x00a1, 0x0060, 0x6e }, { 0x0110, 0x008f, 0x00 },
	{ 0x0111, 0x00cf, 0x08 }, { 0x011a, 0x00d2, 0x01 },
	{ 0x011c, 0x00d8, 0x59 }, { 0x0178, 0x0132, 0x07 },
	{ 0x0186, 0x013a, 0x00 }, { 0x018e, 0x013b, 0x02 },
	{ 0x0192, 0x013e, 0x00 }, { 0x019d, 0x013f, 0x01 },
	{ 0x01b7, 0x0141, 0x00 }, { 0x0218, 0x0142, 0x03 },
	{ 0x0232, 0x0146, 0x01 }, { 0x0237, 0x0148, 0x00 },
	{ 0x0254, 0x0149, 0x00 }, { 0x0258, 0x014a, 0x01 },
	{ 0x025b, 0x014c, 0x00 }, { 0x0272, 0x014d, 0x00 },
	{ 0x0292, 0x014e, 0x00 }, { 0x02bb, 0x014f, 0x02 },
	{ 0x02c6, 0x0152, 0x01 }, { 0x02d8, 0x0153, 0x01 },
	{ 0x02db, 0x0155, 0x02 }, { 0x0300, 0x0041, 0x00 },
	{ 0x0301, 0x0073, 0x00 }, { 0x0302, 0x0152, 0x00 },
	{ 0x0303, 0x0156, 0x00 }, { 0x0304, 0x006e, 0x00 },
	{ 0x0305, 0x0158, 0x00 }, { 0x0306, 0x0153, 0x01 },
	{ 0x0308, 0x0067, 0x00 }, { 0x030a, 0x0159, 0x00 },
	{ 0x030b, 0x0157, 0x00 }, { 0x030c, 0x0153, 0x00 },
	{ 0x0329, 0x015a, 0x00 }, { 0x0384, 0x015b, 0x06 },
	{ 0x038c, 0x0162, 0x00 }, { 0x038e, 0x0163, 0x02 },
	{ 0x0391, 0x0022, 0x01 }, { 0x0393, 0x0166, 0x01 },
	{ 0x0395, 0x0026, 0x00 }, { 0x0396, 0x003b, 0x00 },
	{ 0x0397, 0x0029, 0x00 }, { 0x0398, 0x0168, 0x00 },
	{ 0x0399, 0x002a, 0x00 }, { 0x039a, 0x002c, 0x00 },
	{ 0x039b, 0x0169, 0x00 }, { 0x039c, 0x002e, 0x01 },
	{ 0x039e, 0x016a, 0x00 }, { 0x039f, 0x0030, 0x00 },
	{ 0x03a0, 0x016b, 0x00 }, { 0x03a1, 0x0031, 0x00 },
	{ 0x03a3, 0x016c, 0x00 }, { 0x03a4, 0x0035, 0x00 },
	{ 0x03a5, 0x003a, 0x00 }, { 0x03a6, 0x016d, 0x00 },
	{ 0x03a7, 0x0039, 0x00 }, { 0x03a8, 0x016e, 0x01 },
	{ 0x03aa, 0x008e, 0x00 }, { 0x03ab, 0x0132, 0x00 },
	{ 0x03ac, 0x0170, 0x08 }, { 0x03b5, 0x014c, 0x00 },
	{ 0x03b6, 0x0179, 0x00 }, { 0x03b7, 0x0140, 0x00 },
	{ 0x03b8, 0x017a, 0x01 }, { 0x03ba, 0x00f4, 0x00 },
	{ 0x03bb, 0x017c, 0x00 }, { 0x03bc, 0x0074, 0x00 },
	{ 0x03bd, 0x0057, 0x00 }, { 0x03be, 0x017d, 0x00 },
	{ 0x03bf, 0x0050, 0x00 }, { 0x03c0, 0x017e, 0x0b },
	{ 0x03cc, 0x00b2, 0x00 }, { 0x03cd, 0x018a, 0x01 },
	{ 0x03d1, 0x018c, 0x00 }, { 0x03d5, 0x018d, 0x00 },
	{ 0x03f0, 0x018e, 0x01 }, { 0x03f2, 0x0044, 0x00 },
	{ 0x03f3, 0x004b, 0x00 }, { 0x03f4, 0x0190, 0x02 },
	{ 0x0400, 0x0087, 0x00 }, { 0x0401, 0x008a, 0x00 },
	{ 0x0402, 0x0193, 0x02 }, { 0x0405, 0x0034, 0x00 },
	{ 0x0406, 0x002a, 0x00 }, { 0x0407, 0x008e, 0x00 },
	{ 0x0408, 0x002b, 0x00 }, { 0x0409, 0x0196, 0x06 },
	{ 0x0410, 0x0022, 0x00 }, { 0x0411, 0x019d, 0x00 },
	{ 0x0412, 0x0023, 0x00 }, { 0x0413, 0x0166, 0x00 },
	{ 0x0414, 0x019e, 0x00 }, { 0x0415, 0x0026, 0x00 },
	{ 0x0416, 0x019f, 0x00 }, { 0x0417, 0x0014, 0x00 },
	{ 0x0418, 0x01a0, 0x01 }, { 0x041a, 0x002c, 0x00 },
	{ 0x041b, 0x01a2, 0x00 }, { 0x041c, 0x002e, 0x00 },
	{ 0x041d, 0x0029, 0x00 }, { 0x041e, 0x0030, 0x00 },
	{ 0x041f, 0x016b, 0x00 }, { 0x0420, 0x0031, 0x00 },
	{ 0x0421, 0x0024, 0x00 }, { 0x0422, 0x0035, 0x00 },
	{ 0x0423, 0x01a3, 0x01 }, { 0x0425, 0x0039, 0x00 },
	{ 0x0426, 0x01a5, 0x05 }, { 0x042c, 0x0043, 0x00 },
	{ 0x042d, 0x01ab, 0x02 }, { 0x0430, 0x0042, 0x00 },
	{ 0x0431, 0x01ae, 0x02 }, { 0x0434, 0x0048, 0x00 },
	{ 0x0435, 0x0046, 0x00 }, { 0x0436, 0x01b1, 0x01 },
	{ 0x0438, 0x0056, 0x00 }, { 0x0439, 0x0129, 0x00 },
	{ 0x043a, 0x00f4, 0x00 }, { 0x043b, 0x01b3, 0x02 },
	{ 0x043e, 0x0050, 0x00 }, { 0x043f, 0x017e, 0x00 },
	{ 0x0440, 0x0051, 0x00 }, { 0x0441, 0x0044, 0x00 },
	{ 0x0442, 0x01b6, 0x00 }, { 0x0443, 0x005a, 0x00 },
	{ 0x0444, 0x018d, 0x00 }, { 0x0445, 0x0059, 0x00 },
	{ 0x0446, 0x01b7, 0x09 }, { 0x0450, 0x00a7, 0x00 },
	{ 0x0451, 0x00aa, 0x00 }, { 0x0452, 0x01c1, 0x02 },
	{ 0x0455, 0x0054, 0x00 }, { 0x0456, 0x004a, 0x00 },
	{ 0x0457, 0x00ae, 0x00 }, { 0x0458, 0x004b, 0x00 },
	{ 0x0459, 0x01c4, 0x01 }, { 0x045b, 0x00e3, 0x00 },
	{ 0x045c, 0x01c6, 0x00 }, { 0x045d, 0x00b8, 0x00 },
	{ 0x045e, 0x01c7, 0x01 }, { 0x0462, 0x01c9, 0x01 },
	{ 0x046a, 0x01cb, 0x01 }, { 0x0490, 0x01cd, 0x0d },
	{ 0x04a0, 0x01db, 0x05 }, { 0x04aa, 0x01e1, 0x01 },
	{ 0x04ae, 0x003a, 0x00 }, { 0x04af, 0x0177, 0x00 },
	{ 0x04b0, 0x01e3, 0x03 }, { 0x04b6, 0x01e7, 0x05 },
	{ 0x04c0, 0x002a, 0x00 }, { 0x04c1, 0x01ed, 0x01 },
	{ 0x04cf, 0x004d, 0x00 }, { 0x04d0, 0x00c1, 0x01 },
	{ 0x04d2, 0x0083, 0x00 }, { 0x04d3, 0x00a3, 0x00 },
	{ 0x04d4, 0x0085, 0x00 }, { 0x04d5, 0x00a5, 0x00 },
	{ 0x04d6, 0x00d2, 0x01 }, { 0x04d8, 0x013c, 0x00 },
	{ 0x04d9, 0x014b, 0x00 }, { 0x04da, 0x01ef, 0x05 },
	{ 0x04e2, 0x01f5, 0x00 }, { 0x04e3, 0x0127, 0x00 },
	{ 0x04e4, 0x01f6, 0x00 }, { 0x04e5, 0x00bb, 0x00 },
	{ 0x04e6, 0x0095, 0x00 }, { 0x04e7, 0x00b5, 0x00 },
	{ 0x04e8, 0x0190, 0x00 }, { 0x04e9, 0x01f7, 0x05 },
	{ 0x04ef, 0x0147, 0x00 }, { 0x04f0, 0x01fd, 0x00 },
	{ 0x04f1, 0x00be, 0x00 }, { 0x04f2, 0x01fe, 0x03 },
	{ 0x04f8, 0x0202, 0x01 }, { 0x1e0c, 0x0204, 0x01 },
	{ 0x1e34, 0x0206, 0x03 }, { 0x1e40, 0x020a, 0x07 },
	{ 0x1e6c, 0x0212, 0x01 }, { 0x1eb8, 0x0214, 0x01 },
	{ 0x1ebc, 0x0216, 0x01 }, { 0x1eca, 0x0218, 0x03 },
	{ 0x1ee4, 0x021c, 0x01 }, { 0x1ef8, 0x021e, 0x01 },
	{ 0x2000, 0x0001, 0x00 }, { 0x2001, 0x0001, 0x00 },
	{ 0x2002, 0x0001, 0x00 }, { 0x2003, 0x0001, 0x00 },
	{ 0x2004, 0x0001, 0x00 }, { 0x2005, 0x0001, 0x00 },
	{ 0x2006, 0x0001, 0x00 }, { 0x2007, 0x0001, 0x00 },
	{ 0x2008, 0x0001, 0x00 }, { 0x2009, 0x0001, 0x00 },
	{ 0x200a, 0x0001, 0x00 }, { 0x200b, 0x0001, 0x00 },
	{ 0x200c, 0x0001, 0x00 }, { 0x200d, 0x0001, 0x00 },
	{ 0x200e, 0x0001, 0x00 }, { 0x200f, 0x0001, 0x00 },
	{ 0x2010, 0x006c, 0x00 }, { 0x2011, 0x006c, 0x00 },
	{ 0x2012, 0x000e, 0x00 }, { 0x2013, 0x000e, 0x00 },
	{ 0x2014, 0x0220, 0x00 }, { 0x2015, 0x0220, 0x0d },
	{ 0x2026, 0x022e, 0x00 }, { 0x2030, 0x022f, 0x00 },
	{ 0x2032, 0x0230, 0x01 }, { 0x2039, 0x0232, 0x01 },
	{ 0x203c, 0x0234, 0x00 }, { 0x203e, 0x0158, 0x00 },
	{ 0x2070, 0x0235, 0x01 }, { 0x2074, 0x0237, 0x1a },
	{ 0x2090, 0x0252, 0x08 }, { 0x209a, 0x025b, 0x00 },
	{ 0x20a7, 0x025c, 0x00 }, { 0x20ac, 0x025d, 0x00 },
	{ 0x20ae, 0x025e, 0x00 }, { 0x2102, 0x025f, 0x00 },
	{ 0x210e, 0x0049, 0x00 }, { 0x210f, 0x00e3, 0x00 },
	{ 0x2115, 0x0260, 0x01 }, { 0x211a, 0x0262, 0x00 },
	{ 0x211d, 0x0263, 0x00 }, { 0x2122, 0x0264, 0x00 },
	{ 0x2124, 0x0265, 0x00 }, { 0x2126, 0x016f, 0x00 },
	{ 0x2135, 0x0266, 0x00 }, { 0x2190, 0x0267, 0x05 },
	{ 0x21a4, 0x026d, 0x00 }, { 0x21a6, 0x026e, 0x00 },
	{ 0x21a8, 0x026f, 0x00 }, { 0x21b5, 0x0270, 0x00 },
	{ 0x21bb, 0x0271, 0x00 }, { 0x21cb, 0x0272, 0x01 },
	{ 0x21d0, 0x0274, 0x05 }, { 0x2200, 0x027a, 0x00 },
	{ 0x2203, 0x027b, 0x02 }, { 0x2206, 0x0167, 0x00 },
	{ 0x2207, 0x027e, 0x06 }, { 0x2212, 0x000e, 0x00 },
	{ 0x2213, 0x0285, 0x03 }, { 0x2219, 0x0289, 0x01 },
	{ 0x221e, 0x028b, 0x01 }, { 0x2225, 0x0221, 0x00 },
	{ 0x2227, 0x028d, 0x03 }, { 0x2248, 0x0291, 0x00 },
	{ 0x2260, 0x0292, 0x01 }, { 0x2264, 0x0294, 0x01 },
	{ 0x226a, 0x0296, 0x01 }, { 0x2282, 0x0298, 0x01 },
	{ 0x2286, 0x029a, 0x01 }, { 0x22a5, 0x029c, 0x00 },
	{ 0x22c2, 0x029d, 0x00 }, { 0x22c3, 0x0036, 0x00 },
	{ 0x2300, 0x027d, 0x00 }, { 0x2302, 0x029e, 0x00 },
	{ 0x2308, 0x029f, 0x03 }, { 0x2310, 0x02a3, 0x00 },
	{ 0x2319, 0x02a4, 0x00 }, { 0x2320, 0x02a5, 0x01 },
	{ 0x239b, 0x02a7, 0x06 }, { 0x23a2, 0x02a8, 0x00 },
	{ 0x23a3, 0x02ae, 0x01 }, { 0x23a5, 0x02ab, 0x00 },
	{ 0x23a6, 0x02b0, 0x03 }, { 0x23ab, 0x02b4, 0x04 },
	{ 0x23ba, 0x02b9, 0x03 }, { 0x23d0, 0x02b7, 0x00 },
	{ 0x2409, 0x02bd, 0x04 }, { 0x2424, 0x02c2, 0x00 },
	{ 0x2500, 0x02b8, 0x00 }, { 0x2501, 0x02c3, 0x00 },
	{ 0x2502, 0x02b7, 0x00 }, { 0x2503, 0x02c4, 0x00 },
	{ 0x2508, 0x02c5, 0x43 }, { 0x2550, 0x0309, 0x43 },
	{ 0x2596, 0x034d, 0x0a }, { 0x25ac, 0x0358, 0x00 },
	{ 0x25ae, 0x0359, 0x00 }, { 0x25b2, 0x035a, 0x00 },
	{ 0x25b6, 0x035b, 0x00 }, { 0x25bc, 0x035c, 0x00 },
	{ 0x25c0, 0x035d, 0x00 }, { 0x25c6, 0x035e, 0x00 },
	{ 0x25ca, 0x035f, 0x01 }, { 0x25cf, 0x022d, 0x00 },
	{ 0x25d8, 0x0361, 0x01 }, { 0x263a, 0x0363, 0x02 },
	{ 0x2640, 0x0366, 0x00 }, { 0x2642, 0x0367, 0x00 },
	{ 0x2660, 0x0368, 0x00 }, { 0x2663, 0x0369, 0x00 },
	{ 0x2665, 0x036a, 0x00 }, { 0x2666, 0x035e, 0x00 },
	{ 0x266a, 0x036b, 0x01 }, { 0x2713, 0x036d, 0x01 },
	{ 0x2717, 0x036f, 0x01 }, { 0x27e8, 0x0371, 0x03 },
	{ 0x2800, 0x0001, 0x00 }, { 0x2801, 0x0375, 0xfe },
	{ 0x2e2c, 0x0474, 0x00 }, { 0xe0a0, 0x0475, 0x02 },
	{ 0xe0b0, 0x0478, 0x03 }, { 0xf6be, 0x0148, 0x00 },
};

static struct vt_font_map font_mapping_bold[319] = {
	{ 0x0021, 0x047c, 0x0b }, { 0x002d, 0x0220, 0x00 },
	{ 0x002e, 0x0488, 0x50 }, { 0x00a1, 0x04d9, 0x07 },
	{ 0x00aa, 0x04e1, 0x03 }, { 0x00af, 0x04e5, 0x07 },
	{ 0x00b7, 0x0289, 0x00 }, { 0x00b8, 0x04ed, 0x57 },
	{ 0x0110, 0x0505, 0x00 }, { 0x0111, 0x0545, 0x08 },
	{ 0x011a, 0x0548, 0x01 }, { 0x011c, 0x054e, 0x59 },
	{ 0x0178, 0x05a8, 0x07 }, { 0x0186, 0x05b0, 0x00 },
	{ 0x018e, 0x05b1, 0x02 }, { 0x0192, 0x05b4, 0x00 },
	{ 0x019d, 0x05b5, 0x01 }, { 0x01b7, 0x05b7, 0x00 },
	{ 0x0218, 0x05b8, 0x03 }, { 0x0232, 0x05bc, 0x01 },
	{ 0x0237, 0x05be, 0x00 }, { 0x0254, 0x05bf, 0x00 },
	{ 0x0258, 0x05c0, 0x01 }, { 0x025b, 0x05c2, 0x00 },
	{ 0x0272, 0x05c3, 0x00 }, { 0x0292, 0x05c4, 0x00 },
	{ 0x02bb, 0x05c5, 0x02 }, { 0x02c6, 0x05c8, 0x01 },
	{ 0x02d8, 0x05c9, 0x01 }, { 0x02db, 0x05cb, 0x02 },
	{ 0x0300, 0x04ba, 0x00 }, { 0x0301, 0x04ea, 0x00 },
	{ 0x0302, 0x05c8, 0x00 }, { 0x0303, 0x05cc, 0x00 },
	{ 0x0304, 0x04e5, 0x00 }, { 0x0305, 0x05ce, 0x00 },
	{ 0x0306, 0x05c9, 0x01 }, { 0x0308, 0x04e0, 0x00 },
	{ 0x030a, 0x05cf, 0x00 }, { 0x030b, 0x05cd, 0x00 },
	{ 0x030c, 0x05c9, 0x00 }, { 0x0329, 0x05d0, 0x00 },
	{ 0x0384, 0x05d1, 0x06 }, { 0x038c, 0x05d8, 0x00 },
	{ 0x038e, 0x05d9, 0x02 }, { 0x0391, 0x049b, 0x01 },
	{ 0x0393, 0x05dc, 0x01 }, { 0x0395, 0x049f, 0x00 },
	{ 0x0396, 0x04b4, 0x00 }, { 0x0397, 0x04a2, 0x00 },
	{ 0x0398, 0x05de, 0x00 }, { 0x0399, 0x04a3, 0x00 },
	{ 0x039a, 0x04a5, 0x00 }, { 0x039b, 0x05df, 0x00 },
	{ 0x039c, 0x04a7, 0x01 }, { 0x039e, 0x05e0, 0x00 },
	{ 0x039f, 0x04a9, 0x00 }, { 0x03a0, 0x05e1, 0x00 },
	{ 0x03a1, 0x04aa, 0x00 }, { 0x03a3, 0x05e2, 0x00 },
	{ 0x03a4, 0x04ae, 0x00 }, { 0x03a5, 0x04b3, 0x00 },
	{ 0x03a6, 0x05e3, 0x00 }, { 0x03a7, 0x04b2, 0x00 },
	{ 0x03a8, 0x05e4, 0x01 }, { 0x03aa, 0x0504, 0x00 },
	{ 0x03ab, 0x05a8, 0x00 }, { 0x03ac, 0x05e6, 0x08 },
	{ 0x03b5, 0x05c2, 0x00 }, { 0x03b6, 0x05ef, 0x00 },
	{ 0x03b7, 0x05b6, 0x00 }, { 0x03b8, 0x05f0, 0x01 },
	{ 0x03ba, 0x056a, 0x00 }, { 0x03bb, 0x05f2, 0x00 },
	{ 0x03bc, 0x04eb, 0x00 }, { 0x03bd, 0x04d0, 0x00 },
	{ 0x03be, 0x05f3, 0x00 }, { 0x03bf, 0x04c9, 0x00 },
	{ 0x03c0, 0x05f4, 0x0b }, { 0x03cc, 0x0528, 0x00 },
	{ 0x03cd, 0x0600, 0x01 }, { 0x03d1, 0x0602, 0x00 },
	{ 0x03d5, 0x0603, 0x00 }, { 0x03f0, 0x0604, 0x01 },
	{ 0x03f2, 0x04bd, 0x00 }, { 0x03f3, 0x04c4, 0x00 },
	{ 0x03f4, 0x0606, 0x02 }, { 0x0400, 0x04fd, 0x00 },
	{ 0x0401, 0x0500, 0x00 }, { 0x0402, 0x0609, 0x02 },
	{ 0x0405, 0x04ad, 0x00 }, { 0x0406, 0x04a3, 0x00 },
	{ 0x0407, 0x0504, 0x00 }, { 0x0408, 0x04a4, 0x00 },
	{ 0x0409, 0x060c, 0x06 }, { 0x0410, 0x049b, 0x00 },
	{ 0x0411, 0x0613, 0x00 }, { 0x0412, 0x049c, 0x00 },
	{ 0x0413, 0x05dc, 0x00 }, { 0x0414, 0x0614, 0x00 },
	{ 0x0415, 0x049f, 0x00 }, { 0x0416, 0x0615, 0x00 },
	{ 0x0417, 0x048d, 0x00 }, { 0x0418, 0x0616, 0x01 },
	{ 0x041a, 0x04a5, 0x00 }, { 0x041b, 0x0618, 0x00 },
	{ 0x041c, 0x04a7, 0x00 }, { 0x041d, 0x04a2, 0x00 },
	{ 0x041e, 0x04a9, 0x00 }, { 0x041f, 0x05e1, 0x00 },
	{ 0x0420, 0x04aa, 0x00 }, { 0x0421, 0x049d, 0x00 },
	{ 0x0422, 0x04ae, 0x00 }, { 0x0423, 0x0619, 0x01 },
	{ 0x0425, 0x04b2, 0x00 }, { 0x0426, 0x061b, 0x09 },
	{ 0x0430, 0x04bb, 0x00 }, { 0x0431, 0x0625, 0x02 },
	{ 0x0434, 0x04c1, 0x00 }, { 0x0435, 0x04bf, 0x00 },
	{ 0x0436, 0x0628, 0x01 }, { 0x0438, 0x04cf, 0x00 },
	{ 0x0439, 0x059f, 0x00 }, { 0x043a, 0x056a, 0x00 },
	{ 0x043b, 0x062a, 0x02 }, { 0x043e, 0x04c9, 0x00 },
	{ 0x043f, 0x05f4, 0x00 }, { 0x0440, 0x04ca, 0x00 },
	{ 0x0441, 0x04bd, 0x00 }, { 0x0442, 0x062d, 0x00 },
	{ 0x0443, 0x04d3, 0x00 }, { 0x0444, 0x0603, 0x00 },
	{ 0x0445, 0x04d2, 0x00 }, { 0x0446, 0x062e, 0x09 },
	{ 0x0450, 0x051d, 0x00 }, { 0x0451, 0x0520, 0x00 },
	{ 0x0452, 0x0638, 0x02 }, { 0x0455, 0x04cd, 0x00 },
	{ 0x0456, 0x04c3, 0x00 }, { 0x0457, 0x0524, 0x00 },
	{ 0x0458, 0x04c4, 0x00 }, { 0x0459, 0x063b, 0x01 },
	{ 0x045b, 0x0559, 0x00 }, { 0x045c, 0x063d, 0x00 },
	{ 0x045d, 0x052e, 0x00 }, { 0x045e, 0x063e, 0x01 },
	{ 0x0462, 0x0640, 0x01 }, { 0x046a, 0x0642, 0x01 },
	{ 0x0490, 0x0644, 0x0d }, { 0x04a0, 0x0652, 0x05 },
	{ 0x04aa, 0x0658, 0x01 }, { 0x04ae, 0x04b3, 0x00 },
	{ 0x04af, 0x05ed, 0x00 }, { 0x04b0, 0x065a, 0x03 },
	{ 0x04b6, 0x065e, 0x05 }, { 0x04c0, 0x04a3, 0x00 },
	{ 0x04c1, 0x0664, 0x01 }, { 0x04cf, 0x04c6, 0x00 },
	{ 0x04d0, 0x0537, 0x01 }, { 0x04d2, 0x04f9, 0x00 },
	{ 0x04d3, 0x0519, 0x00 }, { 0x04d4, 0x04fb, 0x00 },
	{ 0x04d5, 0x051b, 0x00 }, { 0x04d6, 0x0548, 0x01 },
	{ 0x04d8, 0x05b2, 0x00 }, { 0x04d9, 0x05c1, 0x00 },
	{ 0x04da, 0x0666, 0x05 }, { 0x04e2, 0x066c, 0x00 },
	{ 0x04e3, 0x059d, 0x00 }, { 0x04e4, 0x066d, 0x00 },
	{ 0x04e5, 0x0531, 0x00 }, { 0x04e6, 0x050b, 0x00 },
	{ 0x04e7, 0x052b, 0x00 }, { 0x04e8, 0x0606, 0x00 },
	{ 0x04e9, 0x066e, 0x05 }, { 0x04ef, 0x05bd, 0x00 },
	{ 0x04f0, 0x0674, 0x00 }, { 0x04f1, 0x0534, 0x00 },
	{ 0x04f2, 0x0675, 0x03 }, { 0x04f8, 0x0679, 0x01 },
	{ 0x1e0c, 0x067b, 0x01 }, { 0x1e34, 0x067d, 0x03 },
	{ 0x1e40, 0x0681, 0x07 }, { 0x1e6c, 0x0689, 0x01 },
	{ 0x1eb8, 0x068b, 0x01 }, { 0x1ebc, 0x068d, 0x01 },
	{ 0x1eca, 0x068f, 0x03 }, { 0x1ee4, 0x0693, 0x01 },
	{ 0x1ef8, 0x0695, 0x01 }, { 0x2010, 0x04e4, 0x00 },
	{ 0x2011, 0x04e4, 0x00 }, { 0x2012, 0x0220, 0x00 },
	{ 0x2013, 0x0220, 0x00 }, { 0x2016, 0x0697, 0x03 },
	{ 0x201a, 0x0487, 0x00 }, { 0x201b, 0x069b, 0x06 },
	{ 0x2026, 0x06a2, 0x00 }, { 0x2030, 0x06a3, 0x00 },
	{ 0x2032, 0x06a4, 0x01 }, { 0x2039, 0x06a6, 0x01 },
	{ 0x203c, 0x06a8, 0x00 }, { 0x203e, 0x05ce, 0x00 },
	{ 0x2070, 0x06a9, 0x01 }, { 0x2074, 0x06ab, 0x06 },
	{ 0x207d, 0x06b2, 0x0d }, { 0x208d, 0x06c0, 0x01 },
	{ 0x2090, 0x06c2, 0x08 }, { 0x209a, 0x06cb, 0x00 },
	{ 0x20a7, 0x06cc, 0x00 }, { 0x20ac, 0x06cd, 0x00 },
	{ 0x20ae, 0x06ce, 0x00 }, { 0x210e, 0x04c2, 0x00 },
	{ 0x210f, 0x0559, 0x00 }, { 0x2126, 0x05e5, 0x00 },
	{ 0x2135, 0x06cf, 0x00 }, { 0x2190, 0x06d0, 0x05 },
	{ 0x21a4, 0x06d6, 0x00 }, { 0x21a6, 0x06d7, 0x00 },
	{ 0x21a8, 0x06d8, 0x00 }, { 0x21b5, 0x06d9, 0x00 },
	{ 0x21bb, 0x06da, 0x00 }, { 0x21cb, 0x06db, 0x01 },
	{ 0x21d0, 0x06dd, 0x05 }, { 0x2200, 0x06e3, 0x00 },
	{ 0x2203, 0x06e4, 0x02 }, { 0x2206, 0x05dd, 0x00 },
	{ 0x2207, 0x06e7, 0x06 }, { 0x2212, 0x0220, 0x00 },
	{ 0x2213, 0x06ee, 0x03 }, { 0x2219, 0x06f2, 0x01 },
	{ 0x221e, 0x06f4, 0x01 }, { 0x2225, 0x0697, 0x00 },
	{ 0x2227, 0x06f6, 0x03 }, { 0x2248, 0x06fa, 0x00 },
	{ 0x2260, 0x06fb, 0x01 }, { 0x2264, 0x06fd, 0x01 },
	{ 0x226a, 0x06ff, 0x01 }, { 0x2282, 0x0701, 0x01 },
	{ 0x2286, 0x0703, 0x01 }, { 0x22a5, 0x0705, 0x00 },
	{ 0x22c2, 0x0706, 0x00 }, { 0x22c3, 0x04af, 0x00 },
	{ 0x2300, 0x06e6, 0x00 }, { 0x2302, 0x0707, 0x00 },
	{ 0x2308, 0x0708, 0x03 }, { 0x2310, 0x070c, 0x00 },
	{ 0x2319, 0x070d, 0x00 }, { 0x2320, 0x070e, 0x01 },
	{ 0x239b, 0x0710, 0x06 }, { 0x23a2, 0x0711, 0x00 },
	{ 0x23a3, 0x0717, 0x01 }, { 0x23a5, 0x0714, 0x00 },
	{ 0x23a6, 0x0719, 0x03 }, { 0x23ab, 0x071d, 0x02 },
	{ 0x23ae, 0x02c4, 0x00 }, { 0x23af, 0x02c3, 0x00 },
	{ 0x23ba, 0x0720, 0x02 }, { 0x23bd, 0x033a, 0x00 },
	{ 0x23d0, 0x02c4, 0x00 }, { 0x2409, 0x0723, 0x04 },
	{ 0x2424, 0x0728, 0x00 }, { 0x2500, 0x02c3, 0x00 },
	{ 0x2501, 0x0729, 0x00 }, { 0x2502, 0x02c4, 0x00 },
	{ 0x2503, 0x072a, 0x00 }, { 0x2508, 0x02c6, 0x00 },
	{ 0x2509, 0x072b, 0x00 }, { 0x250a, 0x02c8, 0x00 },
	{ 0x250b, 0x072c, 0x00 }, { 0x250c, 0x02cc, 0x00 },
	{ 0x250d, 0x072d, 0x02 }, { 0x2510, 0x02d0, 0x00 },
	{ 0x2511, 0x0730, 0x02 }, { 0x2514, 0x02d4, 0x00 },
	{ 0x2515, 0x0733, 0x02 }, { 0x2518, 0x02d8, 0x00 },
	{ 0x2519, 0x0736, 0x02 }, { 0x251c, 0x02e0, 0x00 },
	{ 0x251d, 0x0739, 0x06 }, { 0x2524, 0x02e8, 0x00 },
	{ 0x2525, 0x0740, 0x06 }, { 0x252c, 0x02f0, 0x00 },
	{ 0x252d, 0x0747, 0x06 }, { 0x2534, 0x02f8, 0x00 },
	{ 0x2535, 0x074e, 0x06 }, { 0x253c, 0x0308, 0x00 },
	{ 0x253d, 0x0755, 0x0e }, { 0x2550, 0x0764, 0x25 },
	{ 0x2576, 0x0333, 0x01 }, { 0x2578, 0x078a, 0x07 },
	{ 0x25a0, 0x0792, 0x00 }, { 0x25ac, 0x0793, 0x00 },
	{ 0x25ae, 0x0794, 0x00 }, { 0x25b2, 0x0795, 0x00 },
	{ 0x25b6, 0x0796, 0x00 }, { 0x25bc, 0x0797, 0x00 },
	{ 0x25c0, 0x0798, 0x00 }, { 0x25c6, 0x0799, 0x00 },
	{ 0x25ca, 0x079a, 0x01 }, { 0x25cf, 0x079c, 0x00 },
	{ 0x25d9, 0x079d, 0x00 }, { 0x263c, 0x079e, 0x00 },
	{ 0x2640, 0x079f, 0x00 }, { 0x2642, 0x07a0, 0x00 },
	{ 0x2660, 0x07a1, 0x00 }, { 0x2663, 0x07a2, 0x00 },
	{ 0x2666, 0x0799, 0x00 }, { 0x266a, 0x07a3, 0x01 },
	{ 0x2713, 0x036e, 0x00 }, { 0x2714, 0x07a5, 0x00 },
	{ 0x2717, 0x0370, 0x00 }, { 0x2718, 0x07a6, 0x00 },
	{ 0x27e8, 0x07a7, 0x03 }, { 0x2801, 0x07ab, 0xfe },
	{ 0x2e2c, 0x08aa, 0x00 }, { 0xe0a0, 0x08ab, 0x02 },
	{ 0xe0b1, 0x08ae, 0x00 }, { 0xe0b3, 0x08af, 0x00 },
	{ 0xf6be, 0x05be, 0x00 },
};

struct vt_font vt_font_default = {
	.vf_width		= 8,
	.vf_height		= 16,
	.vf_bytes		= font_bytes,
	.vf_map			= {
				    font_mapping_normal,
				    NULL,
				    font_mapping_bold,
				    NULL,
				  },
	.vf_map_count		= { 308, 0, 319, 0 },
	.vf_refcount		= 1,
};
