/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2016-2017 Ilya Bakulin
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/12/usr.bin/sdiotool/linux_compat.h 326695 2017-12-08 15:57:29Z pfg $
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/12/usr.bin/sdiotool/linux_compat.h 326695 2017-12-08 15:57:29Z pfg $");

#ifndef _LINUX_COMPAT_H_
#define _LINUX_COMPAT_H_

/* Linux compatibility shims */
#define uint unsigned int
#define u32 uint32_t
#define u8 uint8_t
#define u16 uint16_t
#define s32 int32_t
#define bool int8_t
#define true 1
#define false 0

#define usleep_range(a, b) usleep(a)
#define ENOMEDIUM -1
#define EINVAL -2

#define WARN_ON(cond) ({                                        \
      bool __ret = (cond);                                      \
      if (__ret) {                                              \
	      printf("WARNING %s failed at %s:%d\n",		\
		     #cond, __FILE__, __LINE__);	        \
      }                                                         \
      (__ret);                                                  \
})

#endif
