#!/bin/sh
# RCS utilities.sh,v 1.9 1995/01/04 14:39:15 tom Exp
#
# utilities.sh: auxiliary shell functions for NeGeN package scripts.
#
# author: Tom Hageman <tom@rna.nl>
#
#			Copyright (C) 1994  R&A

umask 022

cleanup=

trap 'trap 0;rm -rf $cleanup' 0
trap 'exit 255' 1 2 3 15

NAME=`basename "$pkgdir" .pkg | sed 's/\.bs*\$//;s/\.N*I*H*S*\$//'`

date="`date | sed 's/^... \(.*:[0-5][0-9] \).* \(....\)\$/\1\2/'`"
dateext="`echo $date | tr ' ' '_'`_for_${NAME}_from_NeGeN"
bckdateext=Backup_$dateext
newdateext=New_$dateext

# Get working directory for Installer.app.
workdir=`echo "$0" | sed 's:[^/]*$::;s://*$::'`
case "$workdir" in #((
/tmp/*|/private/tmp/*) ;;
*) workdir=/tmp
esac

[ -f "$workdir"/utilities.sh ] || cp "$pkgdir"/utilities.sh "$workdir"

Usage() {
	echo "Usage: $0 package-name destination-directory" >&2
	exit 2
}

CheckRoot() {
	[ "`whoami`" = "root" ] || {
		echo " !!You must be root to install!!  FAILED"
		exit 1
	}
}

CheckPackage() { # <unique-prefix>
	(cd "$pkgdir" &&
	 [ -r $1*.bom -a \( -n "$2" -o -r ShellUtils.tar.Z \) ]) || {
		echo " Hmmm... $pkgdir does not look like it's the $* package."
		echo FAILED
		exit 1
	}
}

CheckLocation() { #assumes destdir contains the intended destination directory.
	case "$destdir" in
	"")
		Xpkgname=`basename "$pkgdir" .pkg`
		for d in "$pkgdir" /NextLibrary/Receipts/"$Xpkgname".pkg
		do
			[ -r "$d/$Xpkgname.location" ] && {
				destdir=`cat "$d/$Xpkgname.location"`
				break
			}
		done
		[ -n "$destdir" ] || {
			echo "FAILED: Cannot determine the destination."
			Usage
		}
	esac
}

UnpackShellUtils() {
	# Unpack shell utilities; also sets up cleanup trap.
	UTILDIR=/tmp/ShellUtils-$$
	mkdirs $UTILDIR
	cleanup="$cleanup $UTILDIR"
	cp -p "$pkgdir"/ShellUtils.tar.Z "$workdir"
	( cd $UTILDIR && zcat "$pkgdir"/ShellUtils.tar.Z | tar xf - )
	PATH=$UTILDIR:$PATH
}

PackageExtras() { # <extras>
	# Copy extra files to workdir so they'll be part of Receipts package
	( cd "$pkgdir" && tar cf - $* ) | ( cd "$workdir" && tar xpf - )
}
