#include <afx.h>
#include <windows.h>
#include <shellapi.h>

#include "regkey.h"

#define REG_OK(lRet) (lRet==(LONG)ERROR_SUCCESS)

CRegKey::CRegKey(void)
{
	m_hKey = (HKEY)NULL;
	Open();
}

CRegKey::CRegKey(char *SubKey)
{
	m_hKey = (HKEY)NULL;
	Open(SubKey);
}

BOOL CRegKey::Open(void)
{
BOOL fOk = FALSE;
	if (m_hKey) Close();
    if (REG_OK(RegOpenKey(HKEY_CLASSES_ROOT, NULL, &m_hKey)))
		{
		fOk = TRUE;
		}
	return fOk;
}

BOOL CRegKey::Open(char *SubKey)
{
BOOL fOk = FALSE;
HKEY hKey = m_hKey ? m_hKey : HKEY_CLASSES_ROOT;
    if (REG_OK(RegOpenKey(hKey, SubKey, &m_hKey)))
		{
		fOk = REG_OK(RegCloseKey(hKey));
		}
	else
		m_hKey = hKey;
	return fOk;
}

char *CRegKey::QueryName(int subscript)
{
char *Name = (char *)NULL;
   if (REG_OK(RegEnumKey(m_hKey, subscript, m_SubKey, sizeof(m_SubKey))))
		{
		Name = m_SubKey;
		}
	return Name;
}

char *CRegKey::operator[](int subscript)
{
char *Value = (char *)NULL;
char *SubKey = QueryName(subscript);
	if (SubKey)
		{
	LONG sizeofValue = (LONG)sizeof(m_Value);
		if (REG_OK(RegQueryValue(m_hKey, SubKey, m_Value, &sizeofValue )))
			Value = m_Value;
		}
	return Value;
}

char *CRegKey::QueryValue( void )
{
char *Value = (char *)NULL;
LONG sizeofValue = (LONG)sizeof(m_Value);
    if (REG_OK(RegQueryValue(m_hKey, (LPCSTR)NULL, m_Value, &sizeofValue )))
    	{
    	Value = m_Value;
    	}
    return Value;
}

char *CRegKey::QueryValue( char *SubKey )
{
char *Value = (char *)NULL;
LONG sizeofValue = (LONG)sizeof(m_Value);
    if (REG_OK(RegQueryValue(m_hKey, SubKey, m_Value, &sizeofValue )))
    	{
    	Value = m_Value;
    	}
    return Value;
}

BOOL CRegKey::Close(void)
{
BOOL fOk = FALSE;
	if (m_hKey && m_hKey!=HKEY_CLASSES_ROOT)
		{
		fOk = REG_OK(RegCloseKey(m_hKey));
		m_hKey = NULL;
		}
	return fOk;
}
	
CRegKey::~CRegKey(void)
{
	Close();
}
