/* conv.c
 *
 * Reads a character set from stdin converts and outputs to stdout.
 */

#ifndef lint
static char Rcsid[] = "@(#)$Header: /usr/local/src/mail/sendmail/ida/charset/RCS/conv.c,v 1.4 1991/06/28 18:41:20 paul Exp $";

#endif

/*
 * $Header: /usr/local/src/mail/sendmail/ida/charset/RCS/conv.c,v 1.4 1991/06/28 18:41:20 paul Exp $
 *
 * $Log: conv.c,v $
 * Revision 1.4  1991/06/28  18:41:20  paul
 * Replace older xalloc.c with new version from ../../src/util.c .
 *
 * Revision 1.3  1991/04/05  17:06:30  paul
 * Eliminated constant strings passed as arguments.
 *
 * Revision 1.2  1991/04/05  15:56:39  paul
 * Adapted to use the new strcnv.c
 *
 */


#include "sendmail.h"
#include <errno.h>

#define SLEN	256		/* max length in octets of images */
static CHARSET *in;
static CHARSET *out;


main (argc, argv)
	int	 argc;
	char   **argv;
{
	CHAR8U	 s[SLEN], r[SLEN];
	char dk[3], us[3];

	(void) strcpy(dk, "DK");
	(void) strcpy(us, "us");

	switch (argc) {
	    case 1:
		in = getchset (dk, '&');
		out = getchset (us, DEFAULT_ESCAPE);
		break;

	    case 3:
		in = getchset (argv[1], DEFAULT_ESCAPE);
		out = getchset (argv[2], DEFAULT_ESCAPE);
		break;

	    case 5:
		in = getchset (argv[1], (INT16S) atoi (argv[2]));
		out = getchset (argv[3], (INT16S) atoi (argv[4]));
		break;

	    default:
		printf ("\n\nUsage:  %s charset-in   [escape-in]  charset-out  [escape-out]\n\n", argv[0]);
		exit (1);
	}

	if (in == NULL || out == NULL) {
		printf ("\n\n*** Error: Unknown Charset/s\n\n");
		exit (1);
	}
	/*
	 * Should output records of unlimited length by outputting one part at
	 * a time.
	 */
	while (fgets (s, SLEN, stdin)) {
		strncnv (out, in, r, s, SLEN);
		fputs (r, stdout);
	}
	exit (0);
}
/*
**  DFOPEN -- determined file open
**
**	This routine has the semantics of fopen, except that it will
**	keep trying a few times to make this happen.  The idea is that
**	on very loaded systems, we may run out of resources (inodes,
**	whatever), so this tries to get around it.
*/

FILE *
dfopen(filename, mode)
	const char *filename;
	const char *mode;
{
	register int tries;
	register FILE *fp;

	for (tries = 0; tries < 10; tries++)
	{
		sleep((unsigned) (10 * tries));
		errno = 0;
		fp = fopen(filename, mode);
		if (fp != NULL)
			break;
		if (errno != ENFILE && errno != EINTR)
			break;
	}
	errno = 0;
	return (fp);
}
/*
**  XALLOC -- Allocate memory and bitch wildly on failure.
**
**	THIS IS A CLUDGE.  This should be made to give a proper
**	error -- but after all, what can we do?
**
**	Parameters:
**		sz -- size of area to allocate.
**
**	Returns:
**		pointer to data region.
**
**	Side Effects:
**		Memory is allocated.
*/

#ifdef __STDC__
void *
#else /* !__STDC__ */
char *
#endif /* __STDC__ */
xalloc(sz)
	register int sz;
{
#ifdef __STDC__
	register void *p;
#else /* !__STDC__ */
	register char *p;
#endif /* __STDC__ */

	p = malloc((unsigned) sz);
	if (p == NULL)
	{
		syserr("Out of memory!!");
		abort();
		/* exit(EX_UNAVAILABLE); */
	}
	bzero((char *) p, sz);
	return (p);
}
