/*****************************************************/
/* demotear.c                                        */
/* -- Program demonstrates tear-off menus.           */
/*****************************************************/
#include <windows.h>
#include "tearoff.h"

const char szTitle[]     = "Tear Off Menu Demo";

#ifdef __BORLANDC__
    #pragma argsused
#endif
LRESULT CALLBACK __export LwWndProc(HWND hwnd, UINT wm,
  WPARAM wParam, LPARAM lParam);

int PASCAL WinMain(HINSTANCE hins, HINSTANCE hinsPrev,
  LPSTR lpsz, int wShow)
/*****************************************************/
/* -- Entry point.                                   */
/*****************************************************/
    {
    MSG     msg;
    HWND    hwnd;

    if (NULL == hinsPrev) /* Main window class. */
        {
        WNDCLASS    wcs;

        wcs.style = 0;
        wcs.lpfnWndProc = LwWndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hins;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = "DemoTear";
        wcs.lpszClassName = "DemoTear";
        if (!RegisterClass(&wcs))
            return FALSE;
        }

    msg.wParam = 0;
    if (NULL != (hwnd = CreateWindow("DemoTear",
      szTitle, WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hins, NULL)))
        {
        ShowWindow(hwnd, wShow);
        while (GetMessage(&msg, NULL, 0, 0))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }
    return msg.wParam;
    }

LRESULT CALLBACK __export LwWndProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Main window procedure.                         */
/*****************************************************/
    {
    HMENU hmnu;
    char  szBuf[128];
    UINT  mid;

    FilterTearOff(hwnd, wm, wParam, lParam);

    switch (wm)
        {
    default:
        break;

    case WM_DESTROY:
        PostQuitMessage(0);
        break;

    case WM_LBUTTONDOWN: /* Pop a menu at the mouse. */
        if (NULL == (hmnu = GetMenu(hwnd)) ||
          NULL == (hmnu = GetSubMenu(hmnu, 1)))
            break;
        ClientToScreen(hwnd, (LPPOINT)&lParam);
        TrackPopupMenu(hmnu, TPM_LEFTALIGN |
            TPM_LEFTBUTTON, LOWORD(lParam),
          HIWORD(lParam), 0, hwnd, NULL);
        break;

    case WM_COMMAND:
        if (lParam != 0 || /* From a menu? */
          NULL == (hmnu = GetMenu(hwnd)))
            break;

        if (wParam >= 1001 && wParam <= 1004 &&
          NULL != (hmnu = GetSubMenu(hmnu, 0)))
            {
            for (mid = 1001; mid <= 1004; mid++)
                CheckMenuItem(hmnu, mid, MF_BYCOMMAND |
                  (mid == wParam ?
                    MF_CHECKED : MF_UNCHECKED));
            UpdateTearOffs(hwnd, hmnu);
            }

        if (wParam == 1009)
            DestroyTearOffs(hwnd);
        else
            {
            wsprintf(szBuf, "Menu item %d picked.",
              wParam - 1000);
            MessageBox(hwnd, szBuf, szTitle, MB_OK);
            }
        break;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }
