/*****************************************************/
/* tearoff.c                                         */
/* -- Module implements tear-off menus.              */
/*****************************************************/
#include "tearutil.h"

const char szMenuClass[] = "#32768";
const char szTearClass[] = "TearOffPopup";
const char szMenuTag[]   = "MenuTag";

HWND    hwndMainMenu; /* USER's reusable menu wnd. */
PTOS    ptosHead;     /* Head of TOS linked list. */
WNDPROC lpfnMenu;     /* USER's menu window proc. */
UINT    wmPrivate;    /* Our private windows msg. */
int     dyText;       /* System font height. */
HBITMAP hbmpSys;      /* Small system-menu icon. */ 
BITMAP  bmpSys;       /* Metrics of icon. */
HDC     hdcMem;       /* Memory DC. */

#ifdef __BORLANDC__
    #pragma argsused
#endif
int CALLBACK LibMain(HINSTANCE hins, WORD ds,
  WORD cbHeap, LPSTR lpsz)
/*****************************************************/
/* -- Initialize the tear-off menu module.           */
/*****************************************************/
    {
    WNDCLASS wcs;

    wcs.style = CS_GLOBALCLASS; /* Register the tear-*/
    wcs.lpfnWndProc = LwTearProc; /* off class. */
    wcs.cbClsExtra = 0;
    wcs.cbWndExtra = sizeof(PTOS);
    wcs.hInstance = hins;
    wcs.hIcon = NULL;
    wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
    wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
    wcs.lpszMenuName = NULL;
    wcs.lpszClassName = szTearClass;
    if (!RegisterClass(&wcs))
        return FALSE;

    /* Use a private message for dropping tear-off */
    /* menus, since the owner window will see this */
    /* message. */
    wmPrivate = RegisterWindowMessage(szTearClass);
    if (NULL == wmPrivate)
        return FALSE;

    /* Find resuable menu window. */
    if ((GetSystemDebugState() & SDS_MENU) ||
      NULL == (hwndMainMenu = HwndMenuCur()))
        return FALSE;
    lpfnMenu = (WNDPROC)
      GetWindowLong(hwndMainMenu, GWL_WNDPROC);

    /* System icon. */
    if (NULL == (hbmpSys = LoadBitmap(NULL,
      MAKEINTRESOURCE(OBM_CLOSE))))
        return FALSE;
    GetObject(hbmpSys, sizeof bmpSys, &bmpSys);
	bmpSys.bmWidth /= 2; /* Use second half. */

    /* Need a memory DC for blits. */
    if (NULL == (hdcMem = CreateCompatibleDC(NULL)))
        return FALSE;

    /* Text height. */
    dyText = HIWORD(GetDialogBaseUnits());
    return TRUE;
    }

#ifdef __BORLANDC__
    #pragma argsused
#endif
int CALLBACK __export WEP(int wExitCode)
    {
    if (NULL != hdcMem)
        DeleteDC(hdcMem);
    if (NULL != hbmpSys)
        DeleteObject(hbmpSys);
    if (IsWindow(hwndMainMenu))
        FreeTos(PtosRemoveWnd(hwndMainMenu));
    return 1;
    }

void WINAPI __export FilterTearOff(HWND hwnd, UINT wm,
  WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Callback filters messages from the owner       */
/*    window needed by the tear-off module.          */
/*****************************************************/
    {
    char  szMenu[256];
    HWND  hwndT;
    PTOS  ptos, ptosNext;
    int   cch;
    HMENU hmnu;

    /* The wmPrivate message has 2 meanings.  When  */
    /* lParam is non-null, it contains the popup    */
    /* menu data for a new tear-off.  When non-null */
    /* it means USER attempted to activate a        */
    /* tear-off window, which is disallowed.        */
    if (wm == wmPrivate)
        {
        if (0 != lParam)
            { /* Create a new tear-off. */
            ptos = (PTOS)LOWORD(lParam);
            if (NULL != CreateWindow(szTearClass,
              ptos->szTitle, WS_POPUP, 0, 0, 0, 0,
              hwnd, NULL, GetWindowInstance(hwnd),
              (LPVOID)lParam))EndSnap(ptos, (HWND)wParam,
                                      TRUE, dyText, hdcMem);
            else
                FreeTos(ptos);
            }
        else /* Activate owner window. */
            SetActiveWindow(hwnd);
        }
    else switch (wm)
        {
    default:
        break;

    case WM_NCACTIVATE: /* (De)activate tear-offs. */ 
        for (ptos = ptosHead; NULL != ptos;
          ptos = ptos->ptosNext)
            if (hwnd == ptos->hwndOwner)
                {
                if (0 == wParam)
                    ptos->grftos &= ~ftosActive;
                else
                    ptos->grftos |= ftosActive;
                InvalidateRect(ptos->hwnd, NULL,
                  FALSE);
                UpdateWindow(ptos->hwnd);
                }
        break;

    case WM_INITMENUPOPUP:
        FreeTos(PtosRemoveWnd(hwnd));
        if (HIWORD(lParam))
            break; /* System menu. */

        /* If a tear-off for this menu exists, */
        /* destroy it unless its a tear-off's */
        /* menu that is being activated. */
        for (ptos = ptosHead; NULL != ptos;
          ptos = ptos->ptosNext)
            if ((HMENU)wParam == ptos->hmnu)
                {
                if (ptos->grftos & ftosTearMenu)
                    {
                    ptos->grftos &= ~ftosTearMenu;
                    return;
                    }
                DestroyWindow(ptos->hwnd);
                break;
                }

        /* Get menu title from parent menu. */
        cch = 0;
        if (NULL != (hmnu = HmnuFind(GetMenu(hwnd),
            (HMENU)wParam, LOWORD(lParam))))
            cch = GetMenuString(hmnu, LOWORD(lParam),
              szMenu, sizeof szMenu, MF_BYPOSITION);

        /* Gather up menu info. */
        if (NULL == (ptos = PtosAlloc(cch)))
            break;
        ptos->hmnu = (HMENU)wParam;
        ptos->hwndOwner = hwnd;
        if (0 != cch)
            lstrcpy(ptos->szTitle, szMenu);

        /* Temporarily save menu data with owner. */
        if (!FSetWndPtos(hwnd, ptos))
            FreeTos(ptos); /* All that work for zip. */
        break;

    case WM_ENTERIDLE:
        if (MSGF_MENU != wParam ||
          NULL == (hwndT = HwndMenuCur()))
            break;

        if (NULL == (ptos = PtosRemoveWnd(hwnd)))
            {
            if (GetKeyState(VK_RBUTTON) < 0)
                {
                GetCursorPos((LPPOINT)&lParam);
                goto LRButtonDown;
                }
            break;
            }

        /* Transfer info to USER menu window and */
        /* subclass transient popup's to remove */
        /* window property. */
        if (FSetWndPtos(hwndT, ptos))
            {
            if (hwndMainMenu != hwndT)
                SubclassWindow(hwndT, LwSubclassProc);
            }
        else
            FreeTos(ptos);
        break;

    case WM_RBUTTONDOWN:
LRButtonDown:
        if (WindowFromPoint(*(POINT *)&lParam) ==
          (hwndT = HwndMenuCur()) &&
          NULL != (ptos = PtosRemoveWnd(hwndT)))
            BeginSnap(ptos, hwnd, hwndT, wmPrivate);
        break;

    case WM_DESTROY:
        FreeTos(PtosRemoveWnd(hwnd));
        for (ptos = ptosHead; NULL != ptos; /* Nuke */
          ptos = ptosNext)  /* all associated tear- */
            {
            ptosNext = ptos->ptosNext;
            if (hwnd == ptos->hwndOwner)   /* offs. */
                DestroyWindow(ptos->hwnd);
            }
        break;
        }
    }

void FreeTos(PTOS ptos)
/*****************************************************/
/* -- Clean up stuff hanging off node and free it.   */
/*****************************************************/
    {
    if (NULL == ptos)
        return;
    if (NULL != ptos->hbmp)
        DeleteObject(ptos->hbmp);
    LocalFree((HLOCAL)ptos);
    }
LRESULT CALLBACK __export LwSubclassProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Popup menu window subclass procedure.          */
/*****************************************************/
    {
    if (wm == WM_DESTROY)
        FreeTos(PtosRemoveWnd(hwnd));
    return CallWindowProc(lpfnMenu, hwnd, wm, wParam,
      lParam);
    }
LRESULT CALLBACK __export LwTearProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Tearoff window procedure.                      */ 
/*****************************************************/
    {
    PTOS        ptos = (PTOS)GetWindowWord(hwnd, 0);
    PTOS        ptosT, *pptos;
    PAINTSTRUCT wps;
    RECT        rect;
    POINT       pt;
    HWND        hwndT;
    HBRUSH      hbrs, hbrsSav;
    HBITMAP     hbmpSav;

    if (wm == wmPrivate)
         /* Then finish UpdateTearOffs()' work. */
        EndSnap((PTOS)LOWORD(lParam), (HWND)wParam,
                                     FALSE, dyText, hdcMem);
    else switch (wm)
        {
    default:
        break;

    case WM_MOUSEACTIVATE: /* Ditto. */
        SetActiveWindow(ptos->hwndOwner);
        return MA_NOACTIVATE;

    case WM_ACTIVATE: /* Give it back to owner. */
        PostMessage(ptos->hwndOwner, wmPrivate, 0, 0);
        return 0;

    case WM_CREATE:
        ptos = (PTOS)LOWORD(((LPCREATESTRUCT)lParam)->
          lpCreateParams);
        ptos->hwnd = hwnd;
        ptos->grftos = ftosActive;
        ptos->ptosNext = ptosHead; /* Link in list. */
        ptosHead = ptos;
        SetWindowWord(hwnd, 0, (WORD)ptos);
        SendMessage(ptos->hwndOwner, wmTearOffCreate,
          (WPARAM)hwnd, MAKELONG(ptos->hmnu, 0));
        break;

    case WM_PAINT:
        BeginPaint(hwnd, &wps);
        PaintSysIcon(ptos, wps.hdc, hdcMem, hbmpSys, dyText, bmpSys);
        GetClientRect(hwnd, &rect);

        /* Paint caption background. */
        hbrsSav = NULL;
        if (NULL != (hbrs = CreateSolidBrush(
          GetSysColor((ptos->grftos & ftosActive) ?
          COLOR_ACTIVECAPTION :
          COLOR_INACTIVECAPTION))))
            hbrsSav = SelectObject(wps.hdc, hbrs);
        Rectangle(wps.hdc, dyText, 0, rect.right,
          dyText + 1);
        if (NULL != hbrsSav)
            SelectObject(wps.hdc, hbrsSav);
        if (NULL != hbrs)
            DeleteObject(hbrs);

        /* Paint caption text. */
        SetBkMode(wps.hdc, TRANSPARENT); /* Text. */
        SetTextColor(wps.hdc, GetSysColor(
          (ptos->grftos & ftosActive) ?
            COLOR_CAPTIONTEXT :
            COLOR_INACTIVECAPTIONTEXT));
        rect.left += dyText + 1;
        DrawText(wps.hdc, ptos->szTitle, -1, &rect,
          DT_CENTER | DT_SINGLELINE | DT_TOP);

        /* Paint menu image. */
        hbmpSav = SelectObject(hdcMem, ptos->hbmp);
        BitBlt(wps.hdc, 0, dyText, rect.right,
          rect.bottom, hdcMem, 0, 0, SRCCOPY);
        if (NULL != hbmpSav)
            SelectObject(hdcMem, hbmpSav);
        EndPaint(hwnd, &wps);

        /* If we somehow got a paint during a drag, */
        /* restore the ghost frame. */
        if ((ptos->grftos & (ftosDrag | ftosOn)) ==
          (ftosDrag | ftosOn))
            DrawGhost(ptos);
        return 0;

    case WM_ERASEBKGND: /* Who needs it?! */
        return TRUE;

    case WM_DESTROY: /* Clean up, inform owner. */
        SendMessage(ptos->hwndOwner, wmTearOffDestroy,
          (WPARAM)hwnd, MAKELONG(ptos->hmnu, 0));
        for (pptos = &ptosHead; /* Unlink from list. */
          NULL != *pptos; pptos = &(*pptos)->ptosNext)
            if (*pptos == ptos)
                {
                *pptos = ptos->ptosNext;
                break;
                }
        FreeTos(ptos);
        break;

    case WM_LBUTTONDOWN: /* Enter drag mode, track */
    case WM_RBUTTONDOWN: /* icon, or activate menu. */
        /* Bring to top without activating. */
        SetWindowPos(hwnd, HWND_TOP, 0, 0, 0, 0,
          SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOMOVE);
        pt = *(POINT *)&lParam;
        if (pt.y < dyText || wm == WM_RBUTTONDOWN)
            { /* Hit inside caption area. */
            if (pt.x >= dyText || wm == WM_RBUTTONDOWN)
                { /* Hit outside system icon. */
                /* Update all tear-offs first. */
                for (ptosT = ptosHead; NULL != ptosT;
                  ptosT = ptosT->ptosNext)
                    UpdateWindow(ptosT->hwnd);
                ptos->dpt = pt; /* Drag offset. */
                ClientToScreen(hwnd, &pt);
                ptos->pt = pt; /* Current position. */
                ptos->grftos |= ftosDrag;
                ptos->grftos &= ~ftosOn;  /* frame. */
                DrawGhost(ptos);   /* Display ghost */
                }
            else
                { /* Hit inside system icon. */
                ptos->grftos |= ftosHilite;
                PaintSysIcon(ptos, NULL, hdcMem, hbmpSys,
                                            dyText, bmpSys);
                }
            SetCapture(hwnd);
            }
        else
            { /* Drop the real menu. */
            pt.x = 0;
            pt.y = dyText;
            ClientToScreen(hwnd, &pt);
            ptos->grftos |= ftosTearMenu;
            TrackPopupMenu(ptos->hmnu,
              TPM_LEFTALIGN | TPM_LEFTBUTTON, pt.x,
              pt.y, 0, ptos->hwndOwner, NULL);
            }
        break;

    case WM_MOUSEMOVE:
        if (GetCapture() != hwnd)
            break;
        pt = *(POINT *)&lParam;
        if (ptos->grftos & ftosDrag)
            {
            ClientToScreen(hwnd, &pt);
            if (pt.x != ptos->pt.x ||
              pt.y != ptos->pt.y)
                { /* Drag it some more. */
                DrawGhost(ptos);
                ptos->pt = pt;
                DrawGhost(ptos);
                }
            }
        else if ((pt.x >= 0 && pt.x < dyText &&
            pt.y >= 0 && pt.y < dyText) ==
          !(ptos->grftos & ftosHilite))
            { /* Toggle system icon hilite. */
            ptos->grftos ^= ftosHilite;
            PaintSysIcon(ptos, NULL, hdcMem, hbmpSys,
                                            dyText, bmpSys);
            }
        break;

    case WM_LBUTTONUP:
    case WM_RBUTTONUP:
        if (GetCapture() != hwnd)
            break;
        ReleaseCapture();
        if (ptos->grftos & ftosDrag)
            { /* End drag mode. */
            DrawGhost(ptos); /* Remove ghost. */
            SetWindowPos(ptos->hwnd, NULL,   /* Move */
              ptos->pt.x - ptos->dpt.x, /* tear-off. */
              ptos->pt.y - ptos->dpt.y, 0, 0,
              SWP_NOACTIVATE | SWP_NOSIZE |
                SWP_NOZORDER);
            ptos->grftos &= ~ftosDrag;
            }
        else if (ptos->grftos & ftosHilite)
            { /* Click on system icon, so nuke. */
            DestroyWindow(hwnd);
            return 0;
            }
        break;

    case WM_ENTERIDLE:
        if (NULL != (hwndT = HwndMenuCur()))
            BeginSnap(ptos, hwnd, hwndT, wmPrivate);
        break;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }

void WINAPI __export UpdateTearOffs(HWND hwnd,
  HMENU hmnu)
/*****************************************************/
/* -- Update all tear-off menus with for the given   */
/*    popup menu owned by the given window.          */
/* -- hwnd : Owner window, all if NULL.              */
/* -- hmnu : Popup menu, all if NULL.                */
/*****************************************************/
    {
    PTOS ptos;
    POINT pt;

    for (ptos = ptosHead; NULL != ptos;
      ptos = ptos->ptosNext)
        {
        if ((NULL != hwnd && hwnd != ptos->hwndOwner)
          || (NULL != hmnu && hmnu != ptos->hmnu))
            continue;
        pt.x = 0;
        pt.y = dyText;
        ClientToScreen(ptos->hwnd, &pt);
        TrackPopupMenu(ptos->hmnu,
          TPM_LEFTALIGN | TPM_LEFTBUTTON,
          pt.x, pt.y, 0, ptos->hwnd, NULL);
        }
    }
