/*******************************************************/
/* tearoff.h                                           */
/* -- Interface to tear-off menu module.               */
/*******************************************************/

/* Pass each window message to FilterTearOff()          */
void WINAPI __export FilterTearOff(HWND hwnd, UINT wm,
  WPARAM wParam, LPARAM lParam);

/* Call this function if you change an existing menu    */
void WINAPI __export UpdateTearOffs(HWND hwnd,
  HMENU hmnu);

/* To destroy all of a window's current tear-off menus. */
#define DestroyTearOffs(hwnd) \
  FilterTearOff(hwnd, WM_DESTROY, 0, 0)

/* These messages are sent to the menu owner.           */
/* wParam contains hwnd, LOWORD(lParam) contains        */
/* menu handle.  (+100 to at least avoid colliding      */
/* with dialog messages)                                */
#define wmTearOffCreate  (WM_USER + 100)
#define wmTearOffDestroy (WM_USER + 101)
