#include "tearutil.h"

HMENU HmnuFind(HMENU hmnuTop, HMENU hmnu, int imnu)
/*****************************************************/
/* -- Given a popup menus index within its parent,   */
/*    return its parent menu handle.                 */
/* -- hmnuTop : Current menu under consideration.    */
/* -- hmnu    : Find this popup menu's parent.       */
/* -- imnu    : Popup's index within parent.         */
/*****************************************************/
    {
    int cmnu, imnuT;
    HMENU hmnuT;

    if (NULL == hmnuTop)
        return NULL;

    /* Is the current top level menu the parent? */
    cmnu = GetMenuItemCount(hmnuTop);
    for (imnuT = 0; imnuT < cmnu; imnuT++)
        {
        if ((hmnuT = GetSubMenu(hmnuTop, imnuT)) ==
          hmnu && imnu == imnuT)
            return hmnuTop;
        if (NULL != (hmnuT = HmnuFind(hmnuT, hmnu,
          imnu)))
            return hmnuT;
        }

    return NULL;
    }

void PaintSysIcon(PTOS ptos, HDC hdc, HDC hdcMem,
        HBITMAP hbmpSys, int dyText, BITMAP bmpSys)
/*****************************************************/
/* -- Paint the small system-menu icon.              */
/* -- ptos : Get state from here.                    */
/* -- fLit : Hilite bitmap if set, else normal.      */
/*****************************************************/
    {
    HBITMAP hbmpSav;
    HBRUSH  hbrsSav;
    BOOL    fRelease = FALSE;

    if (NULL == hdc)
        {
        if (NULL == (hdc = GetDC(ptos->hwnd)))
            return; /* Give up. */
        fRelease = TRUE;
        }
    hbmpSav = SelectObject(hdcMem, hbmpSys);
    StretchBlt(hdc, 0, 0, dyText, dyText, hdcMem,
      bmpSys.bmWidth, 0, bmpSys.bmWidth,
      bmpSys.bmHeight, (ptos->grftos & ftosHilite) ?
        NOTSRCCOPY : SRCCOPY);
    if (NULL != hbmpSav)
        SelectObject(hdcMem, hbmpSav);
    hbrsSav = SelectObject(hdc,
      GetStockObject(NULL_BRUSH));
    Rectangle(hdc, 0, 0, dyText + 1, dyText + 1);
    if (NULL != hbrsSav)
        SelectObject(hdc, hbrsSav);
    if (fRelease)
        ReleaseDC(ptos->hwnd, hdc);
    }


void BeginSnap(PTOS ptos, HWND hwndPop, HWND hwndMenu,
                                             UINT wmPrivate)
/*****************************************************/
/* -- Prepare the menu to have its picture taken.    */
/* -- Unselects any selected menu item.              */
/* -- ptos      : Tear-off.                          */
/* -- hwndPop   : Window to pop menu on.             */
/* -- hwndMenu  : USER's menu window.                */
/* -- wmPrivate : Our reserved private message #     */
/*****************************************************/
    {
    RECT rect;

    /* Unselect selected menu item. */
    GetWindowRect(hwndMenu, &rect);
    PostMessage(hwndMenu, WM_LBUTTONDOWN, 0,
      *(LPARAM *)&rect.left);
    PostMessage(hwndMenu, WM_LBUTTONUP, 0,
      *(LPARAM *)&rect.left);

    /* By the time this is received, menu will have */
    /* no selection. */ 
    PostMessage(hwndPop, wmPrivate, (WPARAM)hwndMenu,
      MAKELONG(ptos, 0));
    }

void EndSnap(PTOS ptos, HWND hwndMenu, BOOL fNew,
                            int dyText, HDC hdcMem)
/*****************************************************/
/* -- Capture the popped menu's image into the tear- */
/*    off's offscreen bitmap.                        */
/* -- Resize the tear-off to the menu's size.        */
/* -- ptos     : Tear-off.                           */
/* -- hwndMenu : USER's menu window.                 */
/* -- fNew     : If set, indicates tear-off was      */
/*               newly created.  Begin drag if so.   */
/* -- dyText   : system font height.                 */
/* -- hdcMem   : Memory device context               */
/*****************************************************/
    {
    HDC     hdc;
    HBITMAP hbmpSav;
    RECT    rect;
    POINT   pt;

    GetWindowRect(hwndMenu, &rect); /* Reposition. */
    pt.x = rect.right - rect.left;  /* tear-off.   */
    pt.y = rect.bottom - rect.top;
    SetWindowPos(ptos->hwnd, HWND_TOP, rect.left,
      rect.top - dyText, pt.x, pt.y + dyText,
      SWP_SHOWWINDOW | SWP_NOACTIVATE |
        (fNew ? 0 : SWP_NOZORDER));

    /* Blow away the saved menu bits. */
    InvalidateRect(ptos->hwnd, NULL, FALSE);

    /* Cancel menu mode. */
    InflateRect(&rect, -1, -1);
    PostMessage(hwndMenu, WM_LBUTTONDOWN, 0,
      (LPARAM)(LPPOINT)&rect);
    PostMessage(hwndMenu, WM_LBUTTONUP, 0,
      (LPARAM)(LPPOINT)&rect);

    /* Get a bitmap for the tear-off.  If this stuff */
    /* fails, things will be ugly but won't blow up. */
    if (NULL != ptos->hbmp) /* Nuke old one. */
        DeleteObject(ptos->hbmp);
    if (NULL != (hdc = GetDC(hwndMenu)))
        {
        if (NULL != (ptos->hbmp =
          CreateCompatibleBitmap(hdc, pt.x, pt.y)))
            {
            hbmpSav = SelectObject(hdcMem, ptos->hbmp);
            BitBlt(hdcMem, 0, 0, pt.x, pt.y, hdc, 0, 0,
              SRCCOPY); /* Capture bits. */
            if (NULL != hbmpSav)
                SelectObject(hdcMem, hbmpSav);
            }
        ReleaseDC(hwndMenu, hdc);
        }

    if (fNew && GetKeyState(VK_RBUTTON) < 0)
        { /* Force tear-off into drag mode. */
        GetCursorPos(&pt);
        ScreenToClient(ptos->hwnd, &pt);
        PostMessage(ptos->hwnd, WM_RBUTTONDOWN, 0,
          *(LPARAM *)&pt);
        }
    }


void DrawGhost(PTOS ptos)
/*****************************************************/
/* -- Invert the ghost frame at its current drag     */
/*    location.                                      */
/*****************************************************/
    {
    HBRUSH hbrsSav;
    RECT   rect;
    int    dxBdr = 3 * GetSystemMetrics(SM_CXBORDER);
    int    dyBdr = 3 * GetSystemMetrics(SM_CYBORDER);
    int    dyT;
    POINT  pt;
    HDC    hdc;

    if (NULL == (hdc = GetDC(NULL)))
        return;
    ptos->grftos ^= ftosOn;
    hbrsSav = SelectObject(hdc,
      GetStockObject(DKGRAY_BRUSH));
    GetClientRect(ptos->hwnd, &rect);
    pt.x = ptos->pt.x - ptos->dpt.x;
    pt.y = ptos->pt.y - ptos->dpt.y;
    PatBlt(hdc, pt.x, pt.y, rect.right, dyBdr,
      PATINVERT);
    PatBlt(hdc, pt.x, pt.y + rect.bottom - dyBdr,
      rect.right, dyBdr, PATINVERT);
    PatBlt(hdc, pt.x, pt.y += dyBdr, dxBdr,
      dyT = rect.bottom - 2 * dyBdr, PATINVERT);
    PatBlt(hdc, pt.x + rect.right - dxBdr, pt.y,
      dxBdr, dyT, PATINVERT);
    SelectObject(hdc, hbrsSav);
    ReleaseDC(NULL, hdc);
    }
