#define OEMRESOURCE /* To get OBM_ bitmaps. */
#include <windows.h>
#include <windowsx.h>
#include "tearoff.h"


enum /* Flags, Tear-Off State. */
    {
    ftosNil      = 0x00, /* Nothing special. */
    ftosTearMenu = 0x01, /* Tear-off menu active. */
    ftosActive   = 0x02, /* Tear-off is active. */
    ftosHilite   = 0x04, /* System icon is hilited. */
    ftosDrag     = 0x08, /* Tear-off being dragged. */
    ftosOn       = 0x10  /* Ghost is XOR'ed on. */
    };

typedef struct TOS  /* Tear-Off State */
    {
    struct TOS *ptosNext;  /* Next in list. */
    HMENU       hmnu;      /* Popup menu handle. */
    HBITMAP     hbmp;      /* Offscreen bitmap. */
    HWND        hwnd;      /* Tear-off window. */
    HWND        hwndOwner; /* Menu owner window. */
    enum FTOS   grftos;    /* Menu Data State. */
    POINT       pt;        /* Ghost drag location. */
    POINT       dpt;       /* Drag offset. */
    char        szTitle[1];/* For title bar. */
    } TOS, *PTOS;

LRESULT CALLBACK __export LwSubclassProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK __export LwTearProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam);
int CALLBACK LibMain(HINSTANCE hinsThis, WORD ds,
  WORD cbHeap, LPSTR lpsz);
int CALLBACK __export WEP(int);

#define HwndMenuCur() FindWindow(szMenuClass, NULL)
#define FSetWndPtos(hwnd, ptos) \
  SetProp(hwnd, szMenuTag, (HANDLE)(ptos))
#define PtosAlloc(cch) \
  ((PTOS)LocalAlloc(LPTR, cch + sizeof(struct TOS)))
#define PtosRemoveWnd(hwnd) \
  ((PTOS)RemoveProp(hwnd, szMenuTag))

void BeginSnap(PTOS ptos, HWND hwndPop, HWND hwndMenu,
                                            UINT wmPrivate);
void DrawGhost(PTOS ptos);
void EndSnap(PTOS ptos, HWND hwndMenu, BOOL fNew,
                            int dyText, HDC hdcMem);
void FreeTos(PTOS ptos);
HMENU HmnuFind(HMENU hmnuTop, HMENU hmnu, int imnu);
void PaintSysIcon(PTOS ptos, HDC hdc, HDC hdcMem,
        HBITMAP hbmpSys, int dyText, BITMAP bmpSys);










