/*****************************************************/
/* filelist.c                                        */
/* -- Program tracks open files per task.            */
/* -- Called before progman so it can track          */
/*    progman's files as well.                       */
/* -- To build:                                      */
/* cc -DSTRICT filelist.c toolhelp.lib notify.lib    */
/*****************************************************/

#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include "notify.h"

#define cidList 1          /* Listbox control id. */

char    szClass[] =  "FileList";    /* Class name. */
char    szShell[] =  "Progman";

/* Internal prototypes. */
void    GetSzPdb(LPSTR, WORD);
void    FillList(HWND);

/* Exported prototypes. */
LRESULT CALLBACK __export
        LwWndProc(HWND, UINT, WPARAM, LPARAM);

int PASCAL
WinMain(HINSTANCE hins, HINSTANCE hinsPrev, LPSTR lpsz,
  int wShow)
/*****************************************************/
/* -- Entry point.                                   */
/*****************************************************/
    {
    HWND    hwnd;
    MSG     msg;

    if (hinsPrev == NULL)
        {
        WNDCLASS    wcs;

        wcs.style = CS_HREDRAW | CS_VREDRAW;
        wcs.lpfnWndProc = LwWndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hins;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = NULL;
        wcs.lpszClassName = szClass;

        if (!RegisterClass(&wcs))
            return FALSE;
        }

    msg.wParam = 0;
    if ((hwnd = CreateWindow(szClass, szClass,
      WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hins, NULL)) != NULL)
        {
        SetPostWnd(hwnd);
        if (GetModuleHandle(szShell) == NULL)
            WinExec(szShell, SW_SHOWNORMAL);
        ShowWindow(hwnd, wShow);
        while (GetMessage(&msg, NULL, 0, 0))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }
    return msg.wParam;
    }

LRESULT CALLBACK __export
LwWndProc(HWND hwnd, UINT wm, WPARAM wParam,
  LPARAM lParam)
/*****************************************************/
/* -- Main window procedure.                         */
/*****************************************************/
    {
    switch (wm)
        {
    default:
        break;

    case WM_CREATE:
        if (CreateWindow("ListBox", NULL,
          WS_CHILD | WS_VSCROLL | WS_VISIBLE, 0, 0, 0,
          0, hwnd, (HMENU)cidList,
          GetWindowInstance(hwnd), NULL) == NULL)
            return -1;
        FillList(hwnd);
        break;

    case WM_SIZE:
        SetWindowPos(GetDlgItem(hwnd, cidList), NULL,
          0, 0, LOWORD(lParam), HIWORD(lParam),
          SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER);
        break;

    case WM_DESTROY:
        PostQuitMessage(0);
        break;

    case WM_USER:
        FillList(hwnd);
        break;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }

void
FillList(HWND hwnd)
/*****************************************************/
/* -- (Re)Fill the file list with entries.           */
/*****************************************************/
    {
    long    iofi    = -1;
    OFI     ofi;

    hwnd = GetDlgItem(hwnd, cidList);
    SendMessage(hwnd, WM_SETREDRAW, FALSE, 0);
    SendMessage(hwnd, LB_RESETCONTENT, 0, 0);
    while (FNextOfi(&ofi, &iofi))
        {
        char    szBuf[256];
        char    szName[MAX_MODULE_NAME + 1];

        GetSzPdb(szName, ofi.pdb);
        wsprintf(szBuf, "%x(%s): %d %s",
          ofi.pdb, (LPSTR)szName, ofi.wHandle,
          (LPSTR)ofi.szPath);
        SendMessage(hwnd, LB_ADDSTRING, 0,
          (LPARAM)(LPSTR)szBuf);
        }
    SendMessage(hwnd, WM_SETREDRAW, TRUE, 0);
    InvalidateRect(hwnd, NULL, TRUE);
    }

void
GetSzPdb(LPSTR lpszName, WORD pdb)
/*****************************************************/
/* -- Attempt to find the module name for the given  */
/*    PDB.                                           */
/* -- Returns the string "system" if not found.      */
/*****************************************************/
    {
    TASKENTRY   tke;

    tke.dwSize = sizeof tke;
    if (TaskFirst(&tke))
        do
            if (tke.wPSPOffset == pdb)
                {
                lstrcpy(lpszName, tke.szModule);
                return;
                }
        while (TaskNext(&tke));

    lstrcpy(lpszName, "system");
    }
