;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; hook21.asm                                        ;;
;; -- Real-mode Int 21 ISR hook.                     ;;
;; -- To assemble: "masm -Mx -Zi hook21.asm;"        ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.286p

NOTIFY_TEXT SEGMENT  WORD PUBLIC 'CODE'
    ASSUME  CS: NOTIFY_TEXT
    PUBLIC  _Hook21
    PUBLIC  _Notify21

EXTRN _DoNotify21:NEAR  ; C procedure.
EXTRN _lpfnAlias:NEAR   ; Code-space variables.
EXTRN _lpfnSav:NEAR

_Hook21 PROC NEAR
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; -- Real-mode int 21h handler chains to original   ;;
;;    handler.                                       ;;
;; -- Parameters:                                    ;;
;;    -- [bp + 06h]  ; Flags.                        ;;
;; -- Locals:                                        ;;
;;    -- [bp - 02h]  : Int 21h function number.      ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    push  bp
    mov   bp, sp
    sub   sp, 02h
    mov   [bp - 02h], ax          ; Function number.

    ; Let original ISR handle interrupt.
    push  [bp + 06h]              ; Original flags.
    call  dword ptr cs:[_lpfnSav] ; Chain.
    pushf                         ; Save new flags for
    pop   [bp + 06h]              ; terminal iret.
    jc    LSkipNotify

    ; If function was one of those we are interested
    ; in, call the real-mode alias to deal with it.
    pusha       ; Save state.
    push  es
    push  cs    ; Prepare for function number scan.
    pop   es    ; es:di <-- function number array.
    mov   di, offset rgbFuncs
    mov   cx, (pbFuncsLim - rgbFuncs)   ; Array size.
    mov   al, byte ptr [bp - 01h]   ; Function number.
    repne scasb
    pop   es
    popa
    jnz   LSkipNotify   ; Was it in the array?

    push  [bp - 02h]    ; Yes, so notify client.
    call  dword ptr cs:[_lpfnAlias]
    ; Should have an "add sp, 02h" here, but why bother
    ; since we are about to remove the stack frame.

LSkipNotify:
    mov   sp, bp
    pop   bp
    iret

rgbFuncs:       ; Array of intersting function numbers.
    db    3ch   ; Create.
    db    3dh   ; Open.
    db    3eh   ; Close.
    db    45h   ; Duplicate.
    db    46h   ; Force duplicate.
    db    5ah   ; Create temp.
    db    5bh   ; Create new.
    db    6ch   ; Extended open/create.
pbFuncsLim:
_Hook21 ENDP

_Notify21 PROC NEAR
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; -- Protect mode callback from real-mode calls     ;;
;;    appropriate notification routine to deal with  ;;
;;    current interrupt 21h.                         ;;
;; -- Input:                                         ;;
;;    -- DS:SI : Prot mode address corresponding to  ;;
;;               real mode SS:SP.                    ;;
;;    -- ES:DI : Protect mode address of real-mode   ;;
;;               call structure.                     ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    push  es    ; Preserve real-mode struct selector.
    push  ds    ; Pass far pointer to real mode stack.
    push  si
    call  _DoNotify21   ; Do all the work in C.
    add   sp, 04h
    pop   es
    iret
_Notify21 ENDP

NOTIFY_TEXT ENDS
END
