// regrtest.c - regression testing for WUIMAN classes.

#include <stdio.h>
#include <string.h>
#include "wuistd.h"
#include "wuidbint.h"
#include "wuiobjdb.h"
#include "w_atom.h"
#include "w_hook.h"
#include "regrtest.h"

// Test window subclassing code
class   TTestHook : public TWindowSubclass
    {
public:
    TTestHook(HWND Window) : TWindowSubclass(Window) {}
    virtual LRESULT Handler(HWND Window, UINT Message,
                              WPARAM Param1, LPARAM Param2);
    ~TTestHook() {}
    };
LRESULT TTestHook::Handler(HWND Window,
                 UINT Message, WPARAM Param1, LPARAM Param2)
    {   MEMBERASSERT();
    if(Message == WM_GETFONT)
        MessageBeep(0);
    return TWindowSubclass::Handler(Window, Message, Param1,
                                                    Param2);
    }


int Test_THook(HWND Dialog)
    {
    // this is a lousy test (it only works the first time!).
    WNDPROC OldHandler  = (WNDPROC)GetWindowLong(Dialog, GWL_WNDPROC);
    new TTestHook(Dialog);
    ASSERT2(
        OldHandler != (WNDPROC)GetWindowLong(Dialog, GWL_WNDPROC)
        );
    SendMessage(Dialog, WM_GETFONT, 0, 0);
    return TRUE;
    }

// test simple global atom class
int    Test_TGlobalAtom()
    {
    TGlobalAtom *A, *B, *C;
    const char *Name1 = "Unusual Atom Name1";
    const char *Name2 = "Unusual Atom Name2";
    ASSERT2(
        GlobalFindAtom(Name1) == NULL
        );
    A   = new TGlobalAtom(Name1);
    ASSERT2(
        GlobalFindAtom(Name1) != NULL
        );
    B   = new TGlobalAtom(Name2);
    ASSERT2(
        GlobalFindAtom(Name2) != NULL
        );
    // make them both refer to Name2
    *A  = *B;
    ASSERT2(
        GlobalFindAtom(Name1) == NULL
        );
    delete  A;
    ASSERT2(
        GlobalFindAtom(Name2) != NULL
        );
    delete  B;
    ASSERT2(
        GlobalFindAtom(Name2) == NULL
        );
    return TRUE;
    }

int    Test_TWuiPath()
    {
    char    PathBuffer[256];
    strcpy(PathBuffer, "/Classes/TAttribute");
    TWuiPath    Path(PathBuffer);
    ASSERT2(
        strcmp(Path.AbsolutePath(), "/Classes/TAttribute") == FALSE
        );
    ASSERT2(
        strcmp(Path.RelativePath(), "/Classes/TAttribute") == FALSE
        );
    ASSERT2(
        Path.Descend() == TRUE
        );
    ASSERT2(
        strcmp(Path.AbsolutePath(), "/Classes/TAttribute") == FALSE
        );
    ASSERT2(
        strcmp(Path.RelativePath(), "Classes/TAttribute") == FALSE
        );
    TWuiName    CurrentName = Path.CurrentName();
    TWuiName    Classes = "Classes";
    ASSERT2(
        CurrentName == Classes
        );
    ASSERT2(
        Path.Ascend() == TRUE
        );
    ASSERT2(
        strcmp(Path.RelativePath(), "/Classes/TAttribute") == FALSE
        );
    return TRUE;
    }

int     Test_TWuiArgs()
    {
    TWuiArgs    Args("m_Atttribute(Compiler,P_NULL)");
    ASSERT2(
        Args.AttributeName() == ""
        );
    return TRUE;
    }

int     Test_TWuiDatabase()
    {
    TWuiDatabase    Test("killme.wui");
    ASSERT2(
        Test.WriteItem("/", "TMenu", "/,") != FALSE
        );
    char    Buffer[128];
    ASSERT2(
        Test.ReadItem("/", "TMenu", Buffer, 128) != FALSE
        );
    ASSERT2( strcmp("/,", Buffer) == 0 );
    ASSERT2(
        Test.DeleteItem("/", "TMenu") != FALSE
        );
    ASSERT2(
        Test.ReadItem("/", "TMenu", Buffer, 128) == -1
        );
    ASSERT2(
        Test.DeletePath("/") != FALSE
        );
    return TRUE;
    }


void    Test(HWND Dialog, char *ClassName, HWND ResultWindow)
    {
    int     Result;
    char    Message[128];
    sprintf(Message, "Testing class '%s'", ClassName);
    SetWindowText(ResultWindow, Message);
    if(!strcmp(ClassName, "TWuiDatabase"))
        Result = Test_TWuiDatabase();
    else if(!strcmp(ClassName, "TWuiPath"))
        Result = Test_TWuiPath();
    else if(!strcmp(ClassName, "TGlobalAtom"))
        Result = Test_TGlobalAtom();
    else if(!strcmp(ClassName, "THook"))
        Result = Test_THook(Dialog);
    else if(!strcmp(ClassName, "TWuiArgs"))
        Result = Test_TWuiArgs();
    sprintf(Message, "%s: class '%s'", Result ?
                          "SUCCESS" : "FAILURE", ClassName);
    SetWindowText(ResultWindow, Message);
    }

BOOL CALLBACK _export DlgProc(HWND, UINT, WPARAM, LPARAM);

HINSTANCE   ThisInstance;

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE Me, HINSTANCE Previous,
		     LPSTR lpszCmdLine, int nCmdShow)
    {
    ThisInstance    = Me;
    DialogBox(Me, "Main", NULL, (DLGPROC)DlgProc);
    return 0;
    }

#define SEND(Control, Message, Param1, Param2) \
SendDlgItemMessage(Dialog, Control, Message, Param1, Param2)

#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL CALLBACK _export DlgProc(HWND Dialog, UINT Message,
                             WPARAM Param1, LPARAM Param2)
    {

    if(Message == WM_INITDIALOG)
        {
        SEND(ID_CLASS_COMBO, CB_ADDSTRING, 0, (LPARAM)(LPSTR)"<all>");
        SEND(ID_CLASS_COMBO, CB_ADDSTRING, 0, (LPARAM)(LPSTR)"TGlobalAtom");
        SEND(ID_CLASS_COMBO, CB_ADDSTRING, 0, (LPARAM)(LPSTR)"THook");
        SEND(ID_CLASS_COMBO, CB_ADDSTRING, 0, (LPARAM)(LPSTR)"TWuiDatabase");
        SEND(ID_CLASS_COMBO, CB_ADDSTRING, 0, (LPARAM)(LPSTR)"TWuiPath");
        SEND(ID_CLASS_COMBO, CB_ADDSTRING, 0, (LPARAM)(LPSTR)"TWuiArgs");
        SEND(ID_CLASS_COMBO, CB_SETCURSEL, 0, 0);
        }
    else if(Message == WM_COMMAND)
        if(Param1 == IDOK || Param1 == IDCANCEL) {
            EndDialog(Dialog, 0);
            return TRUE;
            }
        else if(Param1 == ID_TEST_BUTTON)
            {
            char    ClassName[128];
            SEND(ID_CLASS_COMBO, WM_GETTEXT, 127, (LPARAM)(LPSTR)ClassName);
            Test(Dialog, ClassName, GetDlgItem(Dialog, ID_RESULT_STATIC));
            }
    return FALSE;
    }

