#include <string.h>
#include "wuistd.h"
#include "wuimanhk.h"

LRESULT CALLBACK _export WUIMAN_WinProc(HWND Window,
               UINT Message, WPARAM Command, LPARAM Param2);


class   TWindowHook
    {
public:
    TWindowHook(HWND Window);
   ~TWindowHook();
    HWND    Window() { return Window_; }
    long    Dispatch(UINT Message, WPARAM Param1, LPARAM Param2);
    int     AddMessage(AWuiObject *Receiver, UINT Message,
                                            WPARAM Command);
    int     DeleteMessage(UINT Message, WPARAM Command);
private:
    // I don't expect copying or assigning:
    TWindowHook(const TWindowHook &Dummy)
        { ASSERT(NEVER_COPY_CONSTRUCTED); }
    const TWindowHook &operator=(const TWindowHook &Dummy)
        { ASSERT(NEVER_ASSIGNED_TO); return Dummy; }

    int         FindMessage(UINT Message, WPARAM Command);
    HWND        Window_;
    WNDPROC     PreviousCallback_;
    int         NMessages_;
    int         ArraySize_;
    UINT       *Messages_;
    WPARAM     *Commands_;
    AWuiObject **Receivers_;
    };


TWindowHook::TWindowHook(HWND Window)
    :   Window_(Window), NMessages_(0)
    {   MEMBERASSERT();
    ArraySize_  = 10;
    Messages_   = new UINT[ArraySize_];
    Commands_   = new WPARAM[ArraySize_];
    Receivers_  = new AWuiObject *[ArraySize_];
    PreviousCallback_   = (WNDPROC)SetWindowLong(Window,
                         GWL_WNDPROC, (long)WUIMAN_WinProc);
    }

TWindowHook::~TWindowHook()
    {   MEMBERASSERT();
    delete[] Messages_;
    delete[] Commands_;
    delete[] Receivers_;
    }

// FindMessage - locate specific message hooked for this window.
int TWindowHook::FindMessage(UINT Message, WPARAM Command)
    {   MEMBERASSERT();
    int     IsCommand = (Message == WM_SYSCOMMAND
                        || Message == WM_COMMAND);
    if((Message == WM_SYSCOMMAND) && ((Command & 0xF000) == 0xF000))
        Command &= 0xFFF0;
    for(int iMessage=0; iMessage < NMessages_; ++iMessage)
        if(Messages_[iMessage] == Message)
            if(!IsCommand)
                return iMessage;
            else
                if(Command == Commands_[iMessage])
                    return iMessage;
    return -1;
    }

// Dispatch - forward message to receiver, else to previous
//            window callback procedure.
long    TWindowHook::Dispatch(UINT Message, WPARAM Command, LPARAM Param2)
    {   MEMBERASSERT();
    int     Found = FindMessage(Message, Command);
    if(Found == -1)
        return CallWindowProc(PreviousCallback_, Window_,
                                  Message, Command, Param2);
    else
        return Receivers_[Found]->WindowMessage(Window_,
               Message, Command, Param2, PreviousCallback_);
    }

int     TWindowHook::AddMessage(AWuiObject *Receiver,
                               UINT Message, WPARAM Command)
    {   MEMBERASSERT();
    ASSERT(NMessages_ < ArraySize_);
    if(FindMessage(Message, Command) != -1)
        return FALSE;
    Messages_[NMessages_]   = Message;
    Commands_[NMessages_]   = Command;
    Receivers_[NMessages_]  = Receiver;
    ++NMessages_;
    return TRUE;
    }

int     TWindowHook::DeleteMessage(UINT Message, WPARAM Command)
    {   MEMBERASSERT();
    int Found = FindMessage(Message, Command);
    if(Found == -1)
        return FALSE;
    else
        {
        if(Found < NMessages_-1)
            {
            memmove(Messages_+Found, Messages_+Found+1,
                     sizeof(UINT) * (NMessages_-(Found+1)));
            memmove(Commands_+Found, Commands_+Found+1,
                   sizeof(WPARAM) * (NMessages_-(Found+1)));
            memmove(Receivers_+Found, Receivers_+Found+1,
              sizeof(AWuiObject *) * (NMessages_-(Found+1)));
            }
        --NMessages_;
        return TRUE;
        }
    }

// use very simple table for hooking windows.
static  TWindowHook *Windows[100];
static  int         NWindows = 0;

// WUIMAN_Hook - intercept a specific message for a specific window.
int     WUIMAN_Hook(HWND Window, UINT Message,
                        WPARAM Command, AWuiObject *Receiver)
    {
    for(int iWindow = 0; iWindow < NWindows; ++iWindow)
        if(Windows[iWindow]->Window() == Window)
            break;
    if(iWindow >= NWindows) // if this window not already hooked
        {
        Windows[iWindow] = new TWindowHook(Window);
        ++NWindows;
        }
    return Windows[iWindow]->AddMessage(Receiver, Message, Command);
    }


// WUIMAN_WinProc - this function is receives all window messages
//                  for all hooked windows.
LRESULT CALLBACK _export WUIMAN_WinProc(HWND Window,
               UINT Message, WPARAM Command, LPARAM Param2)
    {
    for(int iWindow = 0; iWindow < NWindows; ++iWindow)
        if(Windows[iWindow]->Window() == Window)
            {
            LRESULT Result = Windows[iWindow]->Dispatch(Message,
                                           Command, Param2);
            if(Message == WM_NCDESTROY)
                {
                delete Windows[iWindow];
                --NWindows;
                if(iWindow < NWindows)
                    memmove(Windows+iWindow,
                       Windows+iWindow+1, sizeof(Windows[0])
                                      * (NWindows-iWindow));
                }
            return Result;
            }
    return 0;
    }

// WUIMAN_Unhook - remove specific message hook.
int     WUIMAN_Unhook(HWND Window, UINT Message,
                  WPARAM Command, AWuiObject * /*Receiver*/)
    {
    // Note: "Receiver" is not used because this implementation
    //       does not let multiple AWuiObjects hook the same
    //       message for the same window.

    for(int iWindow = 0; iWindow < NWindows; ++iWindow)
        if(Windows[iWindow]->Window() == Window)
            Windows[iWindow]->DeleteMessage(Message, Command);
    return 1;
    }

