// wuiobjdb.h - Definitions for WUIman OBJect DataBase.
// Copyright (c) 1993 by Ron Burk

#ifndef WUIOBJDB_H
#define WUIOBJDB_H

#if !(defined(_INC_WINDOWS) || defined(__WINDOWS_H))
    #include <windows.h>
#endif
#include "wuistd.h"
#include "wuiname.h"
#include "wuiargs.h"
#include "wuilist.h"

class   TWuiDatabase;
class   AWuiObject;

// TWuiObjects - a list of type TWuiObject
class   TWuiObjects : public TWuiGenericList
    {
public:
    TWuiObjects(int Size=0);
    void       *Insert(AWuiObject *NewObject, const TWuiName To);
    void       *Insert(AWuiObject *NewObject, int Position=-1);
    AWuiObject *Get(const TWuiName Which);
    AWuiObject *Get(int Position);
    AWuiObject *Remove(const TWuiName Which);
    AWuiObject *Remove(int Position = -1);
    int         NObjects();
private:
    int         Find(const TWuiName Which);
    };

inline
AWuiObject *TWuiObjects::Remove(int Position)
    {   MEMBERASSERT();
    return (AWuiObject *)TWuiGenericList::Remove(Position);
    }
inline
AWuiObject *TWuiObjects::Get(int Position)
    {   MEMBERASSERT();
    return (AWuiObject *)TWuiGenericList::Get(Position);
    }
inline
int     TWuiObjects::NObjects()
    {   MEMBERASSERT();
    return TWuiGenericList::NElements();
    }

// TWuiPath - Class to handle absolute and relative paths.
// Note: this version is unsafe -- Push() may write past
// end of string.
class   TWuiPath
    {
public:
    TWuiPath(char *TotalPath);
    int         Descend();
    int         Ascend();
    int         Push(const char *SubPath);
    int         Pop();
    TWuiName    CurrentName();
    const char *AbsolutePath();
    const char *RelativePath();
private:
    char *AbsolutePath_;
    char *RelativePath_;
    };

inline
const char *TWuiPath::AbsolutePath()
    {   MEMBERASSERT();
    return AbsolutePath_;
    }
inline
const char *TWuiPath::RelativePath()
    {   MEMBERASSERT();
    return RelativePath_;
    }

class   AWuiObject
    {
public:
    AWuiObject(const TWuiName ObjectName,
                                     const char *Value = 0);
    virtual              ~AWuiObject();
    virtual AWuiObject   *New(const TWuiName Name) = 0;
    virtual long          Initialize(const char *Value) = 0;
    virtual TWuiObjects  *Children();
    virtual TWuiObjects  *Attributes();
    virtual long          Get(TWuiPath Path, TWuiArgs *Args,
                                      AWuiObject *Attribute,
                            char *Buffer, size_t MaxLength);
    virtual long          Set(TWuiPath Path, TWuiArgs *Args,
                                      AWuiObject *Attribute,
                                         const char *Buffer);
    void                  Trace(const char *Function,
                              TWuiPath Path, TWuiArgs *Args);

    TWuiName              Name();
    virtual TWuiName      ClassName() = 0;
    virtual TWuiName      ParentClassName() = 0;
    static  AWuiObject   *Root;
    static  TWuiDatabase *Database;
    static  TWuiObjects  *MasterObjects;
    static  int           TraceFlag;
private:
    long                  InitialLoad(char *Path);
    TWuiName              Name_;
    };

inline
TWuiName AWuiObject::Name()
    {   
    return Name_;
    }

class   TWuiRegister
    {
public:
    TWuiRegister(AWuiObject *MasterCopy);
    };

////////////
// 11/06/93
// TWuiContainer - An AWuiObject that supports children and attributes.
class   TWuiContainer : public AWuiObject
    {
public:
    TWuiContainer(const TWuiName ObjectName);
    virtual AWuiObject   *New(const TWuiName Name);
    virtual long          Initialize(const char *Value);
    virtual TWuiName      ClassName();
    virtual TWuiName      ParentClassName();
    virtual TWuiObjects  *Children();
    virtual TWuiObjects  *Attributes();
private:
    TWuiObjects          *Children_;
    TWuiObjects          *Attributes_;
    };

class   TWuiRoot : public TWuiContainer
    {
public:
    TWuiRoot(const TWuiName ObjectName);
    virtual long        Initialize(const char *Value);
    virtual TWuiName    ClassName();
    virtual TWuiName    ParentClassName();
    };

class   TWuiBaseAttribute : public AWuiObject
    {
public:
    TWuiBaseAttribute(const TWuiName ObjectName, int Flags);
    // called by derived class to handle persistance and inheritance
    // * turn off P_NULL bit
    // * if P_PERSISTANT bit is on, save new value
    // * if P_INHERITABLE, transmit new value to children
    // 
    virtual long          Set(TWuiPath Path, TWuiArgs *Args,
                                      AWuiObject *Attribute,
                                         const char *Buffer);
    // Derived class need not define a get function,
    // only an AttributeValue()
    virtual long          Get(TWuiPath Path, TWuiArgs *Args,
                                      AWuiObject *Attribute,
                            char *Buffer, size_t MaxLength);
    virtual long          Initialize(const char *Value);
    // Note: can change any bit except P_INDIRECT
    int     SetFlags(int Bits = -1);
    int     ClearFlags(int Bits = -1);
    int     GetFlags(int Bits = -1);
    enum FLAGS
        {
        P_NULL          = 0x01,     P_READONLY      = 0x02,
        P_PERSISTANT    = 0x04,     P_INDIRECT      = 0x08,
        P_INHERITED     = 0x10,     P_INHERITABLE   = 0x20,
        };
protected:
    virtual long AttributeValue(char **Buffer) = 0;
private:
    char    Flags;
    };


class   TWuiMethod : public TWuiBaseAttribute
    {
public:
    TWuiMethod(const TWuiName ObjectName);
    virtual AWuiObject *New(const TWuiName ObjectName);
    virtual TWuiName    ClassName();
    virtual TWuiName    ParentClassName();
protected:
    virtual long AttributeValue(char **Buffer);
    };


class TWuiIntAttribute : public TWuiBaseAttribute
    {
public:
    TWuiIntAttribute(const TWuiName Name);
    TWuiIntAttribute(const TWuiName Name, int *Address);
    AWuiObject *New(const TWuiName Name);
    virtual long        Initialize(const char *Value);
    virtual TWuiName    ClassName();
    virtual TWuiName    ParentClassName();
protected:
    virtual long AttributeValue(char **Buffer);
private:
    union
        {
        int     IntValue;
        int    *IntAddress;
        };
    };


#if 0

// TWuiAttribute - Base class for attributes (properties and events).
class   TWuiAttribute : public AWuiObject
    {
public:
    TWuiAttribute(const TWuiName ObjectName, char Flags, char Type);
    TWuiAttribute(const TWuiName ObjectName, int Value,
                          int Flags=P_PERSISTANT|P_INHERITED
                                     |P_INHERITABLE|P_NULL);
    TWuiAttribute(const TWuiName ObjectName, int *Address,
                          int Flags=P_PERSISTANT|P_INHERITED
                          |P_INHERITABLE|P_NULL|P_INDIRECT);
    TWuiAttribute(const TWuiName ObjectName, long Value,
                          int Flags=P_PERSISTANT|P_INHERITED
                                     |P_INHERITABLE|P_NULL);
    TWuiAttribute(const TWuiName ObjectName, long *Value,
                          int Flags=P_PERSISTANT|P_INHERITED
                          |P_INHERITABLE|P_NULL|P_INDIRECT);
    TWuiAttribute(const TWuiName ObjectName, float Value,
                          int Flags=P_PERSISTANT|P_INHERITED
                                     |P_INHERITABLE|P_NULL);
    TWuiAttribute(const TWuiName ObjectName, float *Value,
                          int Flags=P_PERSISTANT|P_INHERITED
                          |P_INHERITABLE|P_NULL|P_INDIRECT);
    TWuiAttribute(const TWuiName ObjectName, const char *Value,
                          int Flags=P_PERSISTANT|P_INHERITED
                                     |P_INHERITABLE|P_NULL);
    TWuiAttribute(const TWuiName ObjectName, char **Value,
                          int Flags=P_PERSISTANT|P_INHERITED
                          |P_INHERITABLE|P_NULL|P_INDIRECT);
//    virtual AWuiObject   *New(const TWuiName Name);
    virtual long          Get(TWuiPath Path, TWuiArgs *Args,
                                      AWuiObject *Attribute,
                            char *Buffer, size_t MaxLength);
    virtual long          Set(TWuiPath Path, TWuiArgs *Args,
                                      AWuiObject *Attribute,
                                        const char *Buffer);
    int                   IsInheritable();
    int                   IsNull();
    enum FLAGS
        {
        P_NULL          = 0x01,     P_READONLY      = 0x02,
        P_PERSISTANT    = 0x04,     P_INDIRECT      = 0x08,
        P_INHERITED     = 0x10,     P_INHERITABLE   = 0x20,
        };
protected:
    int     Initialize(const char *Value);
private:
    long            Set(const char *Value);
    char            Flags;
    enum TYPES
        {
        T_INT, T_LONG, T_FLOAT, T_DOUBLE, T_STRING
        };
    char        Type;
    union
        {
        int     IntValue;
        int    *IntAddress;
        long    LongValue;
        long   *LongAddress;
        float   FloatValue;
        float  *FloatAddress;
        double  DoubleValue;
        double *DoubleAddress;
        char   *StringValue;
        char  **StringAddress;
        };
    };

#endif

class TWuiStringAttribute : public TWuiBaseAttribute
    {
public:
    TWuiStringAttribute(const TWuiName Name);
    TWuiStringAttribute(const TWuiName Name,
                 char *InitialValue, int InitialFlags=P_NULL
                   |P_INHERITED|P_INHERITABLE|P_PERSISTANT);
    TWuiStringAttribute(const TWuiName Name,
               char **InitialAddress, int InitialFlags=P_NULL
         |P_INHERITED|P_INHERITABLE|P_PERSISTANT|P_INDIRECT);

   ~TWuiStringAttribute();
    AWuiObject *New(const TWuiName Name);
    virtual long    Initialize(const char *Value);
    virtual TWuiName ClassName();
    virtual TWuiName      ParentClassName();
protected:
    virtual long AttributeValue(char **Buffer);
private:
    union
        {
        char   *StringValue;
        char  **StringAddress;
        };
    };






#if 0
inline
const char *TWuiAttribute::Value()
    {   MEMBERASSERT();
    return Value_;
    }

class   TWuiPersistantAttribute : public TWuiAttribute
    {
public:
    TWuiPersistantAttribute(const TWuiName ObjectName,
                                         const char *Value);
//    virtual AWuiObject   *Clone();
    virtual AWuiObject   *New(const TWuiName Name,
                                       const char *Value=0);
    virtual long          Set(TWuiPath Path, TWuiArgs *Args,
                                      AWuiObject *Attribute,
                                        const char *Buffer);
    };

#endif


#endif
