// wuistd.h - all WUIMAN source files include this header.
// Copyright (c) 1993 by Ron Burk

#ifndef WUISTD_H
#define WUISTD_H

#include <assert.h>
#include <stdlib.h>

extern "C" {
void _far * _far _pascal GlobalLock(const void _near *);
};

// I prefer uppercase for this
#define ASSERT(e)  ((e)?(void) 0:((void)GlobalLock(0),assert(e)))


// ASSERT2 - when the asserted expression has required
//           side-effects.

#ifdef  NDEBUG
    #define ASSERT2(exp)    (exp)
#else
    #define ASSERT2(exp)    ASSERT(exp)
#endif

#define MEMBERASSERT()     (ASSERT(this != 0))

// StringClone - allocate space for and duplicate a string.
char    *StringClone(const char *Input);

// TCharBuffer - for heap character buffers too big for stack
class TCharBuffer
    {
public:
    TCharBuffer(size_t BufferSize);
    TCharBuffer(const TCharBuffer &Other);
    const TCharBuffer &operator=(const TCharBuffer &Other);
   ~TCharBuffer();
    operator char *();
//    operator char *() const;
    size_t  Size() const;
private:
    char    *Buffer;
    size_t  Size_;
    };

inline
TCharBuffer::operator char *()
    {   MEMBERASSERT();
    return Buffer;
    }

#if 0
inline
TCharBuffer::operator char *() const
    {   MEMBERASSERT();
    return Buffer;
    }
#endif

inline
size_t  TCharBuffer::Size() const
    {   MEMBERASSERT();
    return Size_;
    }


// provide separate debugging output
void    DebugPrintf(int Flag, const char *Format, ...);
void    DebugPrintf(const char *Format, ...);

#define DEBUG_TRACE DebugPrintf(0x0000, \
    "File '%s', line %d", __FILE__, __LINE__), DebugPrintf
#define DEBUG_WARNING DebugPrintf(0x4000, \
    "File '%s', line %d", __FILE__, __LINE__), DebugPrintf
#define DEBUG_ERROR DebugPrintf(0x8000, \
    "File '%s', line %d", __FILE__, __LINE__), DebugPrintf
#define DEBUG_FATAL DebugPrintf(0xC000, \
    "File '%s', line %d", __FILE__, __LINE__), DebugPrintf

#endif
