/*
TO-DO:

- double click does not redraw box correctly.
- Change box to opened or closed, based on double-click.

Done:

- Don't draw box if no children.
- Get damn focus rectangle positioned right!

 */

#include "w_uimain.h"


long    WuiGet(size_t LineNumber, const char *FileName,
                 const char *Path, const char *Attribute,
                          char *Result, size_t MaxLength)
    {
    long    Status = WUIMAN_Get(Path, Attribute, Result, MaxLength);
    if(Status < WUIMAN_ERRORS)
        {
        char Location[256];
        sprintf(Location, "Line %d, File '%s'", LineNumber, FileName);
        int Answer = MessageBox(NULL, WUIMAN_LastError, Location, MB_OKCANCEL);
        if(Answer == IDCANCEL)
            FatalAppExit(0, "I hope this does not crash!");
        }
    return Status;
    }

static
long    WuiSet(const char *Path, const char *Attribute, const char *Value)
    {
    return 0;
    }


HBITMAP ObjectClosedBitmap;
HBITMAP ObjectOpenBitmap;


// Create graphics with metafiles

HMETAFILE     CreateObjectBox(int /*Width*/, int /*Height*/,
                                              int OpenedBox)
    {
    HBRUSH GrayBrush = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
    HBRUSH WhiteBrush = (HBRUSH)GetStockObject(WHITE_BRUSH);
    HPEN    BlackPen    = (HPEN)GetStockObject(BLACK_PEN);
    static POINT BoxLeft [] =
        { {1,4}, {1,10}, {4,13}, {4, 7} };
    static POINT BoxFront [] =
        { {4,7}, {4,13}, {18,13}, {18,7} };
    static POINT BoxInside [] =
        { {4,7}, {18,7}, {15,4}, {1,4} };
    static POINT BoxLid [] =
        { {1,4}, {15,4}, {18,1}, {4,1} };

    #define NCLOSEDPOINTS \
                    (sizeof(ClosedBoxOutline)/sizeof(POINT))
    HDC MetaFile = CreateMetaFile(NULL);
    SelectObject(MetaFile, GrayBrush);
    SelectObject(MetaFile, BlackPen);
    Polygon(MetaFile, BoxLeft, 4);
    Polygon(MetaFile, BoxFront, 4);
    if(OpenedBox)
        SelectObject(MetaFile, WhiteBrush);
    Polygon(MetaFile, BoxInside, 4);
    if(OpenedBox)
        {
        SelectObject(MetaFile, GrayBrush);
        Polygon(MetaFile, BoxLid, 4);
        }
    return CloseMetaFile(MetaFile);
    }


const int CUSTOMHEIGHT = 15;

int NKids(CustomList *Entry)
    {
    return (int)WUIMAN_Get(Entry->Path, "m_Child", NULL, 0);
    }

static
CustomList  *NewEntry(HWND Window, char *Path, char *Node,
                              CustomList *Parent, int Level)
    {
    CustomList  *Entry  = new CustomList;
    if(!Node || !Node[0])
        strcpy(Entry->Text, "/");
    else
        strcpy(Entry->Text, Node);
    Entry->Parent       = Parent;
    Entry->Level        = Level;
    strcpy(Entry->Path, Path);
    Entry->LastSibling  = FALSE;
    Entry->Opened       = FALSE;
    SendMessage(Window, LB_ADDSTRING, 0, (LPARAM)Entry);
    return Entry;
    }

static
int    LoadLevel(HWND Listbox, CustomList *Parent,
                                      char *Path, int Level)
    {
    long  NChildren = WUIMAN_Get(Path, "m_Child", NULL, 0);
    if(NChildren < WUIMAN_ERRORS)
        MessageBox(NULL, WUIMAN_LastError,
                               "WUIMAN:LoadLevel()", MB_OK);
    CustomList  *Entry = 0;
    for(int i = 0; i < NChildren; ++i)
        {
        char    ChildName[WUIMAN_MAXNAME];
        char    ChildNumber[WUIMAN_MAXNAME];
        sprintf(ChildNumber, "m_Child(%d)", i);
        long Status = WUIMAN_Get(Path, ChildNumber,
                                 ChildName, WUIMAN_MAXNAME);
        if(Status < WUIMAN_ERRORS)
            MessageBox(NULL, WUIMAN_LastError,
                          "WUIMAN:LoadLevel(child)", MB_OK);
        char *End = Path + strlen(Path);
        if(End[-1] != '/')
            strcat(Path, "/");
        strcat(Path, ChildName);
        Entry = NewEntry(Listbox, Path, ChildName, Parent,
                                                     Level);
        *End    = '\0';
        }
    if(Entry)
	Entry->LastSibling  = TRUE;
    return (int)NChildren;
    }

static
int     LoadDatabase(HWND Listbox)
    {
    SendMessage(Listbox, LB_RESETCONTENT, 0, 0);
    CustomList  *Root   = NewEntry(Listbox, "/", "", 0, 0);
    Root->LastSibling   = TRUE;
    char    Path[256];
    strcpy(Path, "/");
    return TRUE;
    }

inline
CustomList *ListboxEntry(HWND Listbox, int Index)
    {
    LRESULT Status = SendMessage(Listbox,
                          LB_GETITEMDATA, (WPARAM)Index, 0);
    if(Status == (LRESULT)LB_ERR)
        return NULL;
    else
        return (CustomList *)Status;
    }

inline
DWORD ListboxCurrentIndex(HWND Listbox)
    {
    return SendMessage(Listbox, LB_GETCURSEL, 0, 0);
    }

static
CustomList *CurrentEntry(HWND Dialog)
    {
    HWND    Listbox = GetDlgItem(Dialog, ID_OBJDB_LISTBOX);
    DWORD   Index;
    Index   = ListboxCurrentIndex(Listbox);
    if(Index != (DWORD)LB_ERR)
	return ListboxEntry(Listbox, int(Index));
    else
        return 0;
    }

static
void    DisplayAttributeValue(HWND Dialog, char *Path,
                                        int Combo, int Text)
    {
    char    AttributeName[WUIMAN_MAXNAME+3];
    char    Prefix;
    switch(Combo)
        {
        case    ID_PROPERTY_COMBO   : Prefix = 'p'; break;
        case    ID_METHOD_COMBO     : Prefix = 'm'; break;
        case    ID_EVENT_COMBO      : Prefix = 'e'; break;
        }
    if(Text)
        {
        AttributeName[0]    = Prefix;
        AttributeName[1]    = '_';
        GetDlgItemText(Dialog, Combo, AttributeName+2,
                                            WUIMAN_MAXNAME);
        TCharBuffer Value(1024*4);
        long  Status = WUIMAN_Get(Path, AttributeName,
                                             Value, 1024*4);
        if(Status < WUIMAN_ERRORS)
            MessageBox(NULL, WUIMAN_LastError,
                   "WUIMAN (DisplayAttributeValue)", MB_OK);
        SetDlgItemText(Dialog, Text, Value);
        }
    }

static
void    DisplayAttributes(HWND Dialog, char *Path)
    {
    int     Boxes[3] = 
        {ID_PROPERTY_COMBO,ID_METHOD_COMBO,ID_EVENT_COMBO};
    int i;
    for(i = 0; i < 3; ++i)
        SendDlgItemMessage(Dialog, Boxes[i],
                                     CB_RESETCONTENT, 0, 0);
    long  NChildren = WUIMAN_Get(Path, "m_Attribute",
                                                   NULL, 0);
    if(NChildren < WUIMAN_ERRORS)
        MessageBox(NULL, WUIMAN_LastError,
                       "WUIMAN:DisplayAttributes", MB_OK);
    for(i = 0; i < NChildren; ++i)
        {
        char    ChildName[WUIMAN_MAXNAME];
        char    ChildNumber[WUIMAN_MAXNAME];
        sprintf(ChildNumber, "m_Attribute(%d)", i);
        long Status = WUIMAN_Get(Path, ChildNumber,
                                 ChildName, WUIMAN_MAXNAME);
        if(Status < WUIMAN_ERRORS)
            {
            MessageBox(NULL, WUIMAN_LastError,
                         "WUIMAN:DisplayAttributes", MB_OK);
            continue;
            }
        int j;
        switch(ChildName[0])
            {
            case    'p' : j = 0; break;
            case    'm' : j = 1; break;
            case    'e' : j = 2; break;
            default:      j = 0;
            }
        long Err = SendDlgItemMessage(Dialog, Boxes[j],
            CB_ADDSTRING, 0, (LPARAM)(LPCSTR)(ChildName+2));
        if(Err < 0)
            DEBUG_ERROR("ERROR RETURN FROM CB_ADDSTRING");
        }
    char ClassName[WUIMAN_MAXNAME];
    long Status = WUIMAN_Get(Path, "m_Class()", ClassName,
                                            WUIMAN_MAXNAME);
    if(Status < WUIMAN_ERRORS)
        MessageBox(NULL, WUIMAN_LastError,
                         "WUIMAN:DisplayAttributes", MB_OK);
    else
        SetDlgItemText(Dialog, ID_CLASS_NAME, ClassName);

    Status = WUIMAN_Get(Path, "m_ParentClass()", ClassName,
                                            WUIMAN_MAXNAME);
    if(Status < WUIMAN_ERRORS)
        MessageBox(NULL, WUIMAN_LastError,
                         "WUIMAN:DisplayAttributes", MB_OK);
    else
        SetDlgItemText(Dialog, ID_PARENT_NAME, ClassName);
    for(i = 0; i < 3; ++i)
        SendDlgItemMessage(Dialog, Boxes[i], CB_SETCURSEL,
                                                      0, 0);
    }

static
void    SetPath(CustomList *Entry, char *Path)
    {
    if(Entry->Parent)
        SetPath(Entry->Parent, Path);
    if(strlen(Path) > 1)
        strcat(Path, "/");
    strcat(Path, Entry->Text);
    }

static
void    ObjectSelected(HWND Dialog)
    {
    CustomList  *Entry = CurrentEntry(Dialog);
    if(!Entry)
        return;
    if(!strcmp(Entry->Text, "/"))
        {
        EnableWindow(GetDlgItem(Dialog, ID_INSERT_BUTTON), 0);
        EnableWindow(GetDlgItem(Dialog, ID_APPEND_BUTTON), 0);
        }
    else
        {
        EnableWindow(GetDlgItem(Dialog, ID_INSERT_BUTTON), 1);
        EnableWindow(GetDlgItem(Dialog, ID_APPEND_BUTTON), 1);
        }
    EnableWindow(GetDlgItem(Dialog, ID_NEWCHILD_BUTTON), 1);
    SendDlgItemMessage(Dialog, ID_PROPERTY_COMBO, CB_RESETCONTENT, 0, 0);
    SendDlgItemMessage(Dialog, ID_EVENT_COMBO, CB_RESETCONTENT, 0, 0);

    SetDlgItemText(Dialog, ID_OBJECT_NAME, Entry->Path);
#if 0
    char    Name[32];
    Entry->Object->Class().GetName(Name);
    SetDlgItemText(Dialog, ID_CLASS_NAME, Name);
#endif

    DisplayAttributes(Dialog, Entry->Path);
    }

#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL CALLBACK ObjectListbox(HWND Dialog, UINT Message,
                             WPARAM Param1, LPARAM Param2)
    {
    switch(Message)
        {
        case    WM_MEASUREITEM  :
            {
            MEASUREITEMSTRUCT *Measure = (MEASUREITEMSTRUCT *)Param2;
            Measure->itemWidth  = 30;
            Measure->itemHeight = CUSTOMHEIGHT + 2;
            return TRUE;
            }
        case    WM_DRAWITEM :
            {

const int LEFTOFBOX         = 1;
const int RIGHTOFBOX        = 2;
const int BOXWIDTH          = 20;
const int HORIZONTALSTUB    = 9;
const int HORIZONTALINDENT  = (LEFTOFBOX+RIGHTOFBOX+BOXWIDTH);
const int BOXLESSINDENT     = 8;

            const DRAWITEMSTRUCT *Draw = (const DRAWITEMSTRUCT *)Param2;
            CustomList *Item    = (CustomList *)Draw->itemData;
            HFONT   Font = (HFONT)GetStockObject(ANSI_FIXED_FONT);
            SelectObject(Draw->hDC, Font);
            RECT TextRect = Draw->rcItem;
            InflateRect(&TextRect, -1, -1);
            int TextWidth = LOWORD(GetTextExtent(Draw->hDC,
                           Item->Text, strlen(Item->Text)));
            int HasKids = NKids(Item) > 0;

            TextRect.left += (Item->Level * HORIZONTALINDENT);
            if(Item->Level)
                TextRect.left -= (HORIZONTALINDENT/2);
            TextRect.left += HasKids?BOXWIDTH+RIGHTOFBOX:BOXLESSINDENT;
            if(Item->Level)
                TextRect.left += HORIZONTALSTUB;
            TextRect.right  = TextRect.left + TextWidth;

            RECT    FocusRect = TextRect;
//            InflateRect(&FocusRect, 1, 1);
            
            if(Draw->itemAction & (ODA_DRAWENTIRE | ODA_SELECT))
                {
                if(Draw->itemState & ODS_SELECTED)
                    {
                    SetBkColor(Draw->hDC, RGB(198,198,198));
                    SetTextColor(Draw->hDC, RGB(255,255,255));
                    }
                else
                    {
                    SetBkColor(Draw->hDC, RGB(198,198,198));
                    SetTextColor(Draw->hDC, RGB(0,0,0));
                    }
                ExtTextOut(Draw->hDC, 0, 0, ETO_OPAQUE,
                              &TextRect, NULL, 0, NULL);
//                SetTextAlign(Draw->hDC, TA_UPDATECP);
                int  Vertical   = Draw->rcItem.top;
                int  Horizontal = 0;
                HPEN ThickPen  = CreatePen(PS_SOLID, 2, RGB(0,0,0));
                SelectObject(Draw->hDC, ThickPen);
                for(int i = 0; i < Item->Level; ++i)
                    {
                    CustomList *Parent = Item;
                    for(int j=i; j < Item->Level; ++j)
                        Parent  = Parent->Parent;
                    if(!Parent->LastSibling)
                        {
                        MoveTo(Draw->hDC, Horizontal, Vertical);
                        LineTo(Draw->hDC, Horizontal, Vertical+CUSTOMHEIGHT);
                        }
                    Horizontal  += i?HORIZONTALINDENT:HORIZONTALINDENT/2;
                    }
                if(Item->Level > 0)
                    {
                    MoveTo(Draw->hDC, Horizontal, Vertical);
                    LineTo(Draw->hDC, Horizontal, Vertical
                                        + (CUSTOMHEIGHT/2));
                    LineTo(Draw->hDC, Horizontal+(HORIZONTALSTUB), Vertical
                                        + (CUSTOMHEIGHT/2));
                    if(!Item->LastSibling)
                        {
                        MoveTo(Draw->hDC, Horizontal, Vertical + (CUSTOMHEIGHT/2));
                        LineTo(Draw->hDC, Horizontal, Vertical
                                        + CUSTOMHEIGHT);
                        }
                    }

                TextOut(Draw->hDC, TextRect.left, TextRect.top, Item->Text, strlen(Item->Text));
                if(Draw->itemState & ODS_FOCUS)
                    DrawFocusRect(Draw->hDC, &FocusRect);
                DeleteObject(SelectObject(Draw->hDC, GetStockObject(BLACK_PEN)));
if(NKids(Item))
    {
SaveDC(Draw->hDC);
SetViewportOrg(Draw->hDC, Horizontal
    + (Item->Level?(HORIZONTALSTUB):0)+LEFTOFBOX, Vertical);
HMETAFILE Box = CreateObjectBox(0,0,Item->Opened);
PlayMetaFile(Draw->hDC, Box);
DeleteMetaFile(Box);
RestoreDC(Draw->hDC, -1);
    }

                return TRUE;
                }
            else if(Draw->itemAction & ODA_FOCUS)
                DrawFocusRect(Draw->hDC, &FocusRect);
            return TRUE;
            }
        case    WM_DELETEITEM   :
            {
            const DELETEITEMSTRUCT *Delete = (DELETEITEMSTRUCT *)Param2;
            CustomList  *Entry = (CustomList *)Delete->itemData;
            delete Entry;
            return TRUE;
            }
        }
    return FALSE;
    }

void FooMenu(HWND Window)
    {
    HMENU   Menu = CreatePopupMenu();
    AppendMenu(Menu, MF_ENABLED | MF_STRING, 1001, "&Ron Demonstrates");
    AppendMenu(Menu, MF_ENABLED | MF_STRING, 1002, "&Owner-draw popups");
    AppendMenu(Menu, MF_ENABLED | MF_STRING, 1003, "&Can't avoid funky '>', but it does work ok!");
    HMENU SysMenu = GetSystemMenu(Window, FALSE);
    AppendMenu(SysMenu, MF_ENABLED | MF_POPUP | MF_OWNERDRAW,
        (UINT)Menu, "&Crappi");
    }


static
BOOL InitDialog(HWND Dialog)
    {
    //FooMenu(Dialog);
    char    Version[64];
    strcpy(Version, "WuiMan v");
    long Status = WUIMAN_Get("/", "p_WuimanVersion",
                              Version + strlen(Version),
                       sizeof(Version)-strlen(Version));
    if(Status < WUIMAN_ERRORS)
        {
        MessageBox(NULL, WUIMAN_LastError, "WUIMAN:WUIMAN_MainDialog", MB_OK);
        }
    else
        SetWindowText(Dialog, Version);
    LoadDatabase(GetDlgItem(Dialog, ID_OBJDB_LISTBOX));
    SetFocus(GetDlgItem(Dialog, ID_OBJDB_LISTBOX));
    return FALSE;
    }

static
BOOL    OwnerDraw(HWND Dialog, UINT Message,
                               WPARAM Param1, LPARAM Param2)
    {
    if(Param1 == ID_OBJDB_LISTBOX)
        return ObjectListbox(Dialog, Message, Param1, Param2);
DEBUG_ERROR("oops =======Param1=%d\n", Param1);
    if(Message == WM_MEASUREITEM)
        {
        MEASUREITEMSTRUCT *Measure = (MEASUREITEMSTRUCT *)Param2;
DEBUG_ERROR("itemWidth=%d, itemHeight=%d", Measure->itemWidth, Measure->itemHeight);
MessageBeep(0);
//        Measure->itemWidth = 250;
//        Measure->itemHeight = 200;
        return TRUE;
        }
    else if(Message == WM_DRAWITEM)
        {
static LOGFONT FancyFontDesc;
        FancyFontDesc.lfHeight      = 12;
        FancyFontDesc.lfWeight      = FW_BOLD;
        strcpy(FancyFontDesc.lfFaceName,"Arial");
        HFONT FancyFont = CreateFontIndirect(&FancyFontDesc);

        DRAWITEMSTRUCT *Draw = (DRAWITEMSTRUCT *)Param2;
        HFONT OldFont = (HFONT)SelectObject(Draw->hDC, FancyFont);
        SetBkColor(Draw->hDC, RGB(0,255,0));
        SetTextColor(Draw->hDC, RGB(255,0,255));
        ExtTextOut(Draw->hDC, Draw->rcItem.left, Draw->rcItem.top, ETO_OPAQUE,
                              &Draw->rcItem, "X", 1, NULL);
        DeleteObject(SelectObject(Draw->hDC, OldFont));
        return TRUE;
        }
    else
        return FALSE;
    }


static
BOOL    MainDialogCommand(HWND Dialog, UINT Command,
                           UINT ControlId, HWND /*Control*/)
    {
    switch(ControlId)
        {
        case    IDOK        :
        case    IDCANCEL    :
            EndDialog(Dialog, 0);
            return TRUE;
        case    ID_PROPERTY_COMBO     :
        case    ID_METHOD_COMBO     :
        case    ID_EVENT_COMBO     :
            if(Command == CBN_SELCHANGE)
                {
                CustomList  *Entry = CurrentEntry(Dialog);
                int TextId = ID_EVENT_VALUE;
                if(ControlId == ID_PROPERTY_COMBO)
                    TextId = ID_PROPERTY_VALUE;
                else if(ControlId == ID_METHOD_COMBO)
                    TextId = 0;
                DisplayAttributeValue(Dialog, Entry->Path, ControlId, TextId);
                }
            break;
        case    ID_PROPDETAIL_BUTTON    :
            if(Command == BN_CLICKED)
                {
                extern HINSTANCE WUIMAN_Instance;
                TProperty   Property;
                Property.Path   = CurrentEntry(Dialog)->Path;
                char    PropertyName[128];
                GetDlgItemText(Dialog, ID_PROPERTY_COMBO,
                        PropertyName, sizeof(PropertyName));
                Property.Property   = PropertyName;
                DialogBoxParam(WUIMAN_Instance,
                           "WUIMAN_PROPERTY_DETAIL", Dialog,
                                      WUIMAN_PropertyDialog,
                                         (LPARAM)&Property);
                return TRUE;
                }
            else
                return FALSE;
        case    ID_OBJDB_LISTBOX    :
            {
            HWND    Listbox = GetDlgItem(Dialog, ID_OBJDB_LISTBOX);
            switch(Command)
                {
                case    LBN_SELCHANGE   :
                    ObjectSelected(Dialog);
                    return TRUE;
                case    LBN_DBLCLK  :
                    {
                    CustomList  *Entry = CurrentEntry(Dialog);
                    Entry->Opened   = !Entry->Opened;
                    if(Entry->Opened)
                        LoadLevel(Listbox, Entry, Entry->Path, Entry->Level+1);
                    else if(NKids(Entry) > 0)
                        {
                        SendMessage(Listbox, WM_SETREDRAW, 0, 0);
                        DWORD Current = ListboxCurrentIndex(Listbox);
                        for(++Current;;)
                            {
                            CustomList *Next = ListboxEntry(Listbox, (int)Current);
                            if(Next && (Next->Level > Entry->Level))
                                SendMessage(Listbox, LB_DELETESTRING, (WPARAM)Current, 0);
                            else
                                break;
                            }
                        InvalidateRect(Listbox, NULL, TRUE);
                        SendMessage(Listbox, WM_SETREDRAW, 1, 0);
                        }
                    return TRUE;
                    }
                }
            return FALSE;
            }
        case    ID_DELETE_BUTTON    :
            {
            CustomList *Current = CurrentEntry(Dialog);
            if(Current == 0)
                {
                MessageBox(Dialog, "Select an object first.",
                                            "WUIMAN", MB_OK);
                return TRUE;
                }
            char    Path[128];
            Path[0] = '\0';
            SetPath(Current, Path);
            WUIMAN_Set(Path, "m_Delete", "");
            LoadDatabase(GetDlgItem(Dialog, ID_OBJDB_LISTBOX));
            return TRUE;
            }
        case    ID_INSERT_BUTTON    :
        case    ID_APPEND_BUTTON    :
        case    ID_NEWCHILD_BUTTON  :
            {
            CustomList *Current = CurrentEntry(Dialog);
            if(Current == 0)
                {
                MessageBox(Dialog, "Select an object first.",
                                            "WUIMAN", MB_OK);
                return TRUE;
                }
#if 0
                AWuiObject   *Cloned = 0;
            DialogBoxParam(WUIMAN_Instance,
                         "WUIMAN_SELECT_OBJECT", Dialog,
                     (DLGPROC)WUIMAN_SelectObjectDialog,
                                    (LPARAM)&Cloned);
            if(Cloned == 0)   // if user made no selection
                return TRUE;
            if(Param1 == ID_NEWCHILD_BUTTON)
                {
                AWuiObject   *Children = Current->Object->Child("Children");
                ASSERT(Children != 0);
                Children->Insert(Cloned);
                }
            LoadDatabase(GetDlgItem(Dialog, ID_OBJDB_LISTBOX));
            char    Path[128];
            Path[0] = '\0';
            SetPath(Current, Path);
            WUIMAN_Send(Path, "Redraw", 0, 0);
#endif
                return TRUE;
            }
        default :
            return FALSE;
        }
    return FALSE;
    }


#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL CALLBACK _export WUIMAN_MainDialog(HWND Dialog,
                 UINT Message, WPARAM Param1, LPARAM Param2)
    {
    extern  HINSTANCE   WUIMAN_Instance;

    if(Message == WM_INITDIALOG)
        return InitDialog(Dialog);
    else if(Message == WM_CTLCOLOR
          && (HIWORD(Param2) == CTLCOLOR_LISTBOX
          || HIWORD(Param2) == CTLCOLOR_EDIT
          || HIWORD(Param2) == CTLCOLOR_BTN))
        {
        HDC DC = (HDC)Param1;
        SetTextColor(DC, RGB(0,0,0));
        SetBkColor(DC, RGB(198,198,198));
        return (BOOL)GetStockObject(LTGRAY_BRUSH);
        }
    else if(Message == WM_MEASUREITEM
        ||  Message == WM_DRAWITEM
        ||  Message == WM_DELETEITEM
           )
        return OwnerDraw(Dialog, Message, Param1, Param2);
    else if(Message == WM_VKEYTOITEM)
        return -1;
    else if(Message == WM_CHARTOITEM)
        return -1;
    else if(Message == WM_COMMAND)
        return DialogCommand(MainDialogCommand, Dialog,
                                            Param1, Param2);
    return FALSE;
    }


BOOL CALLBACK _export WUIMAN_SelectObjectDialog(HWND Dialog,
                 UINT Message, WPARAM Param1, LPARAM Param2)
    {
    switch(Message)
        {
        case    WM_INITDIALOG   :
            {
            SetWindowLong(Dialog, DWL_USER, Param2);
            LoadDatabase(GetDlgItem(Dialog, ID_OBJDB_LISTBOX));
            SendDlgItemMessage(Dialog, ID_CLONE_DEPTH,
                EM_LIMITTEXT, 3, 0);
            return TRUE;
            }
        case    WM_MEASUREITEM  :
            return ObjectListbox(Dialog, Message, Param1, Param2);
        case    WM_DRAWITEM     :
            return ObjectListbox(Dialog, Message, Param1, Param2);
        case    WM_DELETEITEM   :
            return ObjectListbox(Dialog, Message, Param1, Param2);
        case    WM_COMMAND      :
            {
            UINT    Notify = HIWORD(Param2);
            switch(Param1)
                {
                case    IDOK        :
                    {
                    EndDialog(Dialog, 0);
                    return TRUE;
                    }
                case    IDCANCEL    :
                    EndDialog(Dialog, -1);
                    return TRUE;
                case    ID_OBJDB_LISTBOX    :
                    switch(HIWORD(Param2))
                        {
                        case    LBN_SELCHANGE   :
                            {
                            CustomList  *Entry = CurrentEntry(Dialog);
                            SetDlgItemText(Dialog, ID_NEWNAME_TEXT, Entry->Text);
                            return TRUE;
                            }
                        }
                default             :
                    return FALSE;
                }
            }
        default :
            return FALSE;
        }
    }



#if 0
// old experiment with owner-draw menus
if(Param1 != ID_OBJDB_LISTBOX)
    {
    if(Message == WM_MEASUREITEM)
        {
        MEASUREITEMSTRUCT *Measure = (MEASUREITEMSTRUCT *)Param2;
        Measure->itemWidth = 250;
        Measure->itemHeight = 200;
        return TRUE;
        }
    else if(Message == WM_DRAWITEM)
        {
static LOGFONT FancyFontDesc;
        FancyFontDesc.lfHeight      = 48;
        FancyFontDesc.lfWeight      = FW_BOLD;
        strcpy(FancyFontDesc.lfFaceName,"Arial");
        HFONT FancyFont = CreateFontIndirect(&FancyFontDesc);

        DRAWITEMSTRUCT *Draw = (DRAWITEMSTRUCT *)Param2;
        HFONT OldFont = (HFONT)SelectObject(Draw->hDC, FancyFont);
        SetBkColor(Draw->hDC, RGB(0,255,0));
        SetTextColor(Draw->hDC, RGB(255,0,255));
        ExtTextOut(Draw->hDC, Draw->rcItem.left, Draw->rcItem.top, ETO_OPAQUE,
                              &Draw->rcItem, "OwnerDraw", 10, NULL);
        DeleteObject(SelectObject(Draw->hDC, OldFont));
        return TRUE;
        }
    }
#endif

#if 0
                    // get selected object, clone to desired
                    // depth, and return via DWL_USER pointer

                    CustomList  *Entry = CurrentEntry(Dialog);
                    if(Entry == 0)
                        EndDialog(Dialog, -1);
                    char    DepthString[5];
                    GetDlgItemText(Dialog, ID_CLONE_DEPTH, DepthString, 4);
                    int     Depth   = atoi(DepthString);
                    AWuiObject   **Result = (AWuiObject **)
                            GetWindowLong(Dialog, DWL_USER);
                    char    NewName[64];
                    GetDlgItemText(Dialog, ID_NEWNAME_TEXT, NewName, 64);
                    *Result = Entry->Object->Clone(Depth);
                    (*Result)->Rename(NewName);
#endif

