#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>

#include "wuistd.h"
#include "wuiman.h"
#include "wuimanui.h"

#include "testrc.h"

typedef BOOL (*DLGCMNDHANDLER)(HWND Dialog, UINT Notify,
                              UINT ControlId, HWND Control);
inline
BOOL    DialogCommand(DLGCMNDHANDLER Handler, HWND Dialog,
                               WPARAM Param1, LPARAM Param2)
    {
    UINT    Notify;
    UINT    ControlId;
    HWND    Control;
#if defined(__WIN32__)
    Notify      = HIWORD(Param1);
    ControlId   = LOWORD(Param1);
    Control     = (HWND)Param2;
#else
    Notify      = HIWORD(Param2);
    ControlId   = Param1;
    Control     = (HWND)LOWORD(Param2);
#endif
    return Handler(Dialog, Notify, ControlId, Control);
    }


struct  CustomList
    {
    CustomList  *Parent;
    char    Text[WUIMAN_MAXNAME];
    int     Level;
    int     LastSibling;
    char    Path[256];
    int     Opened;
    };

struct  TProperty
    {
    const char *Path;
    const char *Property;
    };

struct TPropertyBits
    {
    UINT    ControlId;
    char   *BitName;
    };

#define WUIGET(path,attr,buf,max) \
    WuiGet(__LINE__, __FILE__,path,attr,buf,max)

long    WuiGet(size_t LineNumber, const char *FileName,
                 const char *Path, const char *Attribute,
                          char *Result, size_t MaxLength);

BOOL CALLBACK _export WUIMAN_SelectObjectDialog(HWND Dialog,
                 UINT Message, WPARAM Param1, LPARAM Param2);
BOOL CALLBACK _export WUIMAN_PropertyDialog(HWND Dialog,
                 UINT Message, WPARAM Param1, LPARAM Param2);


