#include "w_uimain.h"

TPropertyBits   PropertyBits[] =
    {
    { IDPROP_PERSISTANT_CHECK,  "P_PERSISTANT" },
    { IDPROP_INHERITED_CHECK,   "P_INHERITED" },
    { IDPROP_INHERITABLE_CHECK, "P_INHERITABLE" },
    { IDPROP_READONLY_CHECK,    "P_READONLY" },
    { IDPROP_NULL_CHECK,        "P_NULL" }
    };
#define NPROPERTYBITS (sizeof(PropertyBits)/sizeof(TPropertyBits))

static
BOOL    PropertyDialogCommand(HWND Dialog, UINT Command,
                              UINT ControlId, HWND Control)
    {
    TProperty   *Property   = (TProperty *)GetWindowLong(Dialog, DWL_USER);
    switch(ControlId)
        {
        case    IDOK        :
            EndDialog(Dialog, 0);
            return TRUE;
        case    IDCANCEL    :
            EndDialog(Dialog, -1);
            return TRUE;
        case    IDPROP_PERSISTANT_CHECK :
        case    IDPROP_INHERITED_CHECK :
        case    IDPROP_INHERITABLE_CHECK :
        case    IDPROP_READONLY_CHECK :
        case    IDPROP_NULL_CHECK :
            if(Command == BN_CLICKED)
                {
                int State = SendDlgItemMessage(Dialog,
                              ControlId, BM_GETCHECK, 0, 0);
                MessageBeep(State);
                return TRUE;
                }
            break;
        }
    return FALSE;
    }

BOOL CALLBACK _export WUIMAN_PropertyDialog(HWND Dialog,
                 UINT Message, WPARAM Param1, LPARAM Param2)
    {
    TProperty   *Property   = (TProperty *)GetWindowLong(Dialog, DWL_USER);
    switch(Message)
        {
        case    WM_INITDIALOG   :
            {
            SetWindowLong(Dialog, DWL_USER, Param2);
            Property    = (TProperty *)Param2;
            char    Text[512];
            sprintf(Text, "%s.%s", Property->Path, Property->Property);
            SetDlgItemText(Dialog, IDPROP_PATH_STATIC, Text);
            char    Attribute[128];
            for(int i = 0; i < NPROPERTYBITS; ++i)
                {
                sprintf(Attribute, "m_Attribute('%s','%s')",
                    Property->Property, PropertyBits[i].BitName);
                long Status = WUIGET(Property->Path, Attribute, NULL, 0);
                SendDlgItemMessage(Dialog,
                    PropertyBits[i].ControlId, BM_SETCHECK, Status, 0);
                }
            return TRUE;
            }
        case    WM_CTLCOLOR :
            {
            HDC DC = (HDC)Param1;
            SetTextColor(DC, RGB(0,0,0));
            SetBkColor(DC, RGB(198,198,198));
            return (BOOL)GetStockObject(LTGRAY_BRUSH);
            }
        case    WM_COMMAND      :
            return DialogCommand(PropertyDialogCommand,
                                    Dialog, Param1, Param2);
        }
    return FALSE;
    }


