; ----------------------------------------------------------
;  Filename:           chelp.asm
;  Summary:            Assembly code help for makelib
;  Author:             T.W. Nelson
;  Assembler:          BORLAND
;  Assembler options:
;  Date:               10-Oct-1993
;  Version:            2.00
;  Notes:
;
; -------------------------------------------------------

.model  small,C
.data

;DOS EXEC parameter block ......
exec_block  equ     $
envseg      dw      ?
cmdofs      dw      ?
cmdseg      dw      ?
fcb1_ofs    dw      ?
fcb1_seg    dw      ?
fcb2_ofs    dw      ?
fcb2_seg    dw      ?

save_ss     dw      ?
save_sp     dw      ?

stdout_dup  dw      0

extrn   _psp:word

.code

;-------------------------------------------------------------
; int exec_prog( char *progname, char *cmdline );
;
; Load and execute a program using the parent environment,
; passing it a command line. Command line must have leading
; count byte at cmdline[0] and a trailing carriage return.
; Function returns DOS error code in ax which will be 0
; if no errors occurred.
;
public  C exec_prog

exec_prog  proc uses si di, progname:ptr, cmdline:ptr
        mov     es,_psp
        mov     ax,es:[2ch]     ;-> env seg in PSP block
        mov     envseg,ax
        mov     ax,cmdline
        mov     cmdofs,ax
        mov     cmdseg,ds
        mov     fcb1_ofs,5ch
        mov     fcb1_seg,es
        mov     fcb2_ofs,6ch
        mov     fcb2_seg,es
        mov     ax,4b00h        ;DOS EXEC program
        mov     save_ss,ss
        mov     save_sp,sp
        push    ds
        pop     es
        mov     bx,offset exec_block
        mov     dx,progname
        int     21h             ;load and execute program
        mov     dx,0            ;assume no error
        jnc     exec1           ;bypass if no error
        mov     dx,ax           ;save error return code if CY
exec1:  mov     ax,@data        ;restore registers
        mov     es,ax
        mov     ds,ax
        cli
        mov     ss,save_ss
        mov     sp,save_sp
        sti
        mov     ax,dx           ;restore return code
        ret
exec_prog  endp

;-------------------------------------------------------------
; int redirect_stdout( char *tofile );
; returns 0 if successful, -1 on error
;
public C redirect_stdout

redirect_stdout     proc    uses si di, tofile:ptr
        mov     bx,1                    ;stdout handle
        mov     ah,45h                  ;DOS dup handle
        int     21h
        jc      rederr                  ;no handles
        mov     stdout_dup,ax           ;save dup'ed handle
        mov     dx,tofile               ;filename to create
        xor     cx,cx                   ;normal attributes
        mov     ah,3ch                  ;DOS create file
        int     21h
        jc      rederr
        mov     bx,ax                   ;load tofile's handle
        mov     cx,1                    ;stdout handle
        mov     ah,46h                  ;DOS redirect handle
        int     21h
        jc      rederr
        xor     ax,ax                   ;0 = success
        jmp     short redx
rederr: mov     ax,-1
redx:   ret
redirect_stdout     endp

;-------------------------------------------------------------
; void restore_stdout(void);
;
public C restore_stdout

restore_stdout     proc    uses si di
        cmp     stdout_dup,0        ;quit if not redirected
        je      restx
        mov     ah,46h              ;DOS redirect handle
        mov     bx,stdout_dup
        mov     cx,1                ;stdout
        int     21h
restx:  xor     ax,ax
        ret
restore_stdout     endp

;-------------------------------------------------------------
    end
