#
#   Microsoft NMake file for the ENUMPROC library 
#	and its client, SHOWPROC
#

#
#   Set targets and dependencies
#

all: showproc.exe enumproc.dll
showproc.exe: showproc.obj enumproc.lib 
showproc.obj: showproc.c enumproc.h
enumproc.obj: enumproc.c enumproc.h 
enumproc.lib: enumproc.obj enumproc.def
enumproc.dll: enumproc.obj enumproc.exp

#
#   Define macros for command line options and library modules
#

!IFDEF NODEBUG
CFLAGS = -c -G3 -Os -W3 -D_X86_=1 -DWIN32 -D_MT
LFLAGS =
!ELSE
CFLAGS = -c -G3 -Od -W4 -Zi -D_X86_=1 -DWIN32 -D_MT
LFLAGS = -debug:full -debugtype:cv
!ENDIF

SUBSYS = -subsystem:console
LIBS = libcmt.lib kernel32.lib user32.lib advapi32.lib

#
#   Define compiling rules
#

.c.obj:
    cl386 $(CFLAGS) $*.c

.obj.lib:
    lib32 -machine:$(CPU) $*.obj -out:$*.lib -def:$*.def

.obj.exe:
    link32 $(LFLAGS) $(SUBSYS) -out:$*.exe $*.obj $(LIBS) enumproc.lib

.obj.dll:
    link32 $(LFLAGS) -DLL -entry:_DllMainCRTStartup@12 \
        -out:$*.dll $*.obj $*.exp $(LIBS)


