// autosdoc.cpp : implementation of the CAutoservDoc class

#include "stdafx.h"
#include "autoserv.h"
#include "autosdoc.h"
#include "autosvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAutoservDoc

IMPLEMENT_DYNCREATE(CAutoservDoc, CDocument)

BEGIN_MESSAGE_MAP(CAutoservDoc, CDocument)
	//{{AFX_MSG_MAP(CAutoservDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CAutoservDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CAutoservDoc)
	DISP_FUNCTION(CAutoservDoc, "FileNewDoc", FileNewDoc, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CAutoservDoc, "FileOpenDoc", FileOpenDoc, VT_BOOL, VTS_BSTR)
	DISP_FUNCTION(CAutoservDoc, "FileSaveDoc", FileSaveDoc, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CAutoservDoc, "FileSaveDocAs", FileSaveDocAs, VT_BOOL, VTS_BSTR)
	DISP_FUNCTION(CAutoservDoc, "FileCloseDoc", FileCloseDoc, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CAutoservDoc, "EditUndo", EditUndo, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CAutoservDoc, "EditCut", EditCut, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CAutoservDoc, "EditCopy", EditCopy, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CAutoservDoc, "EditPaste", EditPaste, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CAutoservDoc, "EditFind", EditFind, VT_BOOL, VTS_BSTR)
	DISP_FUNCTION(CAutoservDoc, "EditFindNext", EditFindNext, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CAutoservDoc, "EditGetText", EditGetText, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CAutoservDoc, "EditSetText", EditSetText, VT_BOOL, VTS_BSTR)
	DISP_FUNCTION(CAutoservDoc, "EditGetSelectedText", EditGetSelectedText, VT_BSTR, VTS_NONE)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAutoservDoc construction/destruction

CAutoservDoc::CAutoservDoc()
{
	EnableAutomation();
	m_strSearchText.Empty();
	AfxOleLockApp();
}

CAutoservDoc::~CAutoservDoc()
{
	AfxOleUnlockApp();
}

BOOL CAutoservDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));
	pView->GetEditCtrl().SetWindowText( "" );
	pView->Invalidate();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAutoservDoc serialization

void CAutoservDoc::Serialize(CArchive& ar)
{
	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));
	pView->SerializeRaw(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CAutoservDoc diagnostics

#ifdef _DEBUG
void CAutoservDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CAutoservDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAutoservDoc commands

BOOL CAutoservDoc::FileNewDoc()
{
	CAutoservApp * pApp = (CAutoservApp *)AfxGetApp();
	pApp->m_pMainWnd->PostMessage( WM_COMMAND, ID_FILE_NEW,  0L );
	return( TRUE );
}

BOOL CAutoservDoc::FileOpenDoc(LPCSTR pDocName)
{
	CAutoservApp * pApp = (CAutoservApp *)AfxGetApp();
	return( pApp->OpenDocumentFile( pDocName ) != NULL );
}

BOOL CAutoservDoc::FileSaveDoc()
{
	return( DoSave( m_strPathName ));
}

BOOL CAutoservDoc::FileSaveDocAs(LPCSTR pNewDocName)
{
	CString str( pNewDocName );
	return( DoSave( str ));
}

BOOL CAutoservDoc::FileCloseDoc()
{
	OnFileClose();
	return( TRUE );
}

BOOL CAutoservDoc::EditUndo()
{
	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));

	BOOL bResult = FALSE;
	if ( pView->GetEditCtrl().CanUndo() )
		bResult = pView->GetEditCtrl().Undo();

	return( bResult );
}

BOOL CAutoservDoc::EditCut()
{
	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));
	pView->GetEditCtrl().Cut();
	return TRUE;
}

BOOL CAutoservDoc::EditCopy()
{
	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));
	pView->GetEditCtrl().Copy();
	return TRUE;
}

BOOL CAutoservDoc::EditPaste()
{
	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));
	pView->GetEditCtrl().Paste();
	return TRUE;
}

BOOL CAutoservDoc::EditFind(LPCSTR pSearchText)
{
	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));

	BOOL bResult = pView->FindText( pSearchText );
	m_strSearchText = pSearchText;
	return( bResult );
}

BOOL CAutoservDoc::EditFindNext()
{
	CAutoservView * pView = (CAutoservView *)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CAutoservView)));
	return( pView->FindNext( m_strSearchText ) );
}

BSTR CAutoservDoc::EditGetText()
{
	CString s;
	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));
	pView->GetEditCtrl().GetWindowText( s );
	return s.AllocSysString();
}

BOOL CAutoservDoc::EditSetText(LPCSTR pText)
{
	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));
	pView->GetEditCtrl().SetWindowText( pText );
	pView->Invalidate();
	return TRUE;
}

BSTR CAutoservDoc::EditGetSelectedText()
{
	CString s;
	CEditView* pView = (CEditView*)m_viewList.GetHead();
	ASSERT(pView->IsKindOf(RUNTIME_CLASS(CEditView)));
	pView->GetSelectedText( s );
	return s.AllocSysString();
}
