//********************************************************************
// file : ctrdlg.c
// author : Scooper N Ong
// date : Sep 7, 1994
//********************************************************************

#define STRICT
#include <windows.h>

#include "ctrdlg.rch"

// ---- definitions -----
#define SZMODULE  "CtrDlg"
#define SZTITLE   "Centered Dialog"

// ---- prototypes -----
LRESULT CALLBACK _export WndProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK _export CtrDlgProc (HWND, UINT, WPARAM, LPARAM);
void CenterDialog (HWND hDlg);

// ---- declarations -----
HINSTANCE ghInstance;

//-------------------------------------------------------------
//-------------------------------------------------------------
#pragma argsused
int PASCAL WinMain (
        HINSTANCE hInstance, HINSTANCE hPrevInstance,
        LPSTR lpCmdLine, int nCmdShow)
   {
   HWND hWnd;
   MSG msg;

   if ( ! hPrevInstance)
      {
      WNDCLASS wc;

      ghInstance = hInstance;

      wc.style          = CS_HREDRAW | CS_VREDRAW;
      wc.lpfnWndProc    = WndProc;
      wc.cbClsExtra     = 0;
      wc.cbWndExtra     = 0;
      wc.hInstance      = hInstance;
      wc.hIcon          = LoadIcon (NULL, IDI_APPLICATION);
      wc.hCursor        = LoadCursor (NULL, IDC_ARROW);
      wc.hbrBackground  = GetStockObject (WHITE_BRUSH);
      wc.lpszMenuName   = SZMODULE;
      wc.lpszClassName  = SZMODULE;

      if ( ! RegisterClass (&wc))
     return 0;
      }

   hWnd = CreateWindow (
        SZMODULE, SZTITLE,
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT,
        NULL, NULL, hInstance, NULL);

   ShowWindow (hWnd, nCmdShow);
   UpdateWindow (hWnd);

   while (GetMessage (&msg, NULL, 0, 0))
      {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
      }

   return msg.wParam;
   }
     
//----------------------------------------------------------------------
//----------------------------------------------------------------------
LRESULT CALLBACK _export WndProc (
        HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)
   {
   switch (wMsg)
      {
      case WM_COMMAND :
         switch (wParam)
        {
            case IDM_FILEEXIT :
               SendMessage (hWnd, WM_CLOSE, 0, 0L);
               return 0L;

        case IDM_FILEDIALOG :
               {
               DLGPROC lpfnDlgProc;
        
               lpfnDlgProc = (DLGPROC)MakeProcInstance (
                (FARPROC)CtrDlgProc, ghInstance);
               DialogBox (ghInstance, SZMODULE"Popup", hWnd, lpfnDlgProc);
               FreeProcInstance ((FARPROC)lpfnDlgProc);
               return 0L;
               }

            default :
               break;
            }
         break;

      case WM_DESTROY :
         PostQuitMessage (0);
         return 0L;

      default :
         break;
      }

   return DefWindowProc (hWnd, wMsg, wParam, lParam);
   }

//------------------------------------------------------------------
//------------------------------------------------------------------
#pragma argsused
BOOL CALLBACK _export CtrDlgProc (
                        HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
   {
   switch (uMsg)
      {
      case WM_INITDIALOG :
         CenterDialog (hDlg);
         return TRUE;

      case WM_COMMAND :
         if (wParam == IDOK)
            {
            EndDialog (hDlg, 1);
            return TRUE;
            }
      }

   return FALSE;
   }

// --------------------------------------------------
// --------------------------------------------------
void CenterDialog (HWND hWnd)
  {
  POINT ptScreen;
  POINT ptWindow;
  POINT ptCenter;
  RECT  rcWnd;
   
  // get width and height of dialog
  GetWindowRect (hWnd, &rcWnd);
  ptWindow.x = rcWnd.right - rcWnd.left; 
  ptWindow.y = rcWnd.bottom - rcWnd.top;   
 
  // get width and height of screen
  ptScreen.x = GetSystemMetrics (SM_CXSCREEN);
  ptScreen.y = GetSystemMetrics (SM_CYSCREEN);
 
  // compute coordinate to center dialog
  ptCenter.x = (ptScreen.x - ptWindow.x) / 2;
  ptCenter.y = (ptScreen.y - ptWindow.y) / 2;
 
  // reposition window
  SetWindowPos (
      hWnd, NULL,
      ptCenter.x, ptCenter.y,           // reposition to
      NULL, NULL,                       // do not resize
      SWP_NOSIZE | SWP_NOZORDER); 
  }
 