/*****************************************************/
/* endnsnap.c                                        */
/* -- Bug-fix version of tearoff menu EndSnap()      */
/*    routine.                                       */
/*****************************************************/

void EndSnap(PTOS ptos, HWND hwndMenu, BOOL fNew)
/*****************************************************/
/* -- Capture the popped menu's image into the tear- */
/*    off's offscreen bitmap.                        */
/* -- Resize the tear-off to the menu's size.        */
/* -- ptos     : Tear-off.                           */
/* -- hwndMenu : USER's menu window.                 */
/* -- fNew     : If set, indicates tear-off was      */
/*               newly created.  Begin drag if so.   */
/*****************************************************/
    {
    HDC     hdc;
    HBITMAP hbmpSav;
    RECT    rect;
    POINT   pt, dpt;

    GetWindowRect(hwndMenu, &rect); /* Reposition */
    pt = *(POINT *)&rect.left;
    dpt.x = rect.right - rect.left;  /* tear-off. */
    dpt.y = rect.bottom - rect.top;

    /* Cancel menu mode. */
    InflateRect(&rect, 1, 1);
    PostMessage(hwndMenu, WM_LBUTTONDOWN, 0,
      (LPARAM)(LPPOINT)&rect);
    PostMessage(hwndMenu, WM_LBUTTONUP, 0,
      (LPARAM)(LPPOINT)&rect);

    /* Get a bitmap for the tear-off.  If this stuff */
    /* fails, things will be ugly but won't blow up. */
    if (NULL != ptos->hbmp) /* Nuke old one. */
        DeleteObject(ptos->hbmp);
    if (NULL != (hdc = GetDC(hwndMenu)))
        {
        if (NULL != (ptos->hbmp =
          CreateCompatibleBitmap(hdc, dpt.x, dpt.y)))
            {
            hbmpSav = SelectObject(hdcMem, ptos->hbmp);
            BitBlt(hdcMem, 0, 0, dpt.x, dpt.y, hdc,
              0, 0, SRCCOPY); /* Capture bits. */
            if (NULL != hbmpSav)
                SelectObject(hdcMem, hbmpSav);
            }
        ReleaseDC(hwndMenu, hdc);
        }

    SetWindowPos(ptos->hwnd, HWND_TOP, pt.x,
      pt.y - dyText, dpt.x, dpt.y + dyText,
      SWP_SHOWWINDOW | SWP_NOACTIVATE |
        (fNew ? 0 : SWP_NOZORDER));

    if (fNew && GetKeyState(VK_RBUTTON) < 0)
        {
        /* Force tear-off into drag mode. */
        GetCursorPos(&pt);
        ScreenToClient(ptos->hwnd, &pt);
        PostMessage(ptos->hwnd, WM_RBUTTONDOWN, 0,
          *(LPARAM *)&pt);
        }
    }
