#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "decomp.h"

/* 4k Decompression window */
char Window[WINSIZE];

/*************************************************
  Decompresses the data using Microsoft's LZ77
derivative.
**************************************************/ 
void Decompress(FILE *infile, FILE *outfile, long CompSize) {

    unsigned char 	BitMap, byte1, byte2;
    int 			Length, counter;
    long 			Offset, CurrPos=0;

	/* Init our window to spaces (0x20) */
    for (counter = 0; counter < WINSIZE; counter ++)
        Window[counter] = ' ';

    /* Go through until we're done */
    while (CurrPos < CompSize) {

        /* Get BitMap (flag) and data following it */
        BitMap = fgetc(infile); 
        if (feof(infile)) return;

        /* Go through and decode data */
        for (counter = 0; counter < 8; counter++) {

            /* It's a code, so decode it and copy the data */
            if (!BITSET(BitMap, counter)) {
                byte1 = fgetc(infile); 

                /* Shouldn't be EOF, but just in case... */
                if (feof(infile)) return;
                byte2 = fgetc(infile); 
                Length = LENGTH(byte2);
                Offset = OFFSET(byte1, byte2);

                /* Copy data from 'window' */
                while (Length) {
                    byte1 = Window[WRAPFIX(Offset)];
                    Window[WRAPFIX(CurrPos)] = byte1;
                    fputc(byte1, outfile);
                    CurrPos++; 
                    Offset++; 
                    Length--;
                }
            }/* if */

            else {
                byte1 = fgetc(infile);
                Window[WRAPFIX(CurrPos)] = byte1;
                fputc(byte1, outfile); 
                CurrPos++;
            }
            if (feof(infile)) return;

        }/* for */
    }/* while  */
}

/***************************************************
	Reads the compressed file's header and checks
to make sure it's a valid MS-LZ77 compressed file.
****************************************************/
void ReadHeader(FILE *infile, FILE *outfile) {

    COMPHEADER CompHeader;
    long CompSize;

    fseek(infile, 0, SEEK_END);
    CompSize = ftell(infile);
    fseek(infile, 0, SEEK_SET);
    fread(&CompHeader, sizeof(CompHeader), 1, infile);
    if ((CompHeader.Magic1 != MAGIC1)
        || (CompHeader.Magic2 != MAGIC2)) {
        printf("Fatal Error:\n");
        printf("  Not a valid Compressed file file!\n");
        return;
    }

    printf("Decompressing file from %lu bytes to %lu bytes\n",
    CompSize, CompHeader.DecompSize);

    Decompress(infile, outfile, CompHeader.DecompSize);
    printf("Done!\n");

}


void Usage(void) {

    printf("Usage:\n");
    printf(" DECOMP file1.ext file2.ext\n\n\n");
    printf("   file1.ext - Name of comrpessed file\n");
    printf("   file2.ext - Name of decompressed file\n\n");

}

/***************************************************
  Open the file and dump it.
****************************************************/
int main(int argc, char *argv[]) {

    char filename[128];
    FILE *infile, *outfile;

    if (argc < 3) {
        Usage();
        return EXIT_FAILURE;
    }

    strcpy(filename, argv[1]);
    if ((infile = fopen(filename, "rb")) == NULL) {
        printf("%s does not exist!", filename);
        return EXIT_FAILURE;
    }

    strcpy(filename, argv[2]);
    if ((outfile=fopen(filename, "wb")) == NULL) {
        printf("Error opening destination file!");
        return EXIT_FAILURE;
    }

    ReadHeader(infile, outfile);
    fclose(infile);
    fclose(outfile);

    return EXIT_SUCCESS;
}
