#include <WINDOWS.H>
#include <STDIO.H>

#define FILENAME "HELLO.TXT"
#define FILEMAP  "FileMappingObject"

void main()
   {
   PROCESS_INFORMATION pi = { 0 };
   HANDLE hFile, hMappedFile;
   STARTUPINFO si = { 0 };
   BOOL ret_code;
   char *pFile;

   hFile = CreateFile(FILENAME, GENERIC_READ|GENERIC_WRITE, FILE_SHARE_WRITE,
      NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

   printf("CreateFile returned %d\n", hFile);

   hMappedFile = CreateFileMapping(hFile, NULL, PAGE_READWRITE,
      0, 25, FILEMAP);

   printf("CreateFileMapping returned %d\n", hMappedFile);

   pFile = (char *)MapViewOfFile(hMappedFile, FILE_MAP_WRITE, 0, 0, 0);

   printf("MapViewOfFile returned %d\n", pFile);

   strcpy(pFile, "TESTING TNT FILE MAPPING.");

   printf("\n%s\n\n", pFile);

   ret_code = UnmapViewOfFile(pFile);

   printf("UnmapViewOfFile returned %d\n", ret_code);

   ret_code = CloseHandle(hMappedFile);

   printf("CloseHandle (file mapping) returned %d\n", ret_code);

   ret_code = CloseHandle(hFile);

   printf("CloseHandle (file) returned %d\n", ret_code);
   }

