#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>
#include "dbtrace.h"

// static variable to remember most recent message type
// (tacky, but effective)

static char MessageType = 't';


void    DebugPrintf(char Type, const char *Format, va_list Args)
    {
    char    *Message = "No memory for DebugPrintf().\r\r\n";
    char    *Buffer  = new char[1000];
    if(Buffer)
        {
        char    *Append = Buffer;
        sprintf(Buffer, "%c ", Type);
        Append  = Buffer + strlen(Buffer);
        vsprintf(Append, Format, Args);
        Message = Buffer;
        }
    if(Message[strlen(Message)-1] == '\n')
        Message[strlen(Message)-1] = '\0';
    OutputDebugString(Message);
    if(Type == '\0')
        OutputDebugString("\r\n");
    if(Type == '\0' && MessageType == 'f')
        {
        // So BoundsChecker will give stack traceback
        GlobalLock(0);
        FatalAppExit(0, Message);
        }

    if(Buffer)
        delete[] Buffer;
    }

void    DebugPrintf(const char *Format, ...)
    {
    va_list Args;
    va_start(Args, Format);
    DebugPrintf('\0', Format, Args);
    va_end(Args);
    }

void    DebugPrintf(char Type, const char *Format, ...)
    {
    va_list Args;
    va_start(Args, Format);
    MessageType = Type;
    DebugPrintf(Type, Format, Args);
    va_end(Args);
    }

