#include <stdio.h>
#include <string.h>
#include <windows.h>
#include "testrc.h"
#include "wuistd.h"
#include "wuiman.h"

#include "ctl3d.h"


BOOL CALLBACK _export DlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK _export WUIMAN_MainDialog(HWND, UINT, WPARAM, LPARAM);


HINSTANCE   ThisInstance;


#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE Me, HINSTANCE Previous,
		     LPSTR lpszCmdLine, int nCmdShow)
    {
    ThisInstance    = Me;
    Ctl3dRegister(ThisInstance);
    Ctl3dAutoSubclass(ThisInstance);
    long Status = WUIMAN_Open(ThisInstance, "test.wui");
    if(Status < WUIMAN_ERRORS)
        MessageBox(NULL, WUIMAN_LastError, "test.exe: WUIMAN_Init() failed.", MB_OK);
    else
        {
        HRSRC Dialog = FindResource(ThisInstance, "WUIMAN_OBJECTS", RT_DIALOG);
        if(Dialog == NULL)
            {
            MessageBox(NULL, "Could not load main dialog "
                "window!!!", "Wuiman", MB_OK);
            }
        else
            DialogBox(Me, "WUIMAN_OBJECTS", NULL, (DLGPROC)WUIMAN_MainDialog);
        }
    WUIMAN_Close();
    Ctl3dUnregister(ThisInstance);
    return 0;
    }


#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL CALLBACK _export DlgProc(HWND Dialog, UINT Message,
                             WPARAM Param1, LPARAM Param2)
    {
    if(Message == WM_INITDIALOG)
        {
        return TRUE;
        }
    else if(Message == WM_MENUSELECT)
        {
        char    Buffer[128];
        wsprintf(Buffer, "WM_MENUSELECT ID[%d] Flags[0x%04X]",
            Param1, LOWORD(Param2));
        SetDlgItemText(Dialog, 101, Buffer);
        }
    else if(Message == WM_MENUCHAR)
        {
        char    Buffer[128];
        wsprintf(Buffer, "WM_MENUCHAR CHAR[%d] Flags[0x%04X]",
            Param1, LOWORD(Param2));
        SetDlgItemText(Dialog, 102, Buffer);
        }
    else if(Message == WM_COMMAND)
        if(Param1 == IDOK || Param1 == IDCANCEL) {
            EndDialog(Dialog, 0);
            return TRUE;
            }
    else if(Message == WM_KEYDOWN)
        MessageBeep(0);
    return FALSE;
    }


