// wuiargs.h - define argument parsing for WUIMAN set attribute
// Copyright (c) 1993 by Ron Burk

#ifndef WUIARGS_H
#define WUIARGS_H

#ifndef WUISTD_H
    #include "wuistd.h"
#endif
#ifndef WUINAME_H
    #include "wuiname.h"
#endif

class   TWuiArgs
    {
public:
    enum        { MAXARGS = 16 };
    TWuiArgs(const char *AttributeName);
   ~TWuiArgs();
    enum        ArgType { LONG_ARG, STRING_ARG, ERROR_ARG };
    ArgType     GetType(int Which);
    long        GetLong(int Which);
    char       *GetString(int Which);
    TWuiName    AttributeName();
    int         NArgs();
private:
    TWuiArgs(const TWuiArgs& Dummy);
    const TWuiArgs &operator=(const TWuiArgs&Dummy);
    const char *GetArg(const char *Input, char *Output);
    int         NArgs_;
    ArgType     ArgTypes_[MAXARGS];
    void       *Args_[MAXARGS];
    TWuiName    AttributeName_;
    };

inline
int     TWuiArgs::NArgs()
    {   MEMBERASSERT();
    return NArgs_;
    }

inline
TWuiName    TWuiArgs::AttributeName()
    {   MEMBERASSERT();
    return AttributeName_;
    }

#endif
