// wuilist.c - WUIMAN generic list classes
// Copyright (c) 1993 by Ron Burk

#include <string.h>     // memcpy()
#include "wuilist.h"

TWuiGenericList::TWuiGenericList(int  InitialSize)
    :   List_(0), ListSize_(0), NElements_(0)
    {   MEMBERASSERT();
    if(InitialSize > 0)
        SetSize(InitialSize, *this);
    }

// copy constructor
TWuiGenericList::TWuiGenericList(
                       const TWuiGenericList& Other)
    :   List_(0)
    {   MEMBERASSERT();
    *this   = Other;    // pass the buck to assignment op
    }

// assignment operator - pass buck to SetSize()
void TWuiGenericList::operator=(
                       const TWuiGenericList& Other)
    {   MEMBERASSERT();
    if(this != &Other)  // detect self-assignment
        SetSize(Other.NElements_, Other);
    }

// destructor - free up memory
TWuiGenericList::~TWuiGenericList()
    {   MEMBERASSERT();
    if(List_)
        delete[] List_;
    }

// SetSize - handle growing, shrinking, copying.
//           Note: Other could be me!
void    TWuiGenericList::SetSize(int  NewSize,
                       const TWuiGenericList &Other)
    {   MEMBERASSERT();
    int     CopySize = (NewSize < Other.NElements_)
                                 ? NewSize : Other.NElements_;
    void    **NewList = 0;
    if(NewSize > 0)
        {
        NewList    = new void *[NewSize];
        ASSERT(NewList != 0);
        if(Other.List_ != 0)
            memcpy(NewList, Other.List_, sizeof(void*)*CopySize);
        if(List_)
            delete[] List_;
        List_  = NewList;
        }
    else
        List_  = 0;
    ListSize_    = NewSize;
    }

// Insert - add object at specific position
void   *TWuiGenericList::Insert(void *NewObject, int Position)
    {   MEMBERASSERT();
    ASSERT(NewObject != 0);
    if(Position < 0 || Position > NElements_)
        Position    = NElements_;   // default is append
    if(ListSize_ == NElements_)
        SetSize(NElements_+1, *this);
    if(Position != NElements_)
        memmove(&List_[Position+1], &List_[Position],
                sizeof(List_[0]) * (NElements_-Position));
    List_[Position]    = NewObject;
    ++NElements_;
    ASSERT(NElements_ <= ListSize_);
    return NewObject;
    }

// Remove - Remove object at specific position.
//          Note: Remove() does not delete object for you.
void *TWuiGenericList::Remove(int Position)
    {   MEMBERASSERT();
    void *Removed = 0;
    if(NElements_)   // if we have any to delete
        {
        // default is to delete last element of array
        if(Position < 0 || Position >= NElements_)
            Position    = NElements_-1;
        Removed = List_[Position];
        --NElements_;
        if(Position < NElements_)
            memmove(&List_[Position], &List_[Position+1],
                sizeof(List_[0]) * (NElements_-Position));
        }
    return Removed;
    }

