// wuilist.h - WUIMAN generic list class
// Copyright (c) 1993 by Ron Burk

#ifndef WUILIST_H
#define WUILIST_H

#include "wuistd.h"

class   TWuiGenericList
    {
public:
    TWuiGenericList(int InitialSize = 0);
    TWuiGenericList(const TWuiGenericList&);
    void operator=(const TWuiGenericList&);
   ~TWuiGenericList();
    void   *Get(int Index);
    void   *Remove(int Index);
    void   *Insert(void *Addition, int Index=-1);
    int     NElements();
private:
    void    SetSize(int NewSize,
                      const TWuiGenericList &Other);
    void  **List_;
    int     ListSize_;
    int     NElements_;
    };

inline
int     TWuiGenericList::NElements()
    {   MEMBERASSERT();
    return NElements_;
    }

inline
void   *TWuiGenericList::Get(int Index)
    {   MEMBERASSERT();
    ASSERT(Index < NElements_ && Index >= 0);
    return List_[Index];
    }

#endif
