#include "w_atom.h"

const int MAX_ATOM_NAME = 160;

// constructor
TGlobalAtom::TGlobalAtom(const char *AtomName)
    :   GlobalAtom(GlobalAddAtom(AtomName))
    {   MEMBERASSERT();
    ASSERT(GlobalAtom != NULL);
    }

// destructor
TGlobalAtom::~TGlobalAtom()
    {   MEMBERASSERT();
    ASSERT(GlobalAtom != NULL);
    GlobalDeleteAtom(GlobalAtom);
    }

// copy constructor
TGlobalAtom::TGlobalAtom(const TGlobalAtom& Atom)
    :   GlobalAtom(NULL)
    {   MEMBERASSERT();
    // let assignment operator do all the work
    *this   = Atom;
    }

// Assignment operator
TGlobalAtom& TGlobalAtom::operator=(const TGlobalAtom& Atom)
    {   MEMBERASSERT();
    // conspiracy with copy constructor
    if(GlobalAtom != NULL)
        GlobalDeleteAtom(GlobalAtom);
    char    AtomName[MAX_ATOM_NAME+1];
    ASSERT2(
        GlobalGetAtomName(Atom.GlobalAtom, AtomName,
            MAX_ATOM_NAME) < MAX_ATOM_NAME
        );
    GlobalAtom  = GlobalAddAtom(AtomName);
    ASSERT(GlobalAtom != NULL);
    return *this;
    }

HANDLE  TGlobalAtom::GetProperty(HWND Window) const
    {   MEMBERASSERT();
    return GetProp(Window, (LPCSTR)MAKELP(0, GlobalAtom));
    }
int     TGlobalAtom::SetProperty(HWND Window, HANDLE Value)
    {   MEMBERASSERT();
    return SetProp(Window, (LPCSTR)MAKELP(0, GlobalAtom),
                                                     Value);
    }
HANDLE  TGlobalAtom::RemoveProperty(HWND Window) const
    {   MEMBERASSERT();
    return RemoveProp(Window, (LPCSTR)MAKELP(0, GlobalAtom));
    }

