// w_hook.h - declarations for hooking window messages.
// Copyright (c) 1993 by Ron Burk

#ifndef W_HOOK_H
#define W_HOOK_H

#if !(defined(_INC_WINDOWS) || defined(__WINDOWS_H))
    #include <windows.h>
#endif

class   TWindowSubclass
    {
public:
    TWindowSubclass(HWND Window);
    // redefine: always
    virtual LRESULT Handler(HWND Window, UINT Message,
                              WPARAM Param1, LPARAM Param2);
protected:
    // hokey special constructor for default subclass
    TWindowSubclass();
    virtual ~TWindowSubclass();
private:
    // I don't support assignment,
    // so declare but don't define these two:
    TWwindowSubclass(const TWindowSubclass&);
    TWindowSubclass& operator=(const TWindowSubclass&);

    static LRESULT CALLBACK _export WindowHook(HWND,UINT,
                                             WPARAM,LPARAM);
    static WNDPROC  Unhook(HWND Window,
                                    TWindowSubclass *First);
    TWindowSubclass *Next;
    };

#endif // W_HOOK_H
