#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>

#include "wuistd.h"
#include "w_uiutil.h"

#include "testrc.h"

typedef BOOL (*DLGCMNDHANDLER)(HWND Dialog, UINT Notify,
                               int ControlId, HWND Control);
inline
BOOL    DialogCommand(DLGCMNDHANDLER Handler, HWND Dialog,
                               WPARAM Param1, LPARAM Param2)
    {
    UINT    Notify;
    UINT    ControlId;
    HWND    Control;
#if defined(__WIN32__)
    Notify      = HIWORD(Param1);
    ControlId   = LOWORD(Param1);
    Control     = (HWND)Param2;
#else
    Notify      = HIWORD(Param2);
    ControlId   = Param1;
    Control     = (HWND)LOWORD(Param2);
#endif
    return Handler(Dialog, Notify, (int)ControlId, Control);
    }


struct  CustomList
    {
    CustomList  *Parent;
    char    Text[WUIMAN_MAXNAME];
    int     Level;
    int     LastSibling;
    char    Path[256];
    int     Opened;
    };

struct  TProperty
    {
    const char *Path;
    const char *Property;
    };

struct TPropertyBits
    {
    int    ControlId;
    char   *BitName;
    };

BOOL CALLBACK _export WUIMAN_SelectObjectDialog(HWND Dialog,
                 UINT Message, WPARAM Param1, LPARAM Param2);
BOOL CALLBACK _export WUIMAN_PropertyDialog(HWND Dialog,
                 UINT Message, WPARAM Param1, LPARAM Param2);


