#include "w_uimain.h"

TPropertyBits   PropertyBits[] =
    {
    { IDPROP_PERSISTENT_CHECK,  "P_PERSISTENT" },
    { IDPROP_INHERITED_CHECK,   "P_INHERITED" },
    { IDPROP_INHERITABLE_CHECK, "P_INHERITABLE" },
    { IDPROP_READONLY_CHECK,    "P_READONLY" },
    };
#define NPROPERTYBITS (sizeof(PropertyBits)/sizeof(TPropertyBits))

static
BOOL    PropertyDialogCommand(HWND Dialog, UINT Command,
                              int ControlId, HWND /*Control*/)
    {
    TProperty   *Property   = (TProperty *)GetWindowLong(Dialog, DWL_USER);
    switch(ControlId)
        {
        case    IDOK        :
            EndDialog(Dialog, 0);
            return TRUE;
        case    IDCANCEL    :
            EndDialog(Dialog, -1);
            return TRUE;
        case    IDPROP_PERSISTENT_CHECK :
        case    IDPROP_INHERITED_CHECK :
        case    IDPROP_INHERITABLE_CHECK :
        case    IDPROP_READONLY_CHECK :
            if(Command == BN_CLICKED)
                {
                for(int i = 0; i < NPROPERTYBITS; ++i)
                    if(PropertyBits[i].ControlId == ControlId)
                        break;
                ASSERT(i < NPROPERTYBITS);
                char Attribute[128];
                int State = (int)SendDlgItemMessage(Dialog,
                              ControlId, BM_GETCHECK, 0, 0);
                sprintf(Attribute, "m_Attribute('p_%s', '%s', %d)",
                    Property->Property, PropertyBits[i].BitName,
                    State);
                WUISET(Property->Path, Attribute, State?"1":"0");
                sprintf(Attribute, "m_Attribute('p_%s', '%s')",
                    Property->Property, PropertyBits[i].BitName);
                long Status = WUIGET(Property->Path, Attribute, NULL, 0);
                if((!Status) != (!State))
                    {
                    MessageBeep(0);
                    SendDlgItemMessage(Dialog,
                                  PropertyBits[i].ControlId,
                            BM_SETCHECK, (WPARAM)Status, 0);
                    }
                return TRUE;
                }
            break;
        }
    return FALSE;
    }

BOOL CALLBACK _export WUIMAN_PropertyDialog(HWND Dialog,
                 UINT Message, WPARAM Param1, LPARAM Param2)
    {
    TProperty   *Property   = (TProperty *)GetWindowLong(Dialog, DWL_USER);
    switch(Message)
        {
        case    WM_INITDIALOG   :
            {
            SetWindowLong(Dialog, DWL_USER, Param2);
            Property    = (TProperty *)Param2;
        {
            char Path[256];
            strcpy(Path, Property->Path);
            if(strlen(Path) > 1)
                strcat(Path, "/");
            strcat(Path, ".p_");
            strcat(Path, Property->Property);
            char ClassName[WUIMAN_MAXNAME];
            WUIGET(Path,
                    "m_Class()", ClassName, WUIMAN_MAXNAME);
            SetDlgItemText(Dialog, ID_CLASS_NAME, ClassName);
            WUIGET(Path,
                    "m_ParentClass()", ClassName, WUIMAN_MAXNAME);
            SetDlgItemText(Dialog, ID_PARENT_NAME, ClassName);
        }
            char    Text[512];
            sprintf(Text, "%s.%s", Property->Path, Property->Property);
            SetDlgItemText(Dialog, IDPROP_PATH_STATIC, Text);
            char    Attribute[128];
            for(int i = 0; i < NPROPERTYBITS; ++i)
                {
                sprintf(Attribute, "m_Attribute('p_%s','%s')",
                    Property->Property, PropertyBits[i].BitName);
                long Status = WUIGET(Property->Path, Attribute, NULL, 0);
                SendDlgItemMessage(Dialog,
                                  PropertyBits[i].ControlId,
                            BM_SETCHECK, (WPARAM)Status, 0);
                }
            return TRUE;
            }
        case    WM_CTLCOLOR :
            {
            HDC DC = (HDC)Param1;
            SetTextColor(DC, RGB(0,0,0));
            SetBkColor(DC, RGB(198,198,198));
            return (BOOL)GetStockObject(LTGRAY_BRUSH);
            }
        case    WM_COMMAND      :
            return DialogCommand(PropertyDialogCommand,
                                    Dialog, Param1, Param2);
        }
    return FALSE;
    }


