// w_uiutil.h - generally useful routines for building
//              a WUIMAN user interface
// Copyright (c) 1994 by Ron Burk

#ifndef W_UIUTIL_H
#define W_UIUTIL_H

#include "wuiman.h"

#define WUIGET(path,attr,buf,max) \
    WuiGet(__LINE__, __FILE__,path,attr,buf,max)

long    WuiGet(size_t LineNumber, const char *FileName,
                 const char *Path, const char *Attribute,
                          char *Result, size_t MaxLength);

#define WUISET(path,attr,buf) \
    WuiSet(__LINE__, __FILE__,path,attr,buf)

long    WuiSet(size_t LineNumber, const char *FileName,
                    const char *Path, const char *Attribute,
                                         const char *Value);

long    WuiGetBit(const char *Path, const char *Property,
                const char *BitName);

long    WuiSetBit(const char *Path, const char *Property,
                const char *BitName, int On=1);


#endif

