#include <windows.h>
#include <stdlib.h> /* exit() */
#include <stdio.h>  /* fopen(), etc. */

/* List macros from longest name to shortest! */
/* All macros must start with . or #! */
/* In macro expansions: Double all BSs; use \n for newlines
   in .RTF output */

/* Standard page format */
#define    STD "\\pard\\li180\\ri180\n"

LPSTR macros[] = {
".end_of_help_file=}",

/* .start(1:label,2=topic,3=bitmap file,4=program name) */
".start={\\rtf\\ansi\n"
"{\\fonttbl\n"
"    {\\f0\\froman MS Sans Serif;}\n"
"    {\\f1\\fswiss Arial;}\n"
"    {\\f2\\fdecor Fixedsys;}\n"
"    {\\f3\\fdecor Symbol;}\n"
"}"STD
"#{\\footnote %1}\n"
"${\\footnote %2}\n"
"K{\\footnote %2}\n"
"\\f1\n"
"\\fs64\n"
"\\keepn\n" /* Make top of Contents non-scrolling */
"%4 \\strike\\{bmc %3\\}{\\v icon}\\strike0\n"
"\\f0\n"
"\\par\n"
"\\fs48\n"
"Table of Contents\n"
"\\par\\fs24\\tx540\n"STD,

".pent=#{\\footnote %1}\n"
"${\\footnote %2 (def.)}\n"
"K{\\footnote  %2 (def.)}\n"STD,

".ent=#{\\footnote %1}\n"
"${\\footnote %2}\n"
"K{\\footnote  %2}\n"
"\\fs48\n"
"\\keepn\n"
"%3%2\n"
"\\fs24\n"
"\\par\n"STD
"\\par",

".top=K{\\footnote %1}",

".end=\\page\n",

".bmp=\\{bmc %1\\}",

".rem=",

".in=\\li720\\fi-360\n",
/* Diamonds: */
/*"##=\\par{\\f3\n\\'a8}\\tab\n", */
/*"#b=\\par{\\f3\n\\'a8}\\tab\\b\n%1\\b0\n: \n", */
"##=\\par{\\f3\n\\'b7}\\tab\n",
"#b=\\par{\\f3\n\\'b7}\\tab\\b\n%1\\b0\n: \n",
"#n=\\par\\b\n%1.\\b0\\tab\n",
".un=\\par"STD,

".[=\\f2\\fs30\n",
".]=\\f0\\fs24\n",

".s=\\par\n\\par\n",

".n=\n\\par\n",

".j1={\\uldb %1}{\\v %1}",
".j={\\uldb %2}{\\v %1}",

".p1={\\ul %1}{\\v %1}",
".p={\\ul %2}{\\v %1}",

".b=\n\\b\n%1\n\\b0\n",
NULL};

#define NAME_END '='

/* Standard declarations */
#define EQ ==
#define NE !=
#define NUL '\0'
typedef unsigned long L;
typedef unsigned short S;
#define    PRINT wsprintf
#define STRCPY lstrcpy
#define STRNCPY _fstrncpy
#define STRLEN lstrlen
#define STRCAT lstrcat
#define STRCHR _fstrchr
#define STRCMP lstrcmp
#define STRCMPI lstrcmpi
#define ERR int_error(__LINE__, __FILE__)

/* Global declarations */
LPSTR       app_name = "HLPMAC";
HINSTANCE   instance;
#define     TEXTLEN 256
#define     LONGTEXTLEN 1024
HWND        desk, cur_dlg;
char        from[TEXTLEN];
char        to[TEXTLEN];
typedef FILE * STREAM;
STREAM      ffrom, fto;
#define     MAXARGS 9
LPSTR       arg[MAXARGS]; /* arg[0] is %1, etc. */
short       line;

/* Error message dialog */
void    error(LPSTR format, ...)
    {
    LPSTR far *        args;
    char            text1[TEXTLEN];
    char            text[TEXTLEN];

    args = &format;
    args++;
    wvsprintf(text, format, args);
    PRINT(text1, "Sorry, %s.", (LPSTR)text);
    MessageBox(NULL, text1, app_name, MB_TASKMODAL
                                     | MB_ICONSTOP | MB_OK);
    exit(1);
    } /* error */

/* Called by ERR macro */
void    int_error(L line, LPSTR file)
    {
    error("internal error on line %ld in file %s", line, file);
    } /* int_error */

/* Show/hide WAIT cursor */
HCURSOR    orig_cursor;
void    start_wait(void)
    {
    if (orig_cursor)
        return;
    orig_cursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
    } /* start_wait */
void    end_wait(void)
    {
    if (!orig_cursor)
        return;
    SetCursor(orig_cursor);
    orig_cursor = NULL;
    } /* end_wait */

/* Used by parse_args() */
LPSTR    get_next_pos(LPSTR * arg_pos)
    {
    if (**arg_pos)
        return (*arg_pos)++;
    else
        return *arg_pos; /* End of line: stay */
    } /* get_next_pos */
                        
/* Parse actual args, if any, that follow the macro
 * name in the src line, arg[0] is %1, etc. */
void    parse_args(LPSTR * arg_pos)
    {
    LPSTR    next_pos;
    int        a;

    /* Empty all args, for error detection */
    for (a = 0; a < MAXARGS; ++a)
        arg[a] = NULL;

    next_pos = get_next_pos(arg_pos); /* Skip '(' */
    if (*next_pos NE '(')
        {
        --*arg_pos; /* No args: Restore following char */
        return; /* No actual args */
        }

    arg[0] = *arg_pos; /* Start of first arg */
    next_pos = get_next_pos(arg_pos);
    for (a = 1; *next_pos && *next_pos NE ')';
        next_pos = get_next_pos(arg_pos)) /*Skip final ')'*/
        {
        if (*next_pos EQ ',') /* Skip ',' */
            arg[a++] = *arg_pos;
        } /* Scan each char */
    /*Debug: error("the first args are '%s' '%s' '%s'",
                                 arg[0], arg[1], arg[2]); */
    } // parse_args

/* Match buffer against given macro */
BOOL    match_strings(LPSTR buffer, LPSTR macro,
    LPSTR * end_of_match, LPSTR * body)
    {
    for (;;)
        {
        if (*macro EQ NAME_END)
            {
            *end_of_match = buffer;
            *body = macro + 1; /* Skip = */
            parse_args(end_of_match);
            return TRUE;
            } /* Macro matches */
        else if (*buffer++ NE *macro++)
            return FALSE;
        } /* Scan macro */ 
    } /* match_strings */

/* Try matching each macro at this point in the line */
BOOL match(LPSTR buffer, LPSTR * end_of_match, LPSTR * body)
    {
    LPSTR *        macro;

    /* Macros must start with special chars, for speed */
    if (*buffer NE '.' && *buffer NE '#')
        return FALSE;

    /* Try matching against each macro in list */
    for (macro = macros; *macro; ++macro)
        if(match_strings(buffer, *macro,end_of_match, body))
            return TRUE;
    return FALSE;
    } /* match */

/* Expand a macro body */
void    expand_macro(LPSTR body, LPSTR * pexp)
    {
    LPSTR        p;
    int            a;

    while (*body)
        {
        if (*body EQ '%')
            {
            /* Expand an arg */
            ++body; /* Skip % */
            a = *body - '1';
            ++body; /* Skip digit */
            p = arg[a];
            if (!p)
                error("too few actual macro args--macro_name"
                    "(arg0, arg1, ...)--on line %d", line);
            while (p && *p && *p NE ')' && *p NE ',')
                *(*pexp)++ = *p++;
            }
        else
            *(*pexp)++ = *body++;
        }
    } /* expand_macro */

/* Expand all macros in current line */
void    expand_line(LPSTR buffer, LPSTR exp_buffer)
    {
    LPSTR        end_of_match, body;

    /* Scan each input char */
    while (*buffer)
        {
        /* Try matching each macro at this point */
        if (match(buffer, &end_of_match, &body))
            {
            /* Match found: expand macro body,
                                        skip matched part */
            expand_macro(body, &exp_buffer);
            buffer = end_of_match;
            }
        else
            /* No match: copy char */
            *exp_buffer++ = *buffer++;
        } /* Scan line */
    *exp_buffer = NUL;
    } /* expand_line */

/* Expand one file to another, overwriting the second */
void    expand(LPSTR to, LPCSTR from)
    {
    NPSTR        shortp;
    LPSTR        p;
    L            status;
    char        buffer[LONGTEXTLEN];
    char        exp_buffer[LONGTEXTLEN];

    shortp = (NPSTR)LOWORD(from);
    ffrom = fopen(shortp, "r");
    if (ffrom EQ NULL)
        error("file %s not found", (L)from);
    fto = fopen((NPSTR)LOWORD(to), "w");
    if (!fto)
        error("cannot create file %s", (L)to);
    for (;;)
        {
        p = fgets(buffer, sizeof(buffer), ffrom);
        /*Debug: error("first line is %s", (L)buffer); */
        /*   if (bytes EQ HFILE_ERROR) */
        /*         error("cannot read file %s", (L)from); */
        if (!p || !*p)
            break;
        ++line;
        expand_line(buffer, exp_buffer);
        status = fputs(exp_buffer, fto);
        if (status EQ (L)EOF)
            error("cannot write file %s", (L)to);
        }
    if (!line)
        error("cannot read file %s", (L)from);
    } /* expand */

BOOL    get_arg(LPSTR var, LPSTR * pp)
    {
    if (!**pp || **pp EQ ' ')
        return FALSE; /* End comes too early */
    for (;;)
        {
        if (!**pp || **pp EQ ' ')
            break;
        *var++ = *(*pp)++;
        } /* Scan arg */
    *var = NUL;
    return TRUE;
    } /* get_arg */

BOOL    get_args(LPSTR args)
    {
    if (!get_arg(from, &args))
        return FALSE;
    ++args; /* Skip blank */
    if (!get_arg(to, &args))
        return FALSE;
    return TRUE;
    } /* get_args */

#ifdef __BORLANDC__
    #pragma argsused
#endif
/* Main function */
int pascal WinMain(HINSTANCE hInst, HINSTANCE hPrevInst,
                                   LPSTR pCmdLine, int Show)
    {
    /* Main Program starts here */
    instance = hInst;
    start_wait();
    if (!get_args(pCmdLine))
        error("usage is: HLPMAC src_file dst_file");
    expand(to, from);
    return 0;
    } /* WinMain */

/* Cleanup on exiting Central (called from exit()) */
void    cleanup(void)
    {
    if (ffrom)
        fclose(ffrom);
    if (fto)
        fclose(fto);
    end_wait();
    } /* cleanup */
