/****************************************************
 * Listing 4 - sample.c
 *   written by: Charles Leamon
 *
 * A simple program to demonstrate 
 * the use of Custom Resources.
 ***************************************************/
#define  SAMPLE_C
#include "sample.h"
#include "populate.h"

#ifdef __BORLANDC__
    #pragma argsused
#endif
/****************************************************
 * WinMain
 ***************************************************/
int PASCAL WinMain (HINSTANCE hInstance, 
                    HINSTANCE hPrevInstance, 
                    LPSTR lpszCmdLine, 
                    int cmdShow)
{
   MSG msg;

   hInst = hInstance;
   
   if (!hPrevInstance) {
      if (!InitFirstInstance(hInstance)) {
         return(1);
      }
   } else return(1);

   hWndMain = CreateWindow(szAppClass,
                           szAppTitle,
                           WS_OVERLAPPEDWINDOW,
                           CW_USEDEFAULT, 
                           CW_USEDEFAULT, 
                           CW_USEDEFAULT, 
                           CW_USEDEFAULT,
                           (HWND)NULL,
                           NULL,
                           hInstance,
                           (LPSTR)NULL);
   
   
   if (!hWndMain) return(1);
   
   ShowWindow(hWndMain, cmdShow);
   UpdateWindow(hWndMain);
   
   while (GetMessage(&msg, NULL, 0, 0)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return(msg.wParam);
}

/****************************************************
 * InitFirstInstance
 ***************************************************/
BOOL InitFirstInstance (HANDLE hInstance)
{
   WNDCLASS wc;

   wc.lpszClassName = szAppClass;
   wc.style = CS_HREDRAW | 
              CS_VREDRAW | 
              CS_BYTEALIGNWINDOW;
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hIcon = LoadIcon(hInst, szIconName);
   wc.lpszMenuName = szMenuName;
   wc.hbrBackground = GetStockBrush(LTGRAY_BRUSH);
   wc.hInstance = hInstance;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   return(RegisterClass(&wc));
}

void CenterWindow(HWND hWnd)
{
    RECT swp;
    int iwidth;
    int iheight;
    int x, y;

    GetWindowRect(hWnd, &swp);

    iwidth = swp.right - swp.left;
    iheight = swp.bottom - swp.top;

    x = GetSystemMetrics(SM_CXSCREEN) / 2;
    y = GetSystemMetrics(SM_CYSCREEN) / 2;

    x = x - (iwidth / 2);
    y = y - (iheight / 2);

    MoveWindow(hWnd, x, y, iwidth, iheight, FALSE);
}

/****************************************************
 * Sample_OnClose
 ***************************************************/
void Sample_OnClose(HWND hWnd)
{
   DestroyWindow(hWnd);
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
/****************************************************
 * Sample_OnDestroy
 ***************************************************/
void Sample_OnDestroy(HWND hWnd)
{
   PostQuitMessage(0);
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
/****************************************************
 * Sample_OnCommand
 ***************************************************/
void Sample_OnCommand(HWND hWnd, 
                      int id, 
                      HWND hwndCtl, 
                      UINT codeNotify)
{
   FARPROC    fpDlgProc;
   switch(id) {
      case IDM_EXIT:
         PostMessage(hWnd, WM_CLOSE, 0, 0);
         break;
         
      case IDM_SAMPLE:   
         fpDlgProc = 
            MakeProcInstance((FARPROC)SampleDlgProc, 
                              hInst);
         DialogBox(hInst, szDlgName, hWnd, 
                   (DLGPROC)fpDlgProc);
         FreeProcInstance(fpDlgProc);
         break;
   }
}

/****************************************************
 * MainWndProc
 ***************************************************/
LRESULT FAR PASCAL MainWndProc(HWND hWnd, 
                               UINT message, 
                               WPARAM wParam, 
                               LPARAM lParam)
{
   
   switch(message) {
      HANDLE_MSG(hWnd, WM_DESTROY, Sample_OnDestroy);
      HANDLE_MSG(hWnd, WM_CLOSE,   Sample_OnClose);
      HANDLE_MSG(hWnd, WM_COMMAND, Sample_OnCommand);
         
      default:
         return(DefWindowProc(hWnd, message, 
                              wParam, lParam));
   }

}

/****************************************************
 * Start of dialog specific code - note that I'm
 * using the 'new and improved' way to code dialogs
 */
void SampleDlg_OnCommand(HWND hWnd, 
                         int id, 
                         HWND hwndCtl, 
                         UINT codeNotify);
                         
BOOL SampleDlg_OnInitDialog(HWND hWnd, 
                            HWND hwndFocus, 
                            LPARAM lParam);
                         
LRESULT FAR PASCAL SampleWndProc(HWND hWnd, 
                                 UINT message, 
                                 WPARAM wParam, 
                                 LPARAM lParam);

static BOOL  fDefDlgEx  = FALSE; 
/****************************************************
 * SampleDlgProc - the old style dlg proc - this one
 *   is exported and forwards all messages to the
 *   standard window procedure.
 ***************************************************/
BOOL FAR PASCAL _export SampleDlgProc(HWND hWnd, 
                                      UINT message, 
                                      WPARAM wParam, 
                                      LPARAM lParam)
{
   CheckDefDlgRecursion(&fDefDlgEx);
   return(SetDlgMsgResult(hWnd, message, 
     SampleWndProc(hWnd, message, wParam, lParam)));
}

LRESULT FAR PASCAL SampleDefProc(HWND hWnd, 
                                 UINT message, 
                                 WPARAM wParam, 
                                 LPARAM lParam)
{
   return(DefDlgProcEx(hWnd, message, wParam, 
                       lParam, &fDefDlgEx));
}

/****************************************************
 * SampleWndProc - the new dlg proc - no need to 
 *   export this one
 ***************************************************/
LRESULT FAR PASCAL SampleWndProc(HWND hWnd, 
                                 UINT message, 
                                 WPARAM wParam, 
                                 LPARAM lParam)
{

   switch(message) {
      HANDLE_MSG(hWnd, WM_INITDIALOG, 
                       SampleDlg_OnInitDialog);
      HANDLE_MSG(hWnd, WM_COMMAND,    
                       SampleDlg_OnCommand);
         
      default:
         return(SampleDefProc(hWnd, message, 
                              wParam, lParam));
   }
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
/****************************************************
 * SampleDlg_OnInitDialog
 * - Although this dialog only has a few controls,
 *   it's easy to see that even if it had dozens,
 *   the initialization code would not change.
 ***************************************************/
BOOL SampleDlg_OnInitDialog(HWND hWnd, 
                            HWND hwndFocus, 
                            LPARAM lParam)
{
   PopulateDlgControls(hWnd, hInst, "SAMPLE_TOPICS");
   SetTextLimits(hWnd,  hInst, "EDIT_LIMITS");
   ComboBox_SetCurSel(GetDlgItem(hWnd, CBB_TOPICS), 0);
   SampleDlg_OnCommand(hWnd, CBB_TOPICS, 
            GetDlgItem(hWnd, CBB_TOPICS),
            CBN_SELCHANGE);
   CenterWindow(hWnd);
   return(TRUE);
}

/****************************************************
 * SampleDlg_OnCommand
 ***************************************************/
void SampleDlg_OnCommand(HWND hWnd, 
                         int id, 
                         HWND hwndCtl, 
                         UINT codeNotify)
{
   switch(id) {
      case IDOK:
         EndDialog(hWnd, 1);
         break;
         
      case CBB_TOPICS:
         if (codeNotify == CBN_SELCHANGE) {
            HWND hWndInst;
            char szBufr[50], szTopic[50];
            hWndInst = GetDlgItem(hWnd, CBB_INST);
            ComboBox_ResetContent(hWndInst);
            GetWindowText(hwndCtl, szTopic, 
                           sizeof(szTopic));
            wsprintf(szBufr, "INST_%s", (LPSTR)szTopic);
            PopulateDlgControls(hWnd, hInst, szBufr);
            ComboBox_SetCurSel(hWndInst, 0);
         }
         break;
   }
}

