// Revised reboot function that uses keyboard controller

int reboot()
{

__asm   mov bl,0FEh
__asm   xor cx,cx       // 64K timeout
cmdwait:
__asm   in  al,64h      // get status
__asm   jmp next1       // let bus settle
next1:
__asm   jmp next2
next2:
__asm   test al,2
__asm   jz   send
__asm   loop cmdwait
__asm   jmp  error
send:
__asm   mov al,bl
__asm   out 64h,al
__asm   jmp next3       // let bus settle
next3:
__asm   jmp next4
next4:
__asm   xor cx,cx
accept:
__asm   in  al,64h
__asm   jmp next5       // let bus settle
next5:
__asm   jmp next6
next6:
__asm   test al,2
__asm   jz  ok
__asm   loop accept
error:
__asm   mov ax,0        // failed
__asm   jmp retstatus
ok:
__asm   mov ax,1        // succeeded
__asm   jmp retstatus
retstatus:
    ;

}

