Program DualExe;
{**************************************************************************}
{ Windows/DOS application combiner.                                        }
{     This program will combine a Windows and a DOS application together   }
{ to produce a "dual-mode" executable.  The algorithm used here involves   }
{ reading header and image data from two existing applications and         }
{ creating a new application by transfering the program image data from    }
{ from each application and then merging the headers.                      }
{**************************************************************************}
Type

{Old-Style MSDOS header}
         ExeHeader = Record
                 sig   :Word;
                 lpsize:Word;
                 pgcnt :word;
                 ritems:Word;
                 hdrsize:Word;
                 minalloc,Maxalloc:Word;
                 data1  :Longint;
                 chksum :Word;
                 data2  :Array[$14..$17] of byte;
                 rtofs  :Word;
                 ovrnum :word;
                 data3  :Array[$1C..$3b] of byte;
                 winhdr :longint;
                 end;

 {New style Windows header}
        NewHeader = Record
                 sig   :Word;
                 ver   :Word;
                 etofs :Word;
                 etlen :Word;
                 chksum:Longint;
         flags :Word;
         data1 :Array[$0e..$1b] of byte;
                 stcnt :word;
                 data2 :Array[$1e..$21] of byte;
                 stoff :word;
         rtofs :word;
         data3 :Array[$26..$2b] of byte;
                 nroff :Longint;
                 epcnt :Word;
                 ascnt :Word;
         rscnt :Word;
         osflg :Byte;
         exeflg:Byte;
         flofs :Word;
                 end;

     {Segment table records}
         SegTabEntry = Record
                 segoff:word;
                 data1:Array[2..7] of byte;
                 end;

     {Resource table group records}
     ResGrpEntry = Record
         Restype:Word;
         Rescnt : Word;
         data   :Array[4..7] of byte
                 end;

     {Resource table  records}
     ResTabEntry = Record
         ResOfs :Word;
         ResLen :Word;
         data   :Array[4..11] of byte
                 end;

Var
        filename:String;
        SetIcon :Boolean;

    fw,            {Windows application input file}
    fd,            {DOS application input file}
    fn :File;      {New file output handle}
    fwhdr, fdhdr, fnhdr:ExeHeader;  {Old Style headers}
    nh:NewHeader;                   {New Style header for Windows App}
    resgrp:ResGrpEntry;
    resent:ResTabEntry;

    buffer:Array[1..1024*30] of byte; {Transfer buffer}
        i:word;
        achange:Integer;
        dimage:Longint;
        alignment:word;
        shcnt:Word;
        stent:SegTabEntry;
        j:Longint;

Begin

    If Paramcount<>3 then
       begin
       Writeln('DUAL-MODE executable creator. v1/1/93');
       Writeln('Usage:');
       Writeln('    dualexe <dosapp> <WinApp | WinIcon> <NewAppName>');
       exit;
       end;

        SetIcon := False;
        FileName := Paramstr(2);
        I:=1;
        while Length(FileName)>i do
             begin
             FileName[i] := UpCase(FileName[i]);
             Inc(i);
             end;

        If Pos(FileName,'.ICO')>0 then
             Begin
             FileName := 'LAUNCH.EXE';
             SetIcon := True;
             End;

    assign(fd,paramstr(1));
    assign(fw,FileName);
    assign(fn,paramstr(3));

    reset(fw,1);
    reset(fd,1);
    rewrite(fn,1);

        blockread(fw,fwhdr,sizeof(fwhdr));
        blockread(fd,fdhdr,sizeof(fdhdr));

        {Read the windows file New Header}
        seek(fw,fwhdr.winhdr);
        blockread(fw,nh,sizeof(nh));

    {New Old Style header most like DOS program's}
    fnhdr := fdhdr;

        {Calculate the DOS Load Image size}
    dimage := fdhdr.pgcnt*longint(512) + fdhdr.lpsize -
              fdhdr.hdrsize*longint(16)-longint(512);

    fnhdr.rtofs := $40;     {Switch to windows form}
        fnhdr.chksum := 0;      {We're to lazy to re-do checksums.}

        {Calculate Alignment Shift}
    shcnt := nh.ascnt mod 9;
    if shcnt=0 then shcnt := 9;
        alignment := 1 shl shcnt;

        {Where will the new windows header be?}
    fnhdr.winhdr :=
     (((filesize(fd)+ $40 - fdhdr.rtofs + alignment -1) shr shcnt) shl shcnt);

        {Calculate the new header size in paragraphs}
    fnhdr.hdrsize := ($40+fdhdr.ritems*4 + 15) div 16;

        {Calculate new file size parameters}
    fnhdr.lpsize := (fnhdr.hdrsize*16 +
                                             dimage) mod 512;

    fnhdr.pgcnt  := (fnhdr.hdrsize*16 +
                                             dimage+511) div 512;

        {Write the Old-Style header to the new file}
    blockwrite(fn,fnhdr,$40);

        {Write the DOS relocation table}
        seek(fd,fdhdr.rtofs);
        If fdhdr.ritems>0 then
            begin
          blockread(fd,buffer,fdhdr.ritems*4);
      blockwrite(fn,buffer,fdhdr.ritems*4);
            end;

        {Write up to the next paragraph}
    i := filepos(fn);
        fillchar(buffer,sizeof(buffer),char(0));
        if i mod 16 <> 0 then
       blockwrite(fn,buffer,16-(i mod 16));

    {Transfer the entire DOS Image}
    seek(fd,fdhdr.hdrsize*16);
    repeat
        blockread(fd,buffer,sizeof(buffer),i);
        if (I>0) then blockwrite(fn,buffer,i);
    until (i<>sizeof(buffer));

    {Fill out the last page till the Windows Header}
    if fnhdr.winhdr-filepos(fn)>0 then
            begin
          fillchar(buffer,sizeof(buffer),char(0));
      blockwrite(fn,buffer,fnhdr.winhdr-filepos(fn));
            end;

        {Compute the adjustment for segment oriented offsets}
    if fnhdr.winhdr>=fwhdr.winhdr
      then achange := (fnhdr.winhdr - fwhdr.winhdr + alignment -1) shr shcnt
      else achange := - ((fwhdr.winhdr - fnhdr.winhdr + alignment -1) shr shcnt);

    {Adjust the fast-load area if used}
    if (nh.exeflg and 8) > 0 then inc(nh.flofs,achange);

        {Adjust the new header name table offset}
    nh.nroff := nh.nroff - fwhdr.winhdr + fnhdr.winhdr;

        {Blank the checksum}
        nh.chksum := 0;

        {Insert the entire windows application header and image}
        seek(fw,fwhdr.winhdr+sizeof(nh));
    blockwrite(fn,nh,sizeof(nh));
        repeat
                blockread(fw,buffer,sizeof(buffer),i);
        if (i>0) then blockwrite(fn,buffer,i);
        until (i<>sizeof(buffer));


        {Go Back and fix segment table offsets}
    seek(fn,fnhdr.winhdr+nh.stoff);
        seek(fw,fwhdr.winhdr+nh.stoff);

        while nh.stcnt>0 do
             begin
             blockread(fw,stent,sizeof(stent));
             if (stent.segoff<>0) then inc(stent.segoff,achange);
       blockwrite(fn,stent,sizeof(stent));
             dec(nh.stcnt);
             end;

   {Now Doctor up the resource tables offsets}
    seek(fw,fwhdr.winhdr+nh.rtofs);
    seek(fn,fnhdr.winhdr+nh.rtofs+2);
    blockread(fw,shcnt,2);
        alignment := 1 shl shcnt;

    if fnhdr.winhdr>=fwhdr.winhdr
      then achange :=   (fnhdr.winhdr - fwhdr.winhdr + alignment -1) shr shcnt
      else achange := - ((fwhdr.winhdr - fnhdr.winhdr + alignment -1) shr shcnt);

    repeat
       blockread(fn,resgrp,sizeof(resgrp));
       blockread(fw,resgrp,sizeof(resgrp));

       while (resgrp.restype<>0) and (resgrp.rescnt>0) do
          begin
          blockread(fw,resent,sizeof(resent));
          inc(resent.resofs,achange);
          blockwrite(fn,resent,sizeof(resent));
          dec(resgrp.rescnt);
          end;

    until (resgrp.restype=0);


    {Done so close everyone up}
    close(fn);
        close(fd);
        close(fw);

End.
