/**************************************************
* Title:  Graying Rectangular Regions in Windows
*
* This set of functions implements the "graying"
* of rectangular regions in Windows.  "Graying" is
* accomplished by overlaying the region with a
* checkerboard grid of dots.  Every other dot's
* color is the same as the device context's current
* background color.
*
* Copyright (C) 1993, Cain International Corporation.
* All rights reserved.
*
* Author:  Gregory C. Peters
**************************************************/
#include <windows.h>

/**************************************************
*           Defines and Data
**************************************************/

/* these macros assume r is pointer */
#define RWIDTH(r)  ((r)->right  - (r)->left)
#define RHEIGHT(r) ((r)->bottom - (r)->top )

/* PatBlt code to do a bitwise OR between brush
 * and the destination bitmap.
 */
#define GRAYCODE 0xFA0089

/* contains the checkerboard brush */
static HBRUSH grayBrush = NULL;

/**************************************************
*              Functions
**************************************************/
/* Initializes the grayBrush */
void grayInit(HINSTANCE inst)
{
   grayBrush=CreatePatternBrush(LoadBitmap(inst,"grayBmp"));
}

/* Deletes the grayBrush */
void grayExit(HINSTANCE inst)
{
   if(grayBrush)
   {  DeleteObject(grayBrush);
      grayBrush = NULL;
   }
}

/* Grays the specified rectangular region */
void grayRect(HDC hdc, LPRECT r)
{
   if(hdc && r && grayBrush)
   {  HBRUSH oldBrush = SelectObject(hdc, grayBrush);
      PatBlt(hdc,r->left,r->top, RWIDTH(r),RHEIGHT(r),GRAYCODE);
      SelectObject(hdc, oldBrush);
    }
}
        