/* ------------------------------------------------
    TestGray.c -- Program to test the graying
    functions in gray.c.  All it does is display
    a modeless dialog box with sample controls that
    are shown in normal states, disabled states,
    and "grayed" states.
    
    The modeless dialog box is used in lieu of a
    standard main window in order to minimize the
    code associated with the test program.
    
    This test program is modelled after Petzold's
    Hexcalc program in "Programming Windows".
    
    (c) Gregory C. Peters, 1994
    All Rights Reserved
--------------------------------------------------*/

#include <windows.h>
#include "resource.h"
#include "gray.h"

// window function for the modeless dialog.
long CALLBACK grayProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

int PASCAL WinMain(HANDLE hInst, HANDLE hPrevInst, LPSTR cmdLine, int nCmdShow)
{
    HWND        hWnd;       // handle to the modeless dialog
    WNDCLASS    wc;         // used to register the GrayTest class
    MSG         msg;
        
    if(!hPrevInst)
    {   // set up the window class structure
        wc.style            = CS_HREDRAW|CS_VREDRAW;
        wc.lpfnWndProc      = grayProc;
        wc.cbClsExtra       = 0;
        wc.cbWndExtra       = DLGWINDOWEXTRA;
        wc.hInstance        = hInst;
        wc.hIcon            = LoadIcon(NULL, IDI_APPLICATION);
        wc.hCursor          = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground    = COLOR_WINDOW + 1;
        wc.lpszMenuName     = NULL;
        wc.lpszClassName    = "GrayTest";
        
        RegisterClass(&wc);
    }
        
    grayInit(hInst);    // initialize the graying functions

    // create and show the modeless dialog
    hWnd = CreateDialog(hInst, "GrayTest", 0, NULL);
    ShowWindow(hWnd, SW_SHOW);
        
    // do nothing message loop
    while(GetMessage(&msg, NULL, 0, 0))
    {   TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
        
    grayExit(hInst);    // clean up in the graying functions
    return(msg.wParam);
}

//  grayProc window function
long CALLBACK grayProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch(message)
    {
        // Each control that has an id of IDGRAY_WHITE is "grayed"
        // with a pattern of white dots.  Each control that has an
        // id of IDGRAY_GRAY is "grayed" with a patten of gray dots.
        //
        // To minimize the associated code, the graying is done by
        // drawing into a DISPLAY device context directly over the
        // relevant controls.  (Otherwise, would have to subclass
        // the controls themselves to modify how they are painted. 
        case WM_PAINT:
        {   HDC hdc, hdcDisplay;
            PAINTSTRUCT ps;
            HWND child;
            RECT rect;
            
            hdc = BeginPaint(hWnd, &ps);
            hdcDisplay = CreateDC("DISPLAY", NULL, NULL, NULL);

            for(child = GetTopWindow(hWnd); child; child = GetNextWindow(child, GW_HWNDNEXT))
            {   if(GetWindowWord(child, GWW_ID) == IDGRAY_WHITE)
                {   // make sure the control is drawn first,
                    InvalidateRect(child, NULL, FALSE);
                    UpdateWindow(child);
                    
                    // Then gray the control with the "white" color                 
                    SetBkColor(hdcDisplay, GetSysColor(COLOR_WINDOW));
                    GetWindowRect(child, &rect);
                    grayRect(hdcDisplay, &rect);
                }
                else if(GetWindowWord(child, GWW_ID) == IDGRAY_GRAY)
                {   // make sure the control is drawn first,
                    InvalidateRect(child, NULL, FALSE);
                    UpdateWindow(child);

                    // Then gray the control with the "gray" color                  
                    SetBkColor(hdcDisplay, GetSysColor(COLOR_BTNFACE));
                    GetWindowRect(child, &rect);
                    grayRect(hdcDisplay, &rect);
                }
            }
                            
            DeleteDC(hdcDisplay);
            EndPaint(hWnd, &ps);
            break;
        }
        
        // make sure that closing the dialog exits the application
        case WM_DESTROY:
            PostQuitMessage(0);
            return(0);
    }
    
    return(DefWindowProc(hWnd, message, wParam, lParam));
}
        