
; STEALTH.ASM
TITLE STEALTH VxD, steals requests from DOS device driver

	.386p                  ;allows priviledged instructions
	.XLIST
	INCLUDE VMM.Inc
	INCLUDE Debug.Inc
	INCLUDE Stealth.Inc
	.LIST

;**--------------------------------------------------------
; Virtual Device Declaration - Name, major, minor versions,
;   Control proc, ID, init order, V86 and protect API procs
;--------------------------------------------------------**
Declare_Virtual_Device STEALTH, bMajorVer, bMinorVer,     \
   STEALTH_Control, STEALTH_Device_ID,                    \
   Undefined_Init_Order,, STEALTH_ProtectAPI

;==========================================================
VxD_IDATA_SEG   ;start initialization data, discarded after
VxD_IDATA_ENDS  ;end of initialization data, discard after
;==========================================================
VxD_DATA_SEG                      ;beginning of normal data
VxD_DATA_ENDS                     ;end of normal data
;==========================================================
VxD_LOCKED_DATA_SEG          ;beginning of page locked data
;==========================================================

   Next_Int21_CS     dd	  ?
   Next_Int21_EIP    dd	  ?
   Current_VM        dd   -1
   Current_PSP       dw   -1
      ALIGN DWORD 
   Handle            dw   -1
   MaxRead           dw   -1
   DeviceName        db   "REGDEVNM",0

;==========================================================
VxD_LOCKED_DATA_ENDS               ;end of page locked data
;==========================================================
VxD_ICODE_SEG      ;start of initialization code, discarded
;==========================================================

;**--------------------------------------------------------
;  STEALTH_DeviceInit - called at system boot,do init tasks
;  ENTRY: EBX = Sys VM handle, EXIT: clc/stc to load/abort
;--------------------------------------------------------**
BeginProc STEALTH_DeviceInit
      ;do the Virtual-86 mode hook of Int 21h
   mov     eax, 21h           
   mov     esi, OFFSET32 STEALTH_V86_Int21Handler
   VMMCall Hook_V86_Int_Chain 
      ;save protected-mode vector for int 21h
   mov     eax, 21h
   VMMcall Get_PM_Int_Vector
   mov     [Next_Int21_CS], ecx
   mov     [Next_Int21_EIP], edx
      ;do the protected-mode hook of Int 21h
   mov     esi, OFFSET32 STEALTH_PM_Int21Handler
   xor     edx, edx
   VMMcall Allocate_PM_Call_Back
   jc      SHORT AbortLoad

   movzx   edx, ax
   mov     ecx, eax
   shr     ecx, 16
   mov     eax, 21h
   VMMcall Set_PM_Int_Vector
   clc                           ;no error - load VxD 
   ret

AbortLoad:     ;jump here if conditions warrant not loading
   stc                           ;fail load
   ret
EndProc STEALTH_DeviceInit

;==========================================================
VxD_ICODE_ENDS       ;end of initialization code, discarded
;==========================================================
VxD_CODE_SEG            ;beginning of standard code segment
;==========================================================

;**--------------------------------------------------------
;  STEALTH_ProtectAPI - main dispatch routine for PM apps
;  EAX: API id to execute, jump to corresponding routine.
;--------------------------------------------------------**
BeginProc STEALTH_ProtectAPI, Public
   cmp     [ebp].Client_AX, MAX_PROTECT_APIS
   jg      SHORT Unknown_API

   cmp     [ebp].Client_AX, PROTECT_API_VERSION
   je      short ApiVersion
      ;implement open, write, read, close, enable, disable
   jmp     short Unknown_API

ApiVersion:
   mov     [ebp].Client_Flags, 0
   mov     [ebp].Client_AX, wVersion
   mov     ax, MaxRead
   mov     [ebp].Client_BX, ax
   ret

Unknown_API:
   mov     [ebp].Client_Flags, CF_Mask
   ret
EndProc STEALTH_ProtectAPI

;**--------------------------------------------------------
;  STEALTH_Serv_Version - VxD service, called by other VxDs
;--------------------------------------------------------**
BeginProc STEALTH_Serv_Version, Service
   mov     eax, wVersion
   movzx   ebx, MaxRead
   clc
   ret
EndProc STEALTH_Serv_Version

;==========================================================
VxD_CODE_ENDS                 ;end of standard code segment
;==========================================================
VxD_LOCKED_CODE_SEG          ;beginning of page locked code
;==========================================================

;**--------------------------------------------------------
;  STEALTH_Control - handles messages.  Must be LOCKED.
;  ENTRY:  EAX = Message number, EBX = VM Handle
;--------------------------------------------------------**
BeginProc STEALTH_Control
	Control_Dispatch Device_Init, STEALTH_DeviceInit
	clc
	ret
EndProc STEALTH_Control

;**--------------------------------------------------------
;  STEALTH_V86_Int21Handler - V86 interrupt 21 handler
;  EXIT: Clear carry flag to prevent system from passing 
;     interrupt to next hook, Set carry to pass it on.
;--------------------------------------------------------**
BeginProc STEALTH_V86_Int21Handler
   cmp     [ebp.Client_AH], 3Dh      ;DOS open commmand?
   je      SHORT DosOpen
      ;if not handle to my device, don't need to continue
   mov     bx, Handle
   cmp     [ebp.Client_BX], bx
   jne     SHORT V86_PassOn

   cmp     [ebp.Client_AH], 3Eh      ;DOS close command?
   je      SHORT DosClose

   jmp     SHORT V86_PassOn          ;Just pass others on

DosClose:
   call    CompareCurrentTask        ;check if same task
   cmp     ecx, TRUE                 ;Is is same PSP and VM?
   jne     SHORT V86_PassOn          ;No - so pass on.

   mov     Handle, -1                ;Yes - so reset values.
   mov     Current_VM, -1
   mov     Current_PSP, -1
   jmp     SHORT V86_PassOn          ;then pass on.

DosOpen:
   mov     ax, (Client_DS SHL 8) + Client_DX
   VMMcall Map_Flat                ;filename string in eax
      ;compare filename with device driver name
   cld                             ;forward compare
   mov     ecx, SIZE DeviceName
   mov     esi, OFFSET32 DeviceName
   mov     edi, eax
   repe    cmpsb
   jnz     SHORT V86_PassOn        ;not device driver name
      ;String matched, set callback on completion, pass on.
   xor     eax, eax             ;timeout in milliseconds
   xor     edx, edx             ;reference data ptr
   mov     esi, OFFSET32 STEALTH_OpenReturn       ;callback
   VMMCall Call_When_VM_Returns
   stc                          ;pass interrupt to next hook
   ret

V86_PassOn:
   stc         ;set carry flag, pass interrupt to next hook
   ret

V86_DontPassOn:
   clc         ;clear carry indicates success, don't pass on
   ret
EndProc STEALTH_V86_Int21Handler

;**--------------------------------------------------------
;  STEALTH_PM_Int21Handler - Protect mode int 21 handler
;  EXIT: Simulated far jump to pass on, else simulate iret
;--------------------------------------------------------**
BeginProc STEALTH_PM_Int21Handler
      ;if no handle open now, then don't need to continue
   cmp     Handle, -1
   je      SHORT PM_PassOn
      ;if not handle to my device, don't need to continue
   mov     bx, Handle
   cmp     [ebp.Client_BX], bx
   jne     SHORT PM_PassOn

   cmp     [ebp.Client_AH], 3Fh    ;DOS read command?
   je      SHORT DosRead

   cmp     [ebp.Client_AH], 40h    ;DOS write command?
   je      SHORT DosWrite

   jmp     SHORT PM_PassOn         ;not interested.

DosRead:
   call    CompareCurrentTask      ;Compare task info
   cmp     ecx, TRUE               ;Is is same PSP and VM?
   jne     SHORT PM_PassOn         ;No.

   mov     ax, (Client_DS SHL 8) + Client_DX 
   VMMcall Map_Flat                ;buffer address in EAX
   movzx   ecx, [ebp.Client_CX]    ;buffer length in ECX
   mov     MaxRead, cx             ;Save read size request
   call    StealthRead             ;StealthRead sets count
   mov     [ebp.Client_AX], ax     ;DOS expects count in ax
   jmp     SHORT PM_DontPassOn     ;no one else reads!

DosWrite:
   call    CompareCurrentTask      ;Compare task info
   cmp     ecx, TRUE               ;Is is same PSP and VM?
   jne     SHORT PM_PassOn         ;No.

   mov     ax, (Client_DS SHL 8) + Client_DX 
   VMMcall Map_Flat                ;buffer address in EAX
   movzx   ecx, [ebp.Client_CX]    ;buffer length in ECX
   call    StealthWrite            ;StealthWrite sets count
   mov     [ebp.Client_AX], ax     ;DOS expects count in ax
   jmp     SHORT PM_DontPassOn     ;no one else writes!

PM_PassOn:
   mov     ecx, [Next_Int21_CS]
   mov     edx, [Next_Int21_EIP]
   VMMjmp  Simulate_Far_Jmp        ;Chain to next vector.
   ret

PM_DontPassOn:
   VMMcall Simulate_Iret           ;Eat the interrupt.
   ret
EndProc STEALTH_PM_Int21Handler

;**--------------------------------------------------------
;  STEALTH_OpenReturn - On return from open command, save
;    file handle, current PSP segment, current VM handle.
;--------------------------------------------------------**
BeginProc STEALTH_OpenReturn
      ;client's carry flag indicates if file open succeeded
   test    [ebp.Client_EFLAGS], CF_Mask       ;Success?
   jnz     SHORT OpenFailed                   ;No.

   pushad                           ;save VxD's registers
   VMMCall Get_Cur_VM_Handle        ;EBX=current VM handle
   mov     Current_VM, ebx          ;Save VM of this task
   call    GetCurrentPSP            ;EBX=current PSP
   mov     Current_PSP, bx          ;Save PSP of this task
   mov     ax, [ebp.Client_AX]      ;client's AX=file handle
   mov     Handle, ax               ;save the file handle
   popad                            ;restore VxD's registers
	
OpenFailed:
   ret
EndProc STEALTH_OpenReturn

;**--------------------------------------------------------
;  CompareCurrentTask - Compare current VM and PSP with the
;      VM and PSP of the task that opened the device.
;  EXIT: ECX = TRUE if match, FALSE is no match.
;--------------------------------------------------------**
BeginProc CompareCurrentTask
   pushad                        ;save VxD's registers
   VMMCall Get_Cur_VM_Handle     ;EBX=current VM handle
   cmp     ebx, Current_VM       ;Same VM that opened device?
   jne     SHORT NoMatch         ;No.

   call    GetCurrentPSP         ;EBX=current PSP
   cmp     bx, Current_PSP       ;Same PSP that opened device?
   jne     SHORT NoMatch         ;No.
   popad                         ;restore VxD's registers
   mov     ecx, TRUE             ;Same task!
   ret

NoMatch:
   popad                         ;restore VxD's registers
   mov     ecx, FALSE            ;Different task!
   ret
EndProc CompareCurrentTask

;**--------------------------------------------------------
;  GetCurrentPSP - Get PSP of the currently executing task.
;  EXIT:  EBX = PSP of current task.
;--------------------------------------------------------**
BeginProc GetCurrentPSP
   Push_Client_State               ;save current VM's state
   VMMCall Begin_Nest_Exec         ;begin nested execution
   mov     [ebp.Client_AH], 62h    ;Client_AH = funct (Get PSP)
   mov     eax, 21h                ;EAX = interrupt number
   VMMCall Exec_Int                ;current VM calls MS-DOS
   VMMCall End_Nest_Exec           ;end nested execution
      ;Int 21 function 62 (Get PSP) returns the PSP segment 
   movzx   ebx, [ebp.Client_BX]    ;PSP segment in client BX
   Pop_Client_State                ;restore current VM's state
   ret
EndProc GetCurrentPSP

;**--------------------------------------------------------
;  StealthRead - read using your own custom I/O protocol.
;  ENTRY: EAX = data, ECX = length. EXIT: EAX = length.
;--------------------------------------------------------**
BeginProc StealthRead
   Trace_Out   "Do a real READ already!"
   mov     eax, ecx            ;caller expects count in EAX
   ret

ReadError:                     ;if error reading, jump here
   mov     eax, DOS_ERROR_READ            ;DOS read error
   mov     [ebp.Client_Flags], CF_Mask    ;error, set carry
   ret
EndProc StealthRead

;**--------------------------------------------------------
;  StealthWrite - write using your own custom I/O protocol.
;  ENTRY: EAX = data, ECX = length. EXIT: EAX = length.
;--------------------------------------------------------**
BeginProc StealthWrite
   Trace_Out   "Do a real WRITE already!"
   mov     eax, ecx            ;caller expects count in EAX
   ret

WriteError:                    ;if error reading, jump here
   mov     eax, DOS_ERROR_WRITE           ;DOS write error
   mov     [ebp.Client_Flags], CF_Mask    ;error, set carry
   ret
EndProc StealthWrite

;==========================================================
VxD_LOCKED_CODE_ENDS               ;end of page locked code
;==========================================================
VxD_REAL_INIT_SEG            ;Real Mode Initialization code
;==========================================================

;**--------------------------------------------------------
;  STEALTH_Real_Init - Real mode init. Check duplicate load.
;  ENTRY:  AX = VMM Version, BX = Load Flags.
;--------------------------------------------------------**
BeginProc STEALTH_Real_Init
   test    bx, Duplicate_Device_ID    ;Already loaded?
   jnz     SHORT duplicate            ;Yes.

   xor     bx, bx                 ;exclusion table (no)
   xor     si, si                 ;instance data table (no)
   xor     edx, edx               ;reference data (no)
   mov     ax, Device_Load_Ok     ;successful load
   ret

duplicate:                         ;abort without message
   mov     ax, Abort_Device_Load + No_Fail_Message
   ret
EndProc STEALTH_Real_Init

;==========================================================
VxD_REAL_INIT_ENDS    ;end of Real Mode Initialization Code
;==========================================================
	END


