/* TestVxD.C */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "testvxd.h"

/*---------- public prototypes ----------*/
LRESULT CALLBACK MainWndProc ( HWND, UINT, WPARAM, LPARAM);
void far pascal DOS3Call (void);

/*--------- private prototypes ----------*/
int StealthOpen(void);
int StealthWrite(int handle);
int StealthRead(int handle);
int StealthClose(int handle);
int CallVxD(int iFunction);
int (far *vxdproc)(int);

/*---------- Global variables -----------*/
char lpFilename[256] = "REGDEVNM";
char lpBuffer[350];
int hScanner=0;
char szAppName[] = "TestVxD";


/**--------------------------------------------------------------------**/
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine,
	int nCmdShow)
{
    HWND    hwnd;
    MSG     msg;
    WNDCLASS    wndclass;

    if (!hPrevInstance)
    {
        wndclass.style          = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc    = MainWndProc;
        wndclass.cbClsExtra     = 0;
        wndclass.cbWndExtra     = 0;
        wndclass.hInstance      = hInstance;
        wndclass.hIcon          = LoadIcon (NULL, IDI_APPLICATION) ;
        wndclass.hCursor        = LoadCursor ( NULL, IDC_ARROW );
        wndclass.hbrBackground  = GetStockObject(WHITE_BRUSH);
        wndclass.lpszMenuName   = szAppName;
        wndclass.lpszClassName  = szAppName;

        RegisterClass (&wndclass);
    }
    hwnd = CreateWindow (szAppName, szAppName,
                        WS_OVERLAPPEDWINDOW | WS_HSCROLL | WS_VSCROLL,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        NULL, NULL, hInstance, NULL);

    ShowWindow (hwnd, nCmdShow);
    UpdateWindow (hwnd);

    while (GetMessage (&msg, NULL, 0, 0))
    {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }
    return msg.wParam;
} /* WinMain */


/**--------------------------------------------------------------------**/
LRESULT CALLBACK MainWndProc (HWND hwnd, UINT message, WPARAM wParam, 
	LPARAM lParam)
{
    static HANDLE hInst;
    int status;

    switch (message)
    {
		case WM_COMMAND:
		    switch (wParam)
	    	{
				case IDM_OPEN:
					/* don't save to hScanner unless good handle, 
						otherwise can't close! */
					if ((status = StealthOpen()) <= 0)
						MessageBox(hwnd, (LPSTR)"Open Failed", "Test", MB_OK);
					else hScanner = status;
					break;

				case IDM_WRITE:
					StealthWrite(hScanner);
					break;

				case IDM_READ:
					StealthRead(hScanner);
					break;

				case IDM_CLOSE:
					StealthClose(hScanner);
					break;

				case IDM_VERSION:
					CallVxD(0);
					break;

			    default:
					return 0;
		    }
			break;

	    case WM_DESTROY:
    	    PostQuitMessage(0);
        	return 0;
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
}


/**---------------------------------------------------------------**/
int StealthOpen(void)
{
	int handle;

	if ((handle = _lopen((LPSTR)"REGDEVNM", OF_READWRITE)) != -1)
	{
	_asm {
		mov		ax, 0x4400		// get the current device information
		mov		bx, handle
		call	DOS3Call
		jc		xit

		test	dx, 0x80		// make sure that this is a character device
		jz		xit

		xor		dh, dh			// set the raw mode bit (bit 5)
		or		dl, 0x20
		mov		ax, 0x4401
		call	DOS3Call
		jc		xit
		xor		ax, ax
	}
xit:
	;
	}

	return handle;
} /* StealthOpen */


/**---------------------------------------------------------------**/
int StealthRead(int handle)
{
	static char lpData[128];
	int bytes=0;

	if (handle <= 0) return FALSE;

	/* not really passing a buffer 32K big, but just pretend! */
	bytes = _lread(handle, (LPSTR)lpData, 32000);

	wsprintf(lpBuffer, (LPSTR)"Bytes read = %d", bytes);
	MessageBox(NULL, lpBuffer, (LPSTR)"StealthRead", MB_OK);

	return bytes;
} /* StealthRead */


/**---------------------------------------------------------------**/
int StealthWrite(int handle)
{
	static char lpData[128];
	int len=0, bytes=0;

	if (handle <= 0) return FALSE;

	lstrcpy(lpData, (LPSTR)"This is a test string to write");
	len = lstrlen((LPSTR)"This is a test string to write");

	bytes = _lwrite(handle, (LPSTR)lpData, len);

	wsprintf(lpBuffer, (LPSTR)"Bytes written = %d", bytes);
	MessageBox(NULL, lpBuffer, (LPSTR)"StealthWrite", MB_OK);

	return bytes;	
} /* StealthWrite */


/**---------------------------------------------------------------**/
int StealthClose(int handle)
{
	if (handle <= 0) return FALSE;

	return _lclose(handle);
} /* StealthClose */


/**--------------------------------------------------------------------**/
int CallVxD(int iFunction)
{
	int iVersion, iMaxRead;

	/* Get the address of the VxD's API entry-point */
	_asm {
		push di
		push es
		mov ax, 1684h
		mov bx, 2999h
		xor	di, di
		mov es, di
		int 2Fh
		mov word ptr vxdproc, di
		mov word ptr vxdproc+2, es
		pop es
		pop di
	}

	if (vxdproc == 0) 
	{
		MessageBox(NULL, (LPSTR)"No Stealth VxD!", (LPSTR)"Stealth", MB_OK);
		return FALSE;
	}

	/* now call the version number entry-point */
	_asm {
		push di
		push es
		mov	ax, iFunction
		call vxdproc
		mov iVersion, ax
		mov iMaxRead, bx
		pop es
		pop di
	}

	wsprintf(lpBuffer, (LPSTR)"Version = %d, MaxRead = %d", 
		iVersion, iMaxRead);
	MessageBox(NULL, lpBuffer, (LPSTR)"Stealth", MB_OK);

	return TRUE;
} /* CallVxD */
