/*
 *  viwep.c - Vendor-independent WEP.
 */

#include <windows.h>

#if defined(_MSC_VER)

    // Note: .def file must also list WEP in the EXPORTS section
    // in order to get Microsoft's WEP linked in and exported.
    // Borland's design is nicer, not requiring you to
    // maintain a .def file just to get static destructors called.
    extern "C" {

        int CALLBACK _WEP(int /*ExitCode*/)
            {
            OutputDebugString("Microsoft WEP() invoked\r\n");
            return 1;
            }
        };

#elif defined(__BORLANDC__)

    // Borland does it right, except for very nasty 4.0 EH bug!
    int CALLBACK WEP(int /*ExitCode*/)
        {
        OutputDebugString("Borland WEP() invoked\r\n");

        return 1;
        }

#elif defined(__SC__)

    // hard to believe, but Symantec C++ apparently does not
    // supply a WEP or call static destructors for you!
    // Here's my undocumented workaround...

    extern "C" {
        #include <process.h>

        int CALLBACK __export WEP(int /*ExitCode*/)
            {
            OutputDebugString("Symantec WEP() invoked");

            // do work that Symantec runtime should have
            _dodtors();
            return 1;
            }
        };

#elif (1)
    
    #error "UNKNOWN COMPILER TYPE"

#endif


