// wuierror.c - Translate error message into English
// Copyright (c) 1993 by Ron Burk

#include <string.h>
#include <stdio.h>
#include "wuistd.h"
#include "wuierror.h"

char    WUIMAN_LastError[512];

static const char *Errors[] =
    {
    "WUIMAN_ERR_BAD_PATH: The path was syntactically incorrect.",
    "WUIMAN_ERR_BAD_ATTR: This object does not support that attribute.",
    "WUIMAN_ERR_NOT_INITIALIZED: You attempted to access an object but WuiMan is not initialized.",
    "WUIMAN_ERR_DATABASE_INIT: This WuiMan database could not be initialized.",
    "WUIMAN_ERR_NULL_ATTR: The requested attribute is NULL.",
    "WUIMAN_ERR_ATTR_TOO_LONG: The requested attribute exceeds the buffer supplied.",
    "WUIMAN_ERR_BAD_ATTR_ARG: An attribute argument has an illegal value or type.",
    "WUIMAN_ERR_NO_SUCH_OBJECT: Some object name in the path did not exist.",
    "WUIMAN_ERR_SET_INT_OVERFLOW: Too large a number to assign to an integer attribute.",
    "WUIMAN_ERR_SET_LONG_OVERFLOW: Too large a number to assign to a long attribute.",
    "WUIMAN_ERR_SET_BAD_INTEGRAL: Not a legal integral number.",
    "WUIMAN_ERR_WRITE_FAILED: Could not write to the WUIMAN database.",
    "WUIMAN_ERR_NEW_FAILED: The new operator failed!",
    "WUIMAN_ERR_CANT_INIT_ATTR: Could not initialize attribute when loading database.",
    "WUIMAN_ERR_CANT_PARSE_ATTR: Could not parse this attribute.",
    };

#define NERRSTRINGS (sizeof(Errors)/sizeof(const char *))

void    WUIMAN_Error(long Error, char *Output)
    {
    char Unknown[128];
    sprintf(Unknown, "WUIMAN: %ld (LONG_MIN + %ld) Unknown error.",
        Error, Error-LONG_MIN);
    const char *Message = Unknown;
    if(Error < (LONG_MIN + NERRSTRINGS))
        Message = Errors[Error-LONG_MIN];
    strcpy(Output, Message);
    }

