// wuierror.h - WUIMAN error code definitions.
// Copyright (c) 1993 by Ron Burk

#ifndef WUIERROR_H
#define WUIERROR_H

#include <limits.h>

// The path was syntactically incorrect
const   long    WUIMAN_ERR_BAD_PATH         = (LONG_MIN+0);
// Target does not support the specified attribute
const   long    WUIMAN_ERR_BAD_ATTR         = (LONG_MIN+1);
// WUIMAN is not initialized
const   long    WUIMAN_ERR_NOT_INITIALIZED  = (LONG_MIN+2);
// Could not initialize database
const   long    WUIMAN_ERR_DATABASE_INIT    = (LONG_MIN+3);
// Requested attribute is NULL
const   long    WUIMAN_ERR_NULL_ATTR        = (LONG_MIN+4);
// Requested attribute is longer than supplied buffer
const   long    WUIMAN_ERR_ATTR_TOO_LONG    = (LONG_MIN+5);
// Bad attribute argument
const   long    WUIMAN_ERR_BAD_ATTR_ARG     = (LONG_MIN+6);
// Some object name in the path did not exist
const   long    WUIMAN_ERR_NO_SUCH_OBJECT   = (LONG_MIN+7);
// Attempt to overflow integer attribute
const   long    WUIMAN_ERR_SET_INT_OVERFLOW = (LONG_MIN+8);
// Attempt to overflow long attribute
const   long    WUIMAN_ERR_SET_LONG_OVERFLOW= (LONG_MIN+9);
// Illegal integral value
const   long    WUIMAN_ERR_SET_BAD_INTEGRAL = (LONG_MIN+10);
// Could not write to database
const   long    WUIMAN_ERR_WRITE_FAILED     = (LONG_MIN+11);
// new operator failed
const   long    WUIMAN_ERR_NEW_FAILED       = (LONG_MIN+12);
// Illegal value when loading from database
const   long    WUIMAN_ERR_CANT_INIT_ATTR   = (LONG_MIN+13);
// Could not parse attribute or its arguments
const   long    WUIMAN_ERR_CANT_PARSE_ATTR  = (LONG_MIN+14);

// So adding new errors may not immediately
// break existing code.
const   long    WUIMAN_ERR_SLOP         = 100;

// use "if(Error < WUIMAN_ERRORS)" to detect
// an error.
const   long    WUIMAN_ERRORS           = (LONG_MIN+6
                                          +WUIMAN_ERR_SLOP);

void    WUIMAN_Error(long Error, char *Output);
extern char WUIMAN_LastError[512];

#endif
