// wuistd.h - all WUIMAN source files include this header.
// Copyright (c) 1993 by Ron Burk

#ifndef WUISTD_H
#define WUISTD_H

#include <stdlib.h>

#undef ASSERT
#undef ASSERT2

extern void    AssertionFailure(char *File, int LineNumber,
                                                char *Text);

#ifdef NDEBUG
    #define ASSERT(e)   ((void)0)
    #define ASSERT2(e)  (e)
#else
    #define ASSERT(e)   ((e) ? (void)0 : \
        AssertionFailure(__FILE__, __LINE__, #e))
    #define ASSERT2     ASSERT
#endif

#define MEMBERASSERT()     (ASSERT(this != 0))

// StringClone - allocate space for and duplicate a string.
char    *StringClone(const char *Input);

// TCharBuffer - for heap character buffers too big for stack
class TCharBuffer
    {
public:
    TCharBuffer(size_t BufferSize);
    TCharBuffer(const TCharBuffer &Other);
    const TCharBuffer &operator=(const TCharBuffer &Other);
   ~TCharBuffer();
    operator char *();
//    operator char *() const;
    size_t  Size() const;
private:
    char    *Buffer;
    size_t  Size_;
    };

inline
TCharBuffer::operator char *()
    {   MEMBERASSERT();
    return Buffer;
    }

#if 0
inline
TCharBuffer::operator char *() const
    {   MEMBERASSERT();
    return Buffer;
    }
#endif

inline
size_t  TCharBuffer::Size() const
    {   MEMBERASSERT();
    return Size_;
    }


// provide separate debugging output
void    DebugPrintf(char Flag, const char *Format, ...);
void    DebugPrintf(const char *Format, ...);

#define DEBUG_MORE DebugPrintf
#define DEBUG_TRACE DebugPrintf('t', \
    "%-12s %04d ", __FILE__, __LINE__), DebugPrintf
#define DEBUG_WARNING DebugPrintf('w', \
    "%-12s %04d ", __FILE__, __LINE__), DebugPrintf
#define DEBUG_ERROR DebugPrintf('e', \
    "%-12s %04d ", __FILE__, __LINE__), DebugPrintf
#define DEBUG_FATAL DebugPrintf('f', \
    "%-12s %04d ", __FILE__, __LINE__), DebugPrintf

#endif
