/*****************************************************/
/* keymap.h                                          */
/* -- Interface to keyboard remapper DLL.            */
/*****************************************************/
typedef struct
    {
    UINT vkc;          /* Virtual key code. */
    UINT wExt;         /* Extension/scan bits. */
    } KEY, far *LPKEY; /* A KEY specifier. */

typedef struct
	{
    KEY  keyFrom; /* Source key. */
    KEY  keyTo;   /* Destination key. */
    } KRI, FAR *LPKRI; /* Key code Remap Info. */

BOOL WINAPI __export FSetKri(LPKRI lpkri);
BOOL WINAPI __export FGetKri(LPKRI lpkri);
BOOL WINAPI __export FNextKri(LPKRI lpkri, LPKEY lpkey);
BOOL WINAPI __export FRemoveKey(LPKEY lpkey);
BOOL WINAPI __export FMapEnable(BOOL fEnable);
void WINAPI __export ResetMap(void);

/* Set a key from an lParam. */
#define GetKeyMsg(key, wParam, lParam)                \
  ((key).vkc = (UINT)wParam,                          \
  (key).wExt = (UINT)(((lParam) & 0x01ff0000) >> 16))
