/*****************************************************/
/* remap.c                                           */
/* -- Program performs keyboard remapping.           */
/* -- To build: cc -d -DSTRICT remap.c keymap.lib    */
/*****************************************************/
#include <windows.h>
#include <windowsx.h>
#include "remap.h"
#include "keymap.h"

const KRI  kriNull;

BOOL CALLBACK __export FDlgProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK __export LwKeyProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam);
void UpdateDlg(HWND hwnd, KRI *pkri);

LRESULT CALLBACK __export LwKeyProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Custom control gathers virtual keycodes.       */
/*****************************************************/
    {
    PAINTSTRUCT wps;
    RECT        rect;
    char        szBuf[2];
    KEY         key;

    switch (wm)
        {
    default:
        break;

    case WM_GETDLGCODE:
        return DLGC_WANTARROWS | DLGC_WANTTAB |
          DLGC_WANTALLKEYS;

    case WM_SETTEXT:
    case WM_SETFOCUS:
    case WM_KILLFOCUS:
        InvalidateRect(hwnd, NULL, TRUE);
        break;

    case WM_LBUTTONDOWN:
        SetFocus(hwnd);
        return 0;

    case WM_KEYDOWN:
    case WM_SYSKEYDOWN:
        GetKeyMsg(key, wParam, lParam);
        SendMessage(GetParent(hwnd), WM_COMMAND,
          GetWindowWord(hwnd, GWW_ID),
          MAKELONG(hwnd, &key));
        szBuf[0] = (BYTE)wParam;
        szBuf[1] = 0;
        SetWindowText(hwnd, szBuf);
        break;

    case WM_PAINT:
        BeginPaint(hwnd, &wps);
        GetWindowText(hwnd, szBuf, 2);
        GetClientRect(hwnd, &rect);
        SelectObject(wps.hdc,
          GetStockObject(NULL_BRUSH));
        DrawText(wps.hdc, szBuf, -1, &rect,
          DT_CENTER | DT_SINGLELINE | DT_VCENTER);
        Rectangle(wps.hdc, rect.left, rect.top,
          rect.right, rect.bottom);
        if (GetFocus() == hwnd)
            {
            InflateRect(&rect,
              -GetSystemMetrics(SM_CXBORDER),
              -GetSystemMetrics(SM_CYBORDER));
            DrawFocusRect(wps.hdc, &rect);
            }
        EndPaint(hwnd, &wps);
        return 0;
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }

int PASCAL WinMain(HINSTANCE hins, HINSTANCE hinsPrev,
  LPSTR lpsz, int wShow)
/*****************************************************/
/* -- Entry point.                                   */
/*****************************************************/
    {
    if (NULL == hinsPrev)
        {
        WNDCLASS wcs;

        wcs.style = 0;
        wcs.lpfnWndProc = LwKeyProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hins;
        wcs.hIcon = NULL;
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = NULL;
        wcs.lpszClassName = szKeyClass;
        if (!RegisterClass(&wcs))
            return FALSE;
        }

    DialogBox(hins, MAKEINTRESOURCE(dlgMap), NULL,
      FDlgProc);
    return 0;
    }

BOOL CALLBACK __export FDlgProc(HWND hwnd,
  UINT wm, WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- Key mapping dialog procedure.                  */
/*****************************************************/
    {
    static KRI kri;

    switch (wm)
        {
    default:
        break;

    case WM_INITDIALOG:
        kri = kriNull;
        FNextKri(&kri, NULL);
        UpdateDlg(hwnd, &kri);
        return TRUE;

    case WM_ACTIVATE:
        FMapEnable(0 == wParam);
        break;

    case WM_COMMAND:
        switch (wParam)
            {
        default:
            break;

        case cidFrom:
            kri.keyFrom = *(KEY *)HIWORD(lParam);
            if (!FGetKri(&kri))
                kri.keyTo = kriNull.keyTo;
            UpdateDlg(hwnd, &kri);
            break;

        case cidTo:
            kri.keyTo = *(KEY *)HIWORD(lParam);
            UpdateDlg(hwnd, &kri);
            break;

        case IDOK:
            if (!FSetKri(&kri))
                MessageBox(hwnd, "Can't set mapping",
                  "Map Key", MB_OK);
            break;

        case cidClear:
            FRemoveKey(&kri.keyFrom);
            if (!FNextKri(&kri, &kri.keyFrom))
                kri = kriNull;
            UpdateDlg(hwnd, &kri);
            break;

        case cidClearAll:
            ResetMap();
            kri = kriNull;
            UpdateDlg(hwnd, &kri);
            break;

        case cidNext:
            FNextKri(&kri, &kri.keyFrom);
            UpdateDlg(hwnd, &kri);
            break;

        case IDCANCEL:
            EndDialog(hwnd, wParam);
            return TRUE;
            }  /* End switch wParam. */
        break; /* End case WM_COMMNAND. */
        }      /* End switch wm. */

    return FALSE;
    }

void UpdateDlg(HWND hwnd, KRI *pkri)
/*****************************************************/
/* -- Update the dialog controls with the new kri.   */
/*****************************************************/
    {
    char szBuf[5];

    szBuf[1] = 0;
    szBuf[0] = (BYTE)pkri->keyFrom.vkc;
    SetDlgItemText(hwnd, cidFrom, szBuf);
    szBuf[0] = (BYTE)pkri->keyTo.vkc;
    SetDlgItemText(hwnd, cidTo, szBuf);
    SetDlgItemInt(hwnd, cidFromNum, pkri->keyFrom.vkc,
      FALSE);
    SetDlgItemInt(hwnd, cidToNum, pkri->keyTo.vkc,
      FALSE);
    wsprintf(szBuf, "0x%x", (UINT)pkri->keyFrom.wExt);
    SetDlgItemText(hwnd, cidScanFrom, szBuf);
    wsprintf(szBuf, "0x%x", (UINT)pkri->keyTo.wExt);
    SetDlgItemText(hwnd, cidScanTo, szBuf);
    }
